#include "gph_ansi.h"
#include "gph_str.h"
#include "cont_str.h"
#include <string.h>

static ByTe_1 rcsid[] = "$Id: InitContStructs.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

void InitContStructs ()
{
   extern struct cont_info cinfo;
   extern struct cont_disp cdisp;
   extern struct cont_alloc cal;
   extern struct three_d_cut cut;
   extern struct cont_map c_map;

/**************************************************************************/
/*  Fill in some sane values for the cinfo structure                      */
/**************************************************************************/

   cinfo.dev = 0;              /* output device                              */
   cinfo.init_dev = 0;         /* initial device opened for menu options     */
   cinfo.nr = 40;              /* number of rows in contour mesh             */
   cinfo.nc = 40;              /* number of columns in contour mesh          */
   cinfo.gridsize = 1600;      /* (nr * nc) --- number of contour mesh pts   */
   cinfo.numseg = 0;           /* number of segments in gridding             */
   cinfo.cyclic = 0;           /* is the data cyclic or not (1/0)            */
   cinfo.wgt = 2.0;            /* exponent of denominator in weighting       */
   cinfo.plot_fmt = 1;         /* type of cartesian, carteographic           */
   cinfo.data_type = 1;        /* type of data -- random                     */
   cinfo.numlevels = 10;       /* number of contour levels inclusive         */
   cinfo.stepsize = 1.0;       /* step size of contour levels                */
   cinfo.begin = 0.0;          /* beginning value of contour levels          */
   cinfo.finish = 9.0;         /* ending value of contour levels             */
   cinfo.NFmt = 0;             /* neighbors format -  triangle               */ 
   cinfo.FillFmt = 1;          /* Sink Bad Data                              */ 
   cinfo.Norder = 0;           /* order with neighbor accumulation format    */
   cinfo.NbegX = 0;            /* offset to column for neighbor accumulation */
   cinfo.NbegY = 0;            /* offset to row for neighbor accumulation    */
   cinfo.NlenX = 0;            /* accumulate neighbors this far in X         */
   cinfo.NlenY = 0;            /* accumulate neighbors this far in X         */
   cinfo.Nbors = 4;            /* number of neighbors for least sq           */
   cinfo.order = 1;            /* least square fit order - linear            */
   cinfo.xmin = 0.0;           /* minimum x value for window                 */
   cinfo.ymin = 0.0;           /* minimum y value for window                 */
   cinfo.xmax = 1.0;           /* maximum x value for window                 */
   cinfo.ymax = 1.0;           /* maximum y value for window                 */
   cinfo.xstep = .025;         /* size of increments for steps on the window */
   cinfo.ystep = .025;         /* size of increments for steps on the window */
   cinfo.MinR = 1.0;           /* min distance from point to be included     */ 
   cinfo.rank = 3;             /* matrix rand used in least sq interpolation */
   cinfo.XYrank = 6;           /* independent elem used in least sq fit      */
   cinfo.X = 10;               /* points along X in data grid                */
   cinfo.Y = 10;               /* points along Y in data grid                */
   cinfo.calls = 0;            /* # of calls to recursive                    */
   cinfo.clevel = 0.0;         /* current level that is being contoured      */
   cinfo.Ltol = -1.0e30;       /* lower level data cutoff                    */
   cinfo.Utol = 1.0e30;        /* upper level data cutoff                    */
   cinfo.same = 0;             /* sets of data have the same x,y vals        */
   cinfo.second = 0;           /* program called yet? -  no                  */
   cinfo.save_grid = 0;        /* save the grid data? - no                   */
   cinfo.three_d = 0;          /* Data is 2D                                 */
   cinfo.N = 0;                /* Number of data points                      */
   cinfo.MinR = 1.0e30;        /* Minimum Distance                           */
   cinfo.MinRFmt = 'A';        /* Minimum Distance Format is Absolute        */
   cinfo.NQuads = 4;           /* 4 quads required - point surrounded        */
   cinfo.MinCD = -180.0;       /* Minimum cyclic discontinuous boundary      */
   cinfo.MaxCD = 180.0;        /* Maximum cyclic discontinuous boundary      */
   cinfo.CDdis = 360.0;        /* Cyclic discontinuous length                */
   cinfo.xgridsca = 0;         /* Grid scale to Linear                       */
   cinfo.ygridsca = 0;         /* Grid scale to Linear                       */
   cinfo.hold_grid = 0;        /* always new grid                            */

/**************************************************************************/
/*  Fill in some sane values for the cont_disp structure                  */
/**************************************************************************/

   strcpy (cdisp.cnt_fmt, "%.1f"); /* format for the contour line numbers   */
   cdisp.output = 0;           /* output contour as lines                   */ 
   cdisp.Cs = 0;               /* linear scaling to be used in contour      */
   cdisp.Cs = 0;               /* don't ignore zeros                        */
   cdisp.LnSz = 10;            /* linear number sizes                       */
   cdisp.colmax = -1.0;        /* the maximum color value for color_bar     */
   cdisp.colmin = -1.0;        /* the minimum color value for color_bar     */
   cdisp.show_cbar = 0;        /* don't show the color bar                  */
   strcpy (cdisp.sh_dat_fmt, "%.1f");  /* format used to display data       */
   cdisp.show_grid = 0;        /* don't show the contour mesh               */
   cdisp.times = 1;            /* 1 label per contour line                  */
   cdisp.lin_inc = 1;          /* label every third contour lines           */
   cdisp.grid_color = 7;       /* output contour mesh in black              */
   cdisp.data_color = 7;       /* output data mesh in black                 */
   cdisp.num_on = 0;           /* don't label contour lines                 */
   cdisp.smooth = 2;           /* smoothing factor for color contours       */
   cdisp.normal = 0;           /* color contour lines in white              */

/**************************************************************************/
/*  Null out all entries in the cont_alloc structure                      */
/**************************************************************************/

   cal.totbytes = 0;           /* bytes used in allocing necess arrays      */
   cal.totsave = 0;            /* bytes used in allocing save array         */
   cal.initmem = 0;            /* base address of malloced memory           */
   cal.remem = 0;              /* base address of save memory               */
   cal.z = 0;                  /* Contout mesh intensity values             */
   cal.Mx = 0;                 /* x positions of nearest neighbors          */
   cal.My = 0;                 /* y positions of nearest neighbors          */
   cal.Mz = 0;                 /* z positions of nearest neighbors          */
   cal.Mv = 0;                 /* intensity values of nearest neighbors     */
   cal.d = 0;                  /* distance from grid mesh nearest neighbors */
   cal.weight = 0;             /* weighting for nearest neighbors           */
   cal.PlAng = 0;              /* angles of data planes/cones (3D)          */
   cal.Velem = 0;              /* holds intensity solution in least sq      */
   cal.XYelem = 0;             /* holds independent variables in least sq   */
   cal.Mat = 0;                /* holds base matrix in least sq             */
   cal.id = 0;                 /* holds tmp array indices of nearest nb     */
   cal.save = 0;               /* positions for same xy plots               */
   cal.seg = 0;                /* holds segment info                        */
   cal.bad = 0;                /* holds countour mesh point status          */
   cal.dQ = 0;                 /* holds data quality                        */

/**************************************************************************/
/*  Fill in some sane values for the three_d_cut structure                */
/**************************************************************************/

   cut.Phi = 0.0;              /* rotation about x axis -- 0 -> 180 degs    */
   cut.Theta = 0.0;            /* rotation about y axis -- 0 -> 180 degs    */
   cut.TransX = 0.0;           /* translation w/respect to original x axis  */
   cut.TransY = 0.0;           /* translation w/respect to original y axis  */
   cut.TransZ = 0.0;           /* translation w/respect to original z axis  */
   cut.R[0]  = 1.0;            /* diagonal of rotation matrix               */
   cut.R[1]  = 0.0;            /* off- diagonal of rotation matrix          */
   cut.R[2]  = 0.0;            /* off- diagonal of rotation matrix          */
   cut.R[3]  = 1.0;            /* translation element in rotation matrix    */
   cut.R[4]  = 1.0;            /* diagonal of rotation matrix               */
   cut.R[5]  = 0.0;            /* off- diagonal of rotation matrix          */
   cut.R[6]  = 0.0;            /* off- diagonal of rotation matrix          */
   cut.R[7]  = 1.0;            /* translation element in rotation matrix    */
   cut.R[8]  = 1.0;            /* diagonal of rotation matrix               */
   cut.R[9]  = 0.0;            /* off- diagonal of rotation matrix          */
   cut.R[10] = 0.0;            /* off- diagonal of rotation matrix          */
   cut.R[11] = 1.0;            /* translation element in rotation matrix    */


/**************************************************************************/
/*  Fill in some sane values for the cont_map structure                   */
/**************************************************************************/

  c_map.projection = 3;        /* map projection                            */
  c_map.map = 1;               /* map overlays contour                      */
  c_map.grid_lat = 10.0;       /* latitude lines ever 10 degrees            */
  c_map.grid_long = 10.0;      /* longitude lines ever 10 degrees           */
  c_map.map_res = 40;          /* output only every 40th map point          */
  c_map.lat_off = 0.0;         /* latitude offset (moves map center)        */
  c_map.long_off = 0.0;        /* longitude offset (moves map center)       */
  c_map.rotation = 0.0;        /* rotation - used in azumuthal projections  */
  c_map.Gcolor = 0;            /* map grid color - white                    */
  c_map.Mcolor = 0;            /* map outline color - white                 */
}
