#include <math.h>
#include <stdio.h>
#include "cont_str.h"
#include "gph_ansi.h"
#define MOD(a,b) (((a)/(b)-(int)((a)/(b)))*(b))
#define FUDGE 10000.01

static ByTe_1 rcsid[] = "$Id: Init3DStuff.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

void Init3DStuff(ReaL_4 *x, ReaL_4 *y, ReaL_4 *z)
{
   extern struct cont_info cinfo;
   extern struct three_d_cut cut;

   register ReaL_4 *fX, *fY, *fZ, *fend, X, Y, Z;

   ReaL_4 TmPx, TmPy;

   /**********************************************************************/
   /*  Form the rotation matrix which is a 4x4 matrix stored in the form */
   /*                                                                    */
   /*                    R[00]  R[01]   R[03]   R[03]                    */
   /*                    R[04]  R[05]   R[06]   R[07]                    */
   /*                    R[08]  R[09]   R[10]   R[11]                    */
   /*                                                                    */
   /*  The last element in each row is the translational element and the */
   /*  positional vectors have the form [X Y Z 1]                        */
   /**********************************************************************/

   if (!cinfo.three_d)
      return;

   cut.R[0]  = cosin (cut.Phi) * cosin (cut.Theta);
   cut.R[1]  = sine (cut.Phi) * cosin (cut.Theta);
   cut.R[2]  = sine (cut.Theta);
   cut.R[3]  = -cut.TransX;

   TmPx = -cosin (cut.Phi) * sine (cut.Theta);
   TmPy = -sine (cut.Phi) * sine (cut.Theta);

   cut.R[4]  = -sine (cut.Phi) * cosin (cut.Rho) + TmPx * sine (cut.Rho);
   cut.R[5]  = cosin (cut.Phi) * cosin (cut.Rho) + TmPy * sine (cut.Rho);
   cut.R[6]  = cosin (cut.Theta) * sine (cut.Rho);
   cut.R[7]  = -cut.TransY;

   cut.R[8]  = -sine (cut.Phi) * sine (cut.Rho) + TmPx * cosin (cut.Rho);
   cut.R[9]  = cosin (cut.Phi) * sine (cut.Rho) + TmPy * cosin (cut.Rho);
   cut.R[10] = cosin (cut.Theta) * cosin (cut.Rho);
   cut.R[11] = -cut.TransZ;

   /**********************************************************************/
   /* Rotate and translate the input (X Y Z) coordinates to the new      */
   /* coordinate system in which the plane being plotted is the XY plane */
   /*                                                                    */
   /* How this works and what it does:                                   */
   /*                                                                    */
   /* Given a vector represented by phi = P and theta = T.  The object   */
   /* of this exercise is to rotate that vector onto the x axis.  In     */
   /* reality we may want to rotate on to some other axis.  The contour  */
   /* plots data closest to the original xy plane and sometime its nice  */
   /* to have the vector perpendicular to this plane.  Note that what we */
   /* are really doing here is rotating the entire 3D distribution as we */
   /* rotate the vector.  Note that T is measured from the xy plane,     */
   /* positive towards +z and negative towards -z.                       */
   /*                                                                    */
   /* The first rotation is about the Z axis through an angle P.  The    */
   /* rotation is clockwise taking x -> -y and y -> x.  The rotation     */
   /* matrix is:                                                         */
   /*                                                                    */
   /*                       --                          --               */
   /*                       |   cos(P)   sin(P)     0.0  |               */
   /*                       |  -sin(P)   cos(P)     0.0  |               */
   /*                       |      0.0      0.0     1.0  |               */
   /*                       --                          --               */
   /*                                                                    */
   /* The vector now lies in the xz plane.  The next rotation is about   */
   /* the new y' axis (new Y axis) and will map the vector onto the      */
   /* x-axis.   The rotation matrix is:                                  */
   /*                                                                    */
   /*                       --                           --              */
   /*                       |   cos(T)      0.0   sin(T)  |              */
   /*                       |      0.0      1.0      0.0  |              */
   /*                       |  -sin(T)      0.0   cos(T)  |              */
   /*                       --                           --              */
   /*                                                                    */
   /* This rotation takes x -> -z and z -> x.                            */
   /*                                                                    */
   /* The last rotation is about the new x axis.  The keeps the vector   */
   /* aligned with the x axis but allows different slices to be taken.   */
   /* This rotation angle is refered to as rho (R).  Its rotation        */
   /* matrix is given as:                                                */
   /*                                                                    */
   /*                       --                           --              */
   /*                       |      1.0      0.0      0.0  |              */
   /*                       |      0.0    cos(R)  sin(R)  |              */
   /*                       |      0.0   -sin(R)  cos(R)  |              */
   /*                       --                           --              */
   /*                                                                    */
   /* This rotation takes y -> z and z -> -y.                            */
   /**********************************************************************/

   fend = x + cinfo.N;                           /* end of input data    */
   fX = x;                                       /* ptr to X coordinates */
   fY = y;                                       /* ptr to Y coordinates */
   fZ = z;                                       /* ptr to Z coordinates */
   for ( ; fX < fend; )                          /* loop over data       */
   {
      X = *fX;                                   /* temporary X          */
      Y = *fY;                                   /* temporary Y          */
      Z = *fZ;                                   /* temporary Z          */
      *fX++ = X*cut.R[0] + Y*cut.R[1] + Z*cut.R[2] + cut.R[3];
      *fY++ = X*cut.R[4] + Y*cut.R[5] + Z*cut.R[6] + cut.R[7];
      *fZ++ = X*cut.R[8] + Y*cut.R[9] + Z*cut.R[10] + cut.R[11];
   }
}
