#include "cont_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: GatherSqNcyc.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 GatherSqNcyc (ReaL_4 *v, ReaL_4 *x, ReaL_4 *y, ReaL_4 *z, ReaL_4 Xm, 
                     ReaL_4 Ym, ReaL_4 Zm, ByTe_4 C1, ByTe_4 C2)
{
   extern struct cont_info cinfo;
   extern struct cont_alloc cal;
   register ReaL_4 *f1, *f2, *f4, *f5, *f6;
   ReaL_4 D;
   ReaL_4 dx, dy;
   ByTe_4 P, Px, pnts = 0;
   ByTe_4 i, j, BegC;
   ByTe_4 Xend, Yend, Ylen;
   ByTe_4 Dc;

   f1 = cal.Mx;
   f2 = cal.My;
   f4 = cal.Mv;
   f5 = cal.d;
   f6 = cal.weight;

/*****************************************************************************/
/*  If not 3D then do this to pick up the data to be used in the least       */
/*  squares fit.                                                             */
/*****************************************************************************/

   if (!cinfo.three_d)
   {
      dx = x[C1] - Xm;                          /* mesh pt to close pt in X  */ 
      dy = y[C1] - Ym;                          /* mesh pt to close pt in Y  */
      D = dx * dx + dy * dy;                    /* mesh pt to close pt dist  */
      
      Px = C2 + cinfo.NbegX;                    /* X pos of data             */
      BegC = Px / cinfo.Y;                      /* Data begs in this column  */
      P = Px + cinfo.NbegY;                     /* loc to beg to get data    */
      Xend = cinfo.NlenX/2;                     /* half of scan in X         */
      Ylen = cinfo.NlenY;                       /* length of 1st Y scan      */
      
      for (j = 0; j < Xend; ++j)                /* loop over columns         */ 
      {
         if (Px >= 0 && BegC < cinfo.X)         /* column in data grid?      */
         {                                      /* yes!                      */
            Yend = P + Ylen;                    /* top row of data to get    */
            for (i = P; i < Yend; ++i)          /* loop ovr rows             */
            {
               Dc = i / cinfo.Y;                /* current data column       */ 
               if (Dc == BegC && P >= 0 && cal.dQ[i] > 0) /* data in col?    */
               {                                /* yes!                      */
                  *f1 = x[i] - Xm;              /* relative x pos of data    */
                  *f2 = y[i] - Ym;              /* relative y pos of data    */
                  *f4++ = v[i];                 /* VALUE OF DATA             */
                  *f5 = *f1 * *f1 + *f2 * *f2;  /* distance to grid          */
                  ++f1;                         /* inc x position ptr        */
                  ++f2;                         /* inc y postion ptr         */
                  *f6++ = get_wgt (D / *f5++);  /* compute weighting         */
                  ++pnts;                       /* inc points in array       */
               }
            }
         }

         Px += cinfo.Y;                         /* move over 1 column        */
         BegC = Px / cinfo.Y;                   /* Data begs in this column  */
         if (Ylen < cinfo.NlenX)                /* Y len less than X len?    */
         {                                      /* yes                       */
            P += cinfo.Y - 1;                   /* start loc over and down   */
            Ylen += 2;                          /* column length up by 2     */
         }
         else
            P += cinfo.Y;                       /* start loc over one col    */
      }     

      Px = C2 - cinfo.NbegX;                    /* right col X pos of data   */
      BegC = Px / cinfo.Y;                      /* Data begs in this column  */
      P = Px + cinfo.NbegY;                     /* loc to beg to get data    */
      
      for (j = 0; j < Xend; ++j)                /* loop over columns         */ 
      {
         if (BegC >= 0 && BegC < cinfo.X)       /* column in data grid?      */
         {                                      /* yes!                      */
            Yend = P + Ylen;                    /* top row of data to get    */
            for (i = P; i < Yend; ++i)          /* loop ovr rows             */
            {
               Dc = i / cinfo.Y;                /* current data column       */ 
               if (Dc == BegC && P >= 0 && cal.dQ[i] > 0) /* data in col?    */
               {                                /* yes!                      */
                  *f1 = x[i] - Xm;              /* relative x pos of data    */
                  *f2 = y[i] - Ym;              /* relative y pos of data    */
                  *f4++ = v[i];                 /* VALUE OF DATA             */
                  *f5 = *f1 * *f1 + *f2 * *f2;  /* distance to grid          */
                  ++f1;                         /* inc x position ptr        */
                  ++f2;                         /* inc y postion ptr         */
                  *f6++ = get_wgt (D / *f5++);  /* compute weighting         */
                  ++pnts;                       /* inc points in array       */
               }
            }
         }

         --BegC;                                /* shift over one column     */
         if (Ylen < cinfo.NlenX)                /* Y len less than X len?    */
         {                                      /* yes                       */
            P -= cinfo.Y - 1;                   /* start loc over and down   */
            Ylen += 2;                          /* column length up by 2     */
         }
         else
            P -= cinfo.Y;                       /* start loc over one col    */
      }     
   }   

   return (pnts);
}
