#include "cont_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: GatherParam.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

/**************************************************************************/
/*  This routine sets up the pattern to be used in picking up the nearest */
/*  neighbors for use in the least square fit in setting up the contour   */
/*  mesh.  This is only really necessary for rectangular or spiral data   */
/*                                                                        */
/*  There are three basic patterns.  These are shown below together with  */
/*  several orders or enlargements for each pattern                       */
/*                                                                        */
/*                             TRIANGLE                                   */
/*                                                                        */
/*                                          2                             */
/*                                                                        */
/*                                       2  2                             */
/*                                                                        */
/*                                    2  1  2                             */
/*                                                                        */
/*                                 2  0  1  2                             */
/*                                                                        */
/*                              2  0  0  1  2                             */
/*                                                                        */
/*                           2  1  1  1  1  2                             */
/*                                                                        */
/*                        2  2  2  2  2  2  2                             */
/*                                                                        */
/*                                                                        */
/*                             DIAMOND                                    */
/*                                                                        */
/*                                                                        */
/*                       9  8  7  6  7  8  9                              */
/*                                                                        */
/*                       8  5  4  3  4  5  8                              */
/*                                                                        */
/*                       7  4  2  1  2  4  7                              */
/*                                                                        */
/*                       6  3  1  0  1  3  6                              */
/*                                                                        */
/*                       7  4  2  1  2  4  7                              */
/*                                                                        */
/*                       8  5  4  3  4  5  8                              */
/*                                                                        */
/*                       9  8  7  6  7  8  9                              */
/*                                                                        */
/*                                                                        */
/*                             SQUARE                                     */
/*                                                                        */
/*                                                                        */
/*                                                                        */
/*                        5  4  3  3  4  5                                */
/*                                                                        */
/*                        4  2  1  1  2  4                                */
/*                                                                        */
/*                        3  1  0  0  1  3                                */
/*                                                                        */
/*                        3  1  0  0  1  3                                */
/*                                                                        */
/*                        4  2  1  1  2  4                                */
/*                                                                        */
/*                        5  4  3  3  4  5                                */
/*                                                                        */
/**************************************************************************/
 
void GatherParam()
{
  extern struct cont_info cinfo;
  register ByTe_2 i, j;
  register ByTe_4 N;
  ByTe_2 end, Grp;
  ByTe_2 Xend, Ylen;

  Grp = 0;
  end = 2;
   
  switch (cinfo.data_type)
  {
     case 0:
     case 1:
        if (cinfo.Nbors == 0)
        {
           cinfo.NFmt = 3;
           cinfo.Nbors = cinfo.N;
           cinfo.NlenX = cinfo.X;
           cinfo.NlenY = cinfo.Y;
        }
     break;
     case 2:
        cinfo.Nbors = 0; 
        switch (cinfo.NFmt)
        {
           case 0:
              if (cinfo.Norder == 0)
              {
                 cinfo.NbegX = -cinfo.Y;
                 cinfo.NbegY = 0;
                 cinfo.NlenX = 2;
                 cinfo.NlenY = 1;
                 cinfo.Nbors = 3;
              }
              else
              {
                 cinfo.NbegX = -2 * cinfo.Norder * cinfo.Y;
                 cinfo.NbegY = -cinfo.Norder;
                 cinfo.NlenX = 3 * cinfo.Norder + 1;
                 cinfo.NlenY = 1;
                 N = cinfo.NlenX;
                 cinfo.Nbors = N * N / 2 + (N + 1) / 2;
              }
           break;
 
           case 1:
              for (i = 0; i < cinfo.Norder;)
              {
                 for (j = 0; j < end; ++j)
                     ++i;
                 ++Grp;
                 ++end;
              }
              cinfo.NbegX = -Grp * cinfo.Y;
              cinfo.NbegY = -(Grp - i + cinfo.Norder);
              cinfo.NlenX = 2 * Grp + 1;
              cinfo.NlenY = 2 * (Grp - i + cinfo.Norder) + 1;
          
              Xend = cinfo.NlenX/2 + 1;
              Ylen = cinfo.NlenY; 
              for (j = 0; j < Xend; ++j)
              {
                  cinfo.Nbors += Ylen;
                  if (Ylen < cinfo.NlenX)
                     Ylen += 2;
              }
              cinfo.Nbors = 2 * cinfo.Nbors - cinfo.NlenX;
           break;

           case 2:
              for (i = 0; i < cinfo.Norder;)
              {
                 for (j = 0; j < end; ++j)
                     ++i;
                 ++Grp;
                 ++end;
              }
              cinfo.NbegX = -Grp * cinfo.Y;
              cinfo.NbegY = Grp - i - cinfo.Norder;
              cinfo.NlenX = 2 * Grp + 2;
              cinfo.NlenY = 2 * (Grp - i + cinfo.Norder) + 2;

              Xend = cinfo.NlenX/2;
              Ylen = cinfo.NlenY; 
              for (j = 0; j < Xend; ++j)
              {
                  cinfo.Nbors += Ylen;
                  if (Ylen < cinfo.NlenX)
                     Ylen += 2;
              }
              cinfo.Nbors *= 2;
          break;
        }
     break;
  }

  if (cinfo.NlenX > cinfo.X || cinfo.NlenY > cinfo.Y)
  {
     cinfo.NFmt = 3;
     cinfo.Nbors = cinfo.N;
     cinfo.NlenX = cinfo.X;
     cinfo.NlenY = cinfo.Y;
  }
}
