#include "cont_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: GatherDiaDcyc.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 GatherDiaDcyc (ReaL_4 *v, ReaL_4 *x, ReaL_4 *y, ReaL_4 *z, ReaL_4 Xm, 
                     ReaL_4 Ym, ReaL_4 Zm, ByTe_4 C)
{
   extern struct cont_info cinfo;
   extern struct cont_alloc cal;
   register ReaL_4 *f1, *f2, *f4, *f5, *f6;
   ReaL_4 D;
   ReaL_4 dx, dy, Hwv, NHwv, Wv;
   ByTe_4 P, Px, pnts = 0;
   ByTe_4 i, j, BegC;
   ByTe_4 Xend, Yend, Ylen, Ncol;
   ByTe_4 Dgrid;
   ByTe_4 dC;

   Dgrid = cinfo.X * cinfo.Y;
   Hwv = cinfo.CDdis;
   NHwv = -Hwv;
   Wv = 2 * Hwv;
   f1 = cal.Mx;
   f2 = cal.My;
   f4 = cal.Mv;
   f5 = cal.d;
   f6 = cal.weight;

/*****************************************************************************/
/*  If not 3D then do this to pick up the data to be used in the least       */
/*  squares fit.                                                             */
/*****************************************************************************/

   if (!cinfo.three_d)
   {
      dx = DisCycTest (x[C], Xm, Hwv, NHwv, Wv); /* relative X of closest pt */
      dy = y[C] - Ym;                           /* mesh pt to close pt in Y  */
      D = dx * dx + dy * dy;                    /* mesh pt to close pt dist  */
      
      Px = C + cinfo.NbegX;                     /* X pos of data             */
      if (Px < 0)                               /* off left of data mesh?    */
      {                                         /* yes!                      */
         Ncol = Px / cinfo.Y;                   /* data is in this col       */
         BegC = cinfo.X + Ncol - 1;             /* wrap around to this col   */ 
         Px += Dgrid;                           /* new Px                    */ 
      }
      else
         BegC = Px / cinfo.Y;                   /* Data begs in this column  */

      P = Px + cinfo.NbegY;                     /* loc to beg to get data    */
      Xend = cinfo.NlenX/2 + 1;                 /* half of scan in X         */
      Ylen = cinfo.NlenY;                       /* length of 1st Y scan      */
      
      for (j = 0; j < Xend; ++j)                /* loop over columns         */ 
      {
         if (BegC >= cinfo.X)                   /* column in data grid?      */
         {                                      /* no!                       */
            BegC -= cinfo.X;                    /* wrap it around            */
            P -= Dgrid;                         /* change P                  */
         }
         
         Yend = P + Ylen;                       /* top row of data to get    */
         for (i = P; i < Yend; ++i)             /* loop ovr rows             */
         {
            dC = i / cinfo.Y;                   /* col data is in            */
            if (dC == BegC && cal.dQ[i] > 0)    /* data in beg col and ok?   */
            {                                   /* yes!                      */
               *f1 = DisCycTest (x[i], Xm, Hwv, NHwv, Wv); /* relative X pos */
               *f2 = y[i] - Ym;                 /* relative y pos of data    */
               *f5 = *f1 * *f1 + *f2 * *f2;     /* distance to grid          */
               if (*f5 < cinfo.MinR)            /* data ok?                  */
               {                                /* yes - this data is ok     */
                  *f4++ = v[i];                 /* VALUE OF DATA             */
                  ++f1;                         /* inc x position ptr        */
                  ++f2;                         /* inc y postion ptr         */
                  *f6++ = get_wgt (D / *f5++);  /* compute weighting         */
                  ++pnts;                       /* inc points in array       */
               }
            }
         }

         ++BegC;                                /* Data moves to this column */
         if (Ylen < cinfo.NlenX)                /* Y len less than X len?    */
         {                                      /* yes                       */
            P += cinfo.Y - 1;                   /* start loc over and down   */
            Ylen += 2;                          /* column length up by 2     */
         }
         else
            P += cinfo.Y;                       /* start loc over one col    */
      }     

      Px = C - cinfo.NbegX;                     /* right col X pos of data   */
      BegC = Px / cinfo.Y;                      /* Data begs in this column  */
      if (BegC >= cinfo.X)                      /* column in data grid?      */
      {                                         /* no!                       */
         BegC -= cinfo.X;                       /* wrap it around            */
         Px -= Dgrid;                           /* change P                  */
      }
      P = Px + cinfo.NbegY;                     /* loc to beg to get data    */
      Xend = cinfo.NlenX/2;                     /* half of scan in X         */
      
      for (j = 0; j < Xend; ++j)                /* loop over columns         */ 
      {
         if (BegC < 0)                          /* column wrapped?           */
         {                                      /* yes!                      */
            BegC += cinfo.X;                    /* column is now             */
            P += Dgrid;                         /* data location is now      */
         }
         
         Yend = P + Ylen;                       /* top row of data to get    */
         for (i = P; i < Yend; ++i)             /* loop ovr rows             */
         {
            dC = i / cinfo.Y;                   /* col data is in            */
            if (dC == BegC && cal.dQ[i] > 0)    /* data in beg col and ok?   */
            {                                   /* yes!                      */
               *f1 = DisCycTest (x[i], Xm, Hwv, NHwv, Wv); /* relative X pos */
               *f2 = y[i] - Ym;                 /* relative y pos of data    */
               *f5 = *f1 * *f1 + *f2 * *f2;     /* distance to grid          */
               if (*f5 < cinfo.MinR)            /* data ok?                  */
               {                                /* yes - this data is ok     */
                  *f4++ = v[i];                 /* VALUE OF DATA             */
                  ++f1;                         /* inc x position ptr        */
                  ++f2;                         /* inc y postion ptr         */
                  *f6++ = get_wgt (D / *f5++);  /* compute weighting         */
                  ++pnts;                       /* inc points in array       */
               }
            }
         }

         --BegC;                                /* shift over one column     */
         if (Ylen < cinfo.NlenX)                /* Y len less than X len?    */
         {                                      /* yes                       */
            P -= cinfo.Y - 1;                   /* start loc over and down   */
            Ylen += 2;                          /* column length up by 2     */
         }
         else
            P -= cinfo.Y;                       /* start loc over one col    */
      }     
   }   

   return (pnts);
}
