#include "cont_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: GatherCyc.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 GatherCyc (ReaL_4 *v, ReaL_4 *x, ReaL_4 *y, ReaL_4 *z, ReaL_4 Xm, 
                  ReaL_4 Ym, ReaL_4 Zm, ByTe_4 C1)
{
   extern struct cont_info cinfo;
   ByTe_4 N, Fmt;
   ByTe_4 pts[5];
   ByTe_1 S;

   if (!cinfo.three_d)                              /* 2D data?              */
   {                                                /* yes!                  */
      Fmt = cinfo.NFmt;                             /* mod gathering format  */
      switch (Fmt)                                  /* switch on mod fmt     */
      {
         case 0:                                    /* triangle gathering    */
            N = GatherTriDcyc (v, x, y, z, Xm, Ym, Zm, C1);
         break;
         case 1:                                    /* diamond gathering     */
            N = GatherDiaDcyc (v, x, y, z, Xm, Ym, Zm, C1);
         break;
         case 2:                                    /* square gathering      */
            if ((S = ClptsCyc (x, y, Xm, Ym, C1, pts)) >= 0)
               N = GatherSqDcyc (v, x, y, z, Xm, Ym, Zm, C1, pts[4]);
            else
               N = -1;
      }
   }   

   return (N);
}
