#include "gph_str.h"
#include "gph_ansi.h"
#include "cont_str.h"
#include "gph_shortcut_defs.h"

static ByTe_1 rcsid[] = "$Id: FormMesh.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

void FormMesh (ReaL_4 *v, ReaL_4 *x, ReaL_4 *y, ReaL_4 *z)
{
   extern struct cont_info cinfo;
   extern struct cont_alloc cal;
   register ReaL_4 *f1, *f2, *fend;

   switch (cinfo.data_type)
   {
      case 0:                                 /* Random 3D                   */
         Cleanse ();                          /* zero out seg and bad        */
         Random3D (v, x, y, z);               /* process it here             */
      break;

      case 3:                                 /* Hollow Grid                 */
         f1 = cal.z;                          /* pointer to mesh             */
         fend = f1 + cinfo.N;                 /* end of mesh                 */ 
         f2 = v;                              /* ptr to pregridded intensity */
         for ( ; f1 < fend; )                 /* loop over data              */
            *f1++ = *f2++;                    /* data to mesh                */

          if (cinfo.cyclic == 0)              /* data is cyclic?             */
             HollowNCyc (v,x,y);              /* no! process it here         */
          else
             HollowCyc (v,x,y);               /* yes! process it here        */
      break;

      case 1:                                 /* Random 2D                   */
         Cleanse ();                          /* zero out seg and bad        */
         if (cinfo.NFmt == 3)                 /* using all points?           */
            Random2DAll (v,x,y);              /* yes! process it here        */
         else
         {
            if (cinfo.cyclic == 0)            /* data is cyclic?             */
               Random2D (v,x,y);              /* no! process it here         */
            else
               Random2DCyc (v,x,y);           /* yes! process it here        */
         }
      break;
      case 2:                                 /* Ordered 2D data             */
         if (cinfo.cyclic == 0)               /* data is cyclic?             */
            OrderedNcyc (v,x,y,z);            /* so do this                  */
         else                                 /* not cyclic                  */
            OrderedCyc (v,x,y,z);             /* yes - this will do it       */
      break;
      case 4:                                 /* Pregridded data             */
         f1 = cal.z;                          /* pointer to mesh             */
         fend = f1 + cinfo.N;                 /* end of mesh                 */ 
         f2 = v;                              /* ptr to pregridded intensity */
         for ( ; f1 < fend; )                 /* loop over data              */
            *f1++ = *f2++;                    /* data to mesh                */
      break;
   }
}
