/*****************************************************************************/
/*  This routine determines maximum perpendicular distance of the contour    */
/*  segment through which the contour label is to be output, from the center */
/*  line of the label.  The routine returns the square of this distance.     */
/*  The line_num routine uses this value to determine if a label should be   */
/*  output which it will only if the entire contour segment is contained in  */
/*  the box which will be blanked out for the label.                         */
/*****************************************************************************/

#include <math.h>
#include "gph_str.h"
#include "gph_ansi.h"
#include "cont_str.h"

static ByTe_1 rcsid[] = "$Id: Excursion.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

ReaL_4 Excursion (ReaL_4 *BegX, ReaL_4 *EndX, ByTe_2 skp, ReaL_4 dX, ReaL_4 dY,
         ReaL_4 L)
{
   register ReaL_4 *fx, *fy, *fend;
   register ReaL_4 bX, bY;

   ReaL_8 Dm, D, Dx, Dy;
   ReaL_4 Md = -1.0;
   
   fx = BegX;                                     /* begin in X here         */
   fy = fx + 1;                                   /* begin in Y here         */
   fend = EndX;                                   /* end in X here           */

   bX = *fx;                                      /* 1st X position          */
   bY = *fy;                                      /* 1st Y position          */
   for ( ; fx <= fend; fx += skp, fy += skp)      /* loop over data          */
   {
      Dx = *fx - bX;                              /* translate Xmax by beg X */
      Dy = *fy - bY;                              /* translate Ymax by beg Y */
      D = Dx * Dx + Dy * Dy;                      /* vector len to max pnt   */
      Dm = dX * Dx + dY * Dy;                     /* dot prod: max with str  */
      Dm /= (Dm < 0.0) ? -L : L;                  /* get to absolute length  */
      Dm = D - Dm * Dm;                           /* perp len squared        */
      if (Dm > Md)                                /* maximum distance?       */
         Md = Dm;                                 /* yes - save it           */
   }                                              /* END PERP DIS LOOP       */
   
   return (Md);
}
