#include <math.h>
#include <string.h>
#include "gph_str.h"
#include "cont_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: DoLabels.c,v 1.1 1999/11/21 08:39:30 chris.gurgiolo.b2r Stab chrisg $";

void DoLabels ()
{
   extern struct config parm;
   extern struct cont_disp cdisp;
   extern struct cont_alloc cal;

   register ReaL_4 *fx, *fy, *fa, *fl, *fend;
   register ByTe_1 *c1;

   ReaL_4 X, Y, A;
   ReaL_4 cZ[2];
   ByTe_1  str[20];
   ByTe_1  W;

   if (cdisp.times > 0)
   {
      get_chsz (cZ);                               /* get character sizes    */

      W = cdisp.window;                            /* output window          */

      fx = cal.sX;                                 /* label X position array */
      fy = cal.sY;                                 /* label Y position array */
      fa = cal.sA;                                 /* label rot angle array  */
      fl = cal.sL;                                 /* label rot angle array  */
      fend = fl + cdisp.times;                     /* end of labels          */

      for ( ; fl < fend; )                         /* loop over labels       */
      {
         sprintf (str, cdisp.cnt_fmt, *fl++);      /* this is label          */
         {
            X = *fx++;                             /* current X lab position */
            Y = *fy++;                             /* current Y lab position */
            A = *fa++;                             /* current lab angle      */
                    
	    c1 = str;                              /* ptr to label string    */
	    while (*c1 != '\0' && *c1 == ' ')      /* remove leading blanks  */
	       ++c1;

            BlankOutLab (X, Y, A, c1, cZ);         /* blank out label box    */
            chr_dspl(W, X, Y, 0., A, 0., 0., 0, 0, c1, -1, cdisp.clab_color);
         }
      }
   }
}
