#include <string.h>
#include "cont_str.h"
#include "gph_ansi.h"

/*************************************************************************/
/*  This routine makes the check for cyclic data.  The relative X value  */
/*  is always kept at to a distance which is less than half a wavelength */
/*************************************************************************/

static ByTe_1 rcsid[] = "$Id: DisCycTest.c,v 1.1 1999/11/21 08:39:30 chris.gurgiolo.b2r Stab chrisg $";

ReaL_4 DisCycTest (ReaL_4 x, ReaL_4 Xm, ReaL_4 Hwv, ReaL_4 NHwv, ReaL_4 Wv)
{
   ReaL_4 Xr;

   Xr = x - Xm;                      /* the uncorrected relative X distance */

   if (Xr > Hwv)                     /* > half a wavelength positive?       */
      Xr -= Wv;                      /* yes - correct to shorter distance   */
   else                              /* that's ok - how about negative?     */    
      if (Xr < NHwv)                 /* < half a wavelength negative?       */ 
         Xr += Wv;                   /* yes - correct to shorter distance   */

   return (Xr);                      /* return true relative distance       */
}
