/***************************************************************************
 *                                                                         *
 *                   MATRIX DETERMINENT CALCULATION                        *
 *                                                                         *
 *  purpose                                                                *
 *    calculate the determinent of a square matrix                         *
 *                                                                         *
 *  usage                                                                  *
 *    float determ();                                                      *
 *    det = determ (mat,norder);                                           *
 *                                                                         *
 *  parameter description                                                  *
 *    float mat     matrix from which determinent is to be computed        *
 *    short norder  order of determinent (degree of matrix)                *
 *                                                                         *
 *  subprograms called                                                     *
 *    none                                                                 *
 *                                                                         *
 *  comments                                                               *
 *    the input matrix mat is distroyed                                    *
 *                                                                         *
 ***************************************************************************/
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: DeTerm.c,v 1.1 1999/11/21 08:39:30 chris.gurgiolo.b2r Stab chrisg $";

ReaL_8 DeTerm (ReaL_8 *matrix, ByTe_4 order)
{
   register ReaL_8 *d1, *d2, *d3, *d4, *d5;
   ReaL_8 *dend1, *dend2;
   ReaL_8 det;

   ByTe_4   diag;

   dend1 = matrix + order * order;
   dend2 = matrix;
   diag  = order + 1;

   det = 1.0;
   d1 = matrix;
   for (; d1 < dend1; d1 += diag) 
   {
       if (*d1 == 0.0)
          return (0.0);
       det *= *d1;
       d2 = d1 + order;
       d5 = d2 - order + 1;
       dend2 += order;
       for ( ; d2 < dend1; d2 += order)
          for (d3 = d2 + 1, d4 = d5; d4 < dend2;)
              *d3++ -= *d2 * *d4++ / *d1;
   }

   return (det);
}
