#include "cont_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: ClptsCyc.c,v 1.1 1999/11/21 08:39:30 chris.gurgiolo.b2r Stab chrisg $";

/*****************************************************************************/
/*  Determine the closest data points to the current grid point              */
/*                                                                           */
/*  (x, y)    are the input data coordinates                                 */
/*  (X, Y)    is the current mesh coordinate                                 */
/*  close     is the position in the input data array of the closest point   */
/*            to (X,Y)                                                       */
/*  P         are the returned 4 closest points                              */
/*****************************************************************************/

ByTe_1 ClptsCyc (ReaL_4 *x, ReaL_4 *y, ReaL_4 X, ReaL_4 Y, ByTe_4 close, 
                 ByTe_4 *P)
{
   register ByTe_4 *l1, *l2, *l3, *lend;
   register ByTe_2 C;

   ReaL_4 Rm[2], R1[2], R2[2], Rc[2]; 
   ByTe_4  Q[12], min;
   ByTe_4  Cl;
   ByTe_1  S;
   ByTe_1  Pn;

   Pn = QuadPntsCyc (close, Q);                      /* get pnts about close */
   min = close;                                      /* minimum point pos    */

   l3 = P;                                           /* ptr to cell points   */
   *l3++ = close;                                    /* 1st point in cell    */
   Rc[0] = x[close];                                 /* X val of close data  */
   Rc[1] = y[close];                                 /* Y val of close data  */
   Rm[0] = X;                                        /* Mesh X value         */
   Rm[1] = Y;                                        /* Mesh Y value         */

   l1 = Q;                                           /* ptr to right hor pnt */
   l2 = Q + 2;                                       /* ptr to upper ver pnt */
   lend = Q + 8;                                     /* last pos pointer     */
   for (C = 0; l2 < lend; l1 += 2, l2 += 2, ++C)     /* loop over vectors    */
   {
      if (*l1 > 0 && *l2 > 0)                        /* both vecs present?   */
      {                                              /* yes!                 */
         R1[0] = x[*l1];                             /* x comp of point R1   */
         R1[1] = y[*l1];                             /* y comp of point R1   */
         R2[0] = x[*l2];                             /* x comp of point R2   */
         R2[1] = y[*l2];                             /* y comp of point R2   */
         if ((S = InDataCell (Rc, Rm, R1, R2)) >= 0) /* data in cell?        */
         {                                           /* yes!                 */
            *l3++ = *l1++;                           /* 2nd data pnt in cell */
            *l3++ = *l1++;                           /* 3rd data pnt in cell */
            *l3++ = *l1++;                           /* 4th data pnt in cell */
            *l3 = Q[C + 8];                          /* minimum pos location */
            return (S);                              /* return status        */
         }
      }
   }

   Cl = GetPhantomCell (Pn, x, y, Rc, Rm, Q);        /* no cell - try this   */
   if (Cl >= 0)                                      /* got phantom cell?    */
   {                                                 /* yes                  */
      C = 2*Cl;                                      /* pos of next cell pnt */
      *l3++ = Q[C++];                                /* 2nd data pnt in cell */
      *l3++ = Q[C++];                                /* 3rd data pnt in cell */
      *l3++ = Q[C%8];                                /* 4th data pnt in cell */
      *l3 = Q[Cl + 8];                               /* minimum pos location */
      S = 3;                                         /* status - fantom cell */
   }
   else
      S = -1;                                        /* status - no cell     */
   return (S);                                       /* return status        */
}
