#include <math.h>
#include "gph_str.h"
#include "gph_ansi.h"
#include "cont_str.h"
#include "gph_shortcut_defs.h"

static ByTe_1 rcsid[] = "$Id: CheckScaling.c,v 1.1 1999/11/21 08:39:30 chris.gurgiolo.b2r Stab chrisg $";

void CheckScaling ()
{
   extern struct cont_disp cdisp;
   extern struct cont_info cinfo;
   extern struct cont_alloc cal;

   register ReaL_4 *f1, *fend;
   register ByTe_1  *c1;
   ReaL_4 Min, Max, dM;

   ByTe_1 SameLv, SameCb;
  
   SameLv = (cinfo.Ubeg == cinfo.Ufin) ? 1 : 0;     /* begin = end cont lev  */
   SameCb = (cdisp.colmax == cdisp.colmin) ? 1 : 0; /* begin = end col lev   */

/****************************************************************************/
/* If plot is log scaled then we must take the log of the beginning and     */
/* ending contour levels.  Also recompute the step size                     */
/****************************************************************************/

   if (cdisp.Cs == 1)
   {
      cinfo.begin = (cinfo.Ubeg > 0.0) ? log10 (cinfo.Ubeg) : -40;
      cinfo.finish = (cinfo.Ufin > 0.0) ? log10 (cinfo.Ufin) : -40;
   }
   else
   {
      cinfo.begin = cinfo.Ubeg;
      cinfo.finish = cinfo.Ufin;
   }
   dM = cinfo.finish - cinfo.begin;
   cinfo.stepsize = dM / (cinfo.numlevels - 1);

   if (SameLv || SameCb)                            /* same Cont or Cb lev?  */
   {                                                /* yes                   */
      Max = cinfo.Ltol;                             /* max set to lower tol  */
      Min = cinfo.Utol;                             /* min set to upper tol  */
      c1 = cal.bad;                                 /* ptr to bad mesh flag  */
      f1 = cal.z;                                   /* ptr to mesh values    */
      fend = f1 + cinfo.gridsize;                   /* end of  mesh vals     */
      for ( ; f1 < fend; ++f1)                      /* loop over mesh        */
      {
         if (*c1++ == 0)                            /* good mesh point?      */
         {
            if (*f1 > Max)                          /* point bigger than max */
               Max = *f1;                           /* set new max           */
            else
            {
              if (*f1 < Min)                        /* point less than min   */
                 Max = *f1;                         /* set new min           */
            }
         }
      }

/*****************************************************************************/
/*  In setting the contour level min and max if we have to we probably don't */
/*  want the absolute min and max since these may turn out to be just dots   */
/*  on the contour - so what we will do is to decrease the max by 5% of the  */
/*  total range and the min by 5% of the total range                         */
/*****************************************************************************/
   
      if (SameLv)                                   /* set countour levels?  */
      {                                             /* yes!                  */
         dM = (Max - Min) * 0.05;                   /* padding               */
         cinfo.begin = Min + dM;                    /* this is minimum       */
         cinfo.finish = Max - dM;                   /* this is maximum       */
         dM = cinfo.finish - cinfo.begin;           /* contour level range   */
         dM = cinfo.finish - cinfo.begin;
         cinfo.stepsize = dM / (cinfo.numlevels - 1);
      }

      if (SameCb)                                   /* set color scales?     */
      {                                             /* yes!                  */
         if (cdisp.Cs == 0)                         /* linear scaled?        */
         {
            cdisp.colmin = Min;                     /* this is minimum       */
            cdisp.colmax = Max;                     /* this is maximum       */
         }
         else
         {
            cdisp.colmin = pow((ReaL_8)Min, 10.0);  /* this is minimum       */
            cdisp.colmax = pow((ReaL_8)Max, 10.0);  /* this is maximum       */
         }
      }
   }
}
