#include "cont_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: Build3DMatrix.c,v 1.1 1999/11/21 08:39:30 chris.gurgiolo.b2r Stab chrisg $";

/***************************************************************************/
/*                                                                         */
/*  This routine builds the matrix used in the inversion of the 3D least   */
/*  square elements for estimating the intensities at the countour grid    */
/*  points.  The single input variable is the number of data points which  */
/*  are used in the fit.                                                   */
/*                                                                         */
/***************************************************************************/

void Build3DMatrix (ByTe_4 N)
{
   extern struct cont_info cinfo;
   extern struct cont_alloc cal;
   register ReaL_4  *f1, *f2, *f3, *f4, *f5;
   register ReaL_8 *d0, *d1;
   ReaL_8 *dend;
   ReaL_4  *fend;
   ByTe_4  Msize, j, k, Skip, SkipGr;
   ByTe_4  BaseX, BaseY, BaseZ, StartX, Start;
   ByTe_4  LenX, LenY, GrowX, Grow, Len, EndGr;
   ByTe_4  Cnt, end, End, Scnt;

   Msize = cinfo.rank * cinfo.rank;           /* # of elements in matrix     */

   dend = cal.Mat + Msize;                    /* end of matrix array         */
   for (d0 = cal.Mat; d0 < dend; )            /* loop over matrix elements   */
      *d0++ = 0.0;                            /* zero them out               */

   dend = cal.Velem + cinfo.rank;             /* end of Value elements array */
   for (d0 = cal.Velem; d0 < dend; )          /* loop over value array       */
      *d0++ = 0.0;                            /* zero value elements         */

   f1 = cal.Mx;                               /* ptr to x coordinates        */
   f2 = cal.My;                               /* ptr to y coordinates        */
   f3 = cal.Mz;                               /* ptr to y coordinates        */
   f4 = cal.Mv;                               /* ptr to intensities          */
   f5 = cal.weight;                           /* ptr to weight               */
   fend = cal.Mx + N;                         /* end of data array           */
   for ( ; f1 < fend; ++f1, ++f2, ++f3, ++f4) /* loop over data              */
   {
      cal.XYelem[0] = *f5++;                  /* 1st matrix elem is weight   */
      BaseX = 0;                              /* beginning X multiplier      */
      BaseY = 0;                              /* beginning Y multiplier      */
      BaseZ = 0;                              /* beginning Z multiplier      */
      StartX = 1;                             /* first X term                */
      LenX = 1;                               /* number of X terms to make   */
      LenY = 1;                               /* number of Y terms to make   */
      GrowX = 2;                              /* number of X term growth     */
      for (j = 0; j <= cinfo.order; ++j)      /* loop over element groups    */
      {
         d0 = cal.XYelem + BaseX;
         d1 = cal.XYelem + StartX; 
         dend = d1 + LenX;
         while (d1 < dend)
            *d1++ = *d0++ * *f1; 

         d0 = cal.XYelem + BaseY;
         dend = d1 + LenY;
         while (d1 < dend)
            *d1++ = *d0++ * *f2; 

         d0 = cal.XYelem + BaseZ;
         *d1 = *d0 * *f3;
        
         BaseX = StartX;
         BaseY = BaseX + LenX;
         BaseZ = BaseX + LenX + LenY;
         LenX += GrowX;
         LenY = GrowX++;
         StartX += LenX;
      }

      d0 = cal.XYelem;                        /* XY elements                */ 
      d1 = cal.Velem;                         /* calculated value elem here */
      dend = d1 + cinfo.rank;                 /* end ov value vector        */
      for ( ; d1 < dend; )                    /* loop over XY elements      */
        *d1++ += *d0++ * *f4;                 /* Value times XY elements    */

      d0 = cal.Mat;                           /* pointer to matrix          */
      d1 = cal.XYelem;                        /* pointer to XY terms        */
      dend = d0 + cinfo.rank;                 /* end of 1st row in matrix   */
      for ( ; d0 < dend; )                    /* loop over 1st row          */
        *d0++ += *d1++;                       /* transfer data              */
    
      End = cinfo.order + 1;
      StartX = 1;                             /* start row transfer here    */
      LenX = 3;                               /* elements in current group  */
      Cnt = 0;                                /* elements in group xfered   */
      GrowX = 3;                              /* initial LenX increment     */
      dend = cal.Mat + Msize;                 /* end of matrix elements     */
      for (Scnt = 0; d0 < dend; ++StartX)     /* loop over matrix rows      */
      {
         Len = LenX;                          /* initialize group length    */
         Start = StartX;                      /* initial XY start position  */
         Grow = GrowX;                        /* initial Len increment      */
         end = 1;                             /* initial elements in group  */
         EndGr = 2;                           /* elements in group inc      */
         Skip = ((Scnt++ % 3) == 0) ? -1 : 1; /* initial pos skip position  */

         for (j = 0; j < End; ++j, end += EndGr++)
         {
            d1 = cal.XYelem + Start;
            SkipGr = 2;
            for (k = 0; k < end; ++k)
            {
               if (k == Skip)
               {
                  ++d1;
                  Skip += SkipGr++;
               }
               *d0++ += *d1++;
            }
            Start += Len;
            Len += Grow++;
         }

         if (++Cnt == LenX)
         {
            Cnt = 0;
            LenX += GrowX++;
         }
      }
   }

   d0 = cal.Mat;
   d1 = cal.Mat + Msize;
   dend = d0 + Msize;
   for ( ; d0 < dend;)
      *d1++ = *d0++;
}
