#include "cont_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: Build2DMatrix.c,v 1.1 1999/11/21 08:39:30 chris.gurgiolo.b2r Stab chrisg $";

/***************************************************************************/
/*                                                                         */
/*  This routine builds the matrix used in the inversion of the 2D least   */
/*  square elements for estimating the intensities at the countour grid    */
/*  points.  The single input variable is the number of data points which  */
/*  are used in the fit.                                                   */
/*                                                                         */
/***************************************************************************/

void Build2DMatrix (ByTe_4 N)
{
   extern struct cont_info cinfo;
   extern struct cont_alloc cal;
   register ReaL_4 *f1,*f2,*f3,*f4;
   register ReaL_8 *d0,*d1;
   ReaL_8 *dend;
   ReaL_4 *fend;
   ByTe_4 Msize, j, k;
   ByTe_4 BaseX, BaseY, StartX, LenX, Grow = 1;
   ByTe_4 Start, Len;
   ByTe_4 Cnt, end, End;
   ByTe_4 TOr;
  

   Msize = cinfo.rank * cinfo.rank;           /* # of elements in matrix    */
   TOr = 2 * cinfo.order;                     /* twice order form XY elem   */

   dend = cal.Mat + Msize;                    /* end of matrix array        */
   for (d0 = cal.Mat; d0 < dend; )            /* loop over matrix elements  */
      *d0++ = 0.0;                            /* zero them out              */

   dend = cal.Velem + cinfo.rank;             /* end of Value element array */
   for (d0 = cal.Velem; d0 < dend; )          /* loop over value array      */
      *d0++ = 0.0;                            /* zero value elements        */

   f1 = cal.Mx;                               /* ptr to x coordinates       */
   f2 = cal.My;                               /* ptr to y coordinates       */
   f3 = cal.Mv;                               /* ptr to intensities         */
   f4 = cal.weight;                           /* ptr to weight              */
   fend = cal.Mx + N;                         /* end of data array          */
   for ( ; f1 < fend; ++f1, ++f2, ++f3)       /* loop over data             */
   {
      cal.XYelem[0] = *f4++;                  /* 1st matrix elem is weight  */
      BaseX = 0;                              /* start X multiplications    */
      BaseY = 0;                              /* start Y multiplications    */
      StartX = 1;                             /* start results here         */
      LenX = 1;                               /* number of X multiplies     */
      for (j = 0; j < TOr; ++j)               /* loop over multiples        */
      {
         d0 = cal.XYelem + BaseX;             /* first X multiplication     */
         d1 = cal.XYelem + StartX;            /* first element              */
         dend = d0 + LenX;
         while (d0 < dend)
            *d1++ = *d0++ * *f1; 

         d0 = cal.XYelem + BaseY;             /* first Y multiplication     */
         *d1 = *d0 * *f2;

         BaseX = StartX;                      /* new start X multiplies     */
         BaseY = BaseX + LenX;                /* new start Y multiplies     */
         LenX += Grow;                        /* new number of X multiplies */
         StartX += LenX;                      /* new start results here     */
      }

      d0 = cal.XYelem;                        /* XY elements                */ 
      d1 = cal.Mat + Msize;                   /* calculated value elem here */
      dend = d1 + cinfo.rank;                 /* end ov value vector        */
      for ( ; d1 < dend; )                    /* loop over XY elements      */
        *d1++ = *d0++ * *f3;                  /* Value times XY elements    */

      d0 = cal.Mat;                           /* pointer to matrix          */
      d1 = cal.XYelem;                        /* pointer to XY terms        */
      dend = d0 + cinfo.rank;                 /* end of 1st row in matrix   */
      for ( ; d0 < dend; )                    /* loop over 1st row          */
        *d0++ += *d1++;                       /* transfer data              */
    
      End = cinfo.order + 1;
      StartX = 1;                             /* start row transfer here    */
      LenX = 2;                               /* elements in current group  */
      Cnt = 0;                                /* elements in group xfered   */
      dend = cal.Mat + Msize;                 /* end of matrix elements     */
      for ( ; d0 < dend; ++StartX)            /* loop over matrix rows      */
      {
         Len = LenX;
         Start = StartX;
         for (j = 0; j < End; ++j)
         {
            d1 = cal.XYelem + Start;
            end = j + 1;
            for (k = 0; k < end; ++k)
               *d0++ += *d1++;
            Start += Len;
            Len += Grow;
         }
         if (++Cnt == LenX)
         {
            Cnt = 0;
            LenX += Grow;
         }
      }

      d0 = cal.Mat + Msize;
      d1 = cal.Velem;
      dend = d0 + cinfo.rank;
      for ( ; d0 < dend;)
         *d1++ += *d0++;
   }

   d0 = cal.Mat;
   d1 = cal.Mat + Msize;
   dend = d0 + Msize;
   for ( ; d0 < dend;)
      *d1++ = *d0++;
}
