#include <stdio.h>
#include <math.h>
#include "cont_str.h"
#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: AfterGraphicsOn.c,v 1.1 1999/11/21 08:39:30 chris.gurgiolo.b2r Stab chrisg $";

void AfterGraphicsOn ()
{
   extern struct config parm;
   extern struct cont_info cinfo;
   extern struct cont_disp cdisp;
   extern struct cont_map c_map;

   ReaL_4 X, Y;
   ByTe_2 *s1;

   s1 = &parm.white;
   if (cdisp.grid_color >= 0)
      cdisp.grid_color = *(s1 + cdisp.grid_color); 
   c_map.Mcolor = *(s1 + c_map.Mcolor); 
   c_map.Gcolor = *(s1 + c_map.Gcolor); 
   if (cdisp.data_color >= 0)
      cdisp.data_color = *(s1 + cdisp.data_color); 
   cdisp.normal = *(s1 + cdisp.normal);
   if (cdisp.clab_color >= 0)
      cdisp.clab_color = *(s1 + cdisp.clab_color);


   cinfo.gridsize = cinfo.nr * cinfo.nc;
   cinfo.numseg = 3 * cinfo.gridsize - 2 * (cinfo.nr + cinfo.nc) + 1;

   cinfo.xstep = (cinfo.xmax - cinfo.xmin) / (cinfo.nc - 1); 
   cinfo.ystep = (cinfo.ymax - cinfo.ymin) / (cinfo.nr - 1); 

   if (cinfo.cyclic > 0)
      cinfo.CDdis = (cinfo.MaxCD - cinfo.MinCD) / 2.0;

   if (cinfo.data_type < 4)
   {
      if (cinfo.MinRFmt == 'G')
      {
         X = cinfo.xstep;
         Y = cinfo.ystep;
         cinfo.MinR *= (X * X + Y * Y);
      }
   }
}
