/************************************************************************/
/*  This routine will create a menu option list containing all of the   */
/*  currently usable graphics devices                                   */
/************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "gph_var.h"
#include "gph_opind.h"
#include "gph_ansi.h"
#include <string.h>

main (int argc, char *argv[])
{
   struct scr_info dv;

   register ByTe_4 j, *l1;
   register ByTe_1 *c1;

   ByTe_4  fd;
   ByTe_4  bytes, NDev;
   ByTe_1 *Fs = PathSep;


   ByTe_1  DevPath[80];
   ByTe_1  *err1 = "Unable to open graphics device file at %s\n";

   sprintf (DevPath, "%s%sdatafiles%sdevice.bin", getenv("GPH_HOME"), Fs, Fs);

   if ((fd = open (DevPath, 0)) < 0)            /* open device info file    */
   {                  
      fprintf(stderr, err1,  DevPath);          /* opps - error lets leave  */
      exit (-1);
   }
#ifdef _CyGnUsC
   setmode (fd, O_BINARY);                      /* binary file              */
#endif

   bytes = sizeof (struct scr_info);            /* bytes size of dev struct */

   lseek (fd, 0L, 0);                           /* to the start of file     */
   read (fd, &NDev, sizeof(ByTe_4));            /* # of devices in file     */

   printf ("%d\n",NDev);
   for (j = 0; j < NDev; ++j)                   /* loop over the devices    */
   {                                             
       read (fd, &dv, bytes);                   /* read device info         */
       printf ("%s:%d:%d\n",dv.name, j, dv.type);
   }

   close  (fd);                                 /* close dev file           */

   exit (0);
}
