#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: dr_3dsurf.c,v 1.1 1999/11/21 08:20:18 chris.gurgiolo.b2r Stab chrisg $";

void dr_3dsurf (ByTe_1 w, ReaL_4 *x, ReaL_4 *y, ReaL_4 *z, ByTe_1 *decom,
                ByTe_2 ele, ByTe_1 mode, ByTe_2 ver)
{
   extern struct config parm;
   extern struct memory minfo;
   extern struct init_val ival;
   struct window *wn;
   register ReaL_4 *f1,*f2,*f3,*f4;
   register ByTe_1 *c1;
   ReaL_4 *f5,*f6;
   ByTe_2 *s1, *s2;
   ReaL_4 ring_buf[10];
   ReaL_4 xx[4],yy[4],zz[4];
   ByTe_2 *order,i;
   ByTe_2 loop,nsurf,beg,pos;
   ByTe_4 j,cntr;
   ByTe_1 err_code;
   ByTe_2 p1,p2;
   ByTe_2 elem[4];
   ReaL_4 zh;
   ByTe_2 upto,cur_surf,indx;

   err_code = (w != parm.wn_num) ? window (w,"SURFACE") : parm.win->open;
   if (err_code <= 0)
   {
      g_error ("SURFACE","REQUESTED WINDOW HAS NOT BEEN OPENED",0);
      return;
   }

   if (ver > 4 && mode == 'C')
   {
      g_error ("SURFACE","CANNOT COMPRESS DATA WITH MORE THAN 4 VERTICES",0);
      return;
   }
   wn  = parm.win;
   pos = 0;

   f1 = x;
   f2 = y;
   f3 = z;
   f5 = ring_buf;
   f6 = (ReaL_4 *)minfo.mxy;
   c1 = decom;
   nsurf = 0;

   if (mode != 'C')
   {
      for ( ; f1 < x + ele; ++f6)
      {
	 *f6 = 0;
	 for (j = 0; j < ver; ++j)
	 {
            f4   = wn->e_mat + 2;
            zh   = *f1++ * *f4; 
            zh  += *f2++ * *(f4+4); 
            zh  += *f3++ * *(f4+8); 
            zh  += *(f4+12); 
            *f6 += -1/zh; 
         }
	 *f6 /= ver;
	 ++nsurf;
      }
   }
   else
   {
      cntr = 0;

      for ( ; f1 < x + ele; ++f6)
      {
	 if (*c1 == 3 || *c1 == 4)
	    ver = *c1++;
	 loop = (*c1 > 0 ) ? ver : ver - 2;
         beg  = cntr % 10;
	 for (j = 0; j < loop; ++j)
	 {
            f4  = wn->e_mat + 2;
            zh  = *f1++ * *f4; 
            zh += *f2++ * *(f4+4); 
            zh += *f3++ * *(f4+8); 
            zh += *(f4+12); 
            pos = cntr++ % 10;
            *(f5 + pos) = -1/zh;
         }
	 ++nsurf;

         p1 = beg + *c1 / 10;
         p1 = (p1 < 0) ? 10 + p1 : p1 % 10;
         p2 = beg + *c1++ % 10;
         p2 = (p2 < 0) ? 10 + p2 : p2 % 10;
         *f6 = *(f5 + beg) + *(f5 + p1) + *(f5 + p2);
	 if (ver == 4)
	    *f6 += *(f5 + beg + 1);
         *f6 /= ver;
      }   
   }

  /**** PUT SORT AND ORDER IN HERE       ****/ 

   order = (ByTe_2 *)((ReaL_4 *)minfo.mxy + 2*ival.points - nsurf - 4);
   for (i = 0; i < nsurf ; ++i)
      *order++ = i;

  /*  HEAPSORT  */
  /*  puts it in ASCENDING order     */

   f1 = (ReaL_4 *)minfo.mxy;
   order = (ByTe_2 *)((ReaL_4 *)minfo.mxy + 2*ival.points - nsurf - 4);

   HeapSort (nsurf, f1, order);

  /**** PUT IT IN LAST HALF OF MINFO.XYX ****/

   if (mode == 'C')
   {
      cur_surf = 32767;
      elem[0] = 0;
      elem[1] = 1;
      pos = (ver == 4) ? 2 : 1;

      for (s1 = order+nsurf-1; s1 >= order; --s1)
      {
         if (*s1 < cur_surf)
         {
	    f1 = x; 
	    f2 = y;
	    f3 = z;
            c1 = decom;
            upto = *s1; 
         }
         else
            upto = *s1 - cur_surf; 

         cur_surf = *s1;
	 for (j = 0; j < upto; ++j)
	 {
	     if (*c1 == 3 || *c1 == 4)
	     {
	        ver = *c1++;
	        if (ver == 4)
	        {
                   pos = 2;
	           elem[1] = 1.0;
	        }
	        else
	           pos = 1;
             }
   
	     indx = (*c1++ > 0) ? ver : ver - 2;
             f1 += indx;
             f2 += indx;
             f3 += indx;
	 }
         
	 if (*c1 == 3 || *c1 == 4)
	 {
	    ver = *c1++;
	    if (ver == 4)
	    {
               pos = 2;
	       elem[1] = 1.0;
	    }
	    else
	       pos = 1;
         }
   
	 elem[pos]   = *c1 / 10;
	 elem[pos+1] = *c1 % 10;

	 f4 = xx;
         f5 = yy;
         f6 = zz; 
         for (s2 = elem ; s2 < elem + ver; )
	 {
	     *f4++ = *(f1 + *s2);
	     *f5++ = *(f2 + *s2);
	     *f6++ = *(f3 + *s2++);
	 }

         fill (0,parm.black);
	 poly (w,xx,yy,zz,ver);
         fill (-1,-1);
	 poly (w,xx,yy,zz,ver);
      }
   }
   else
   {
      for (s1 = order+nsurf-1; s1 >= order; --s1)
      {
	 f1 = x + ver * *s1; 
	 f2 = y + ver * *s1;
	 f3 = z + ver * *s1;

         fill (0,parm.black);
         poly (w,f1,f2,f3,ver);
         fill (-1,-1);
         poly (w,f1,f2,f3,ver);
      }
   }
}
