#include "gph_str.h"
#include "gph_ansi.h"
#include "gph_opind.h"
#include <math.h>

static ByTe_1 rcsid[] = "$Id: point_eye.c,v 1.1 1999/11/21 08:20:18 chris.gurgiolo.b2r Stab chrisg $";

void point_eye(ByTe_1 w, ReaL_4 vx, ReaL_4 vy, ReaL_4 vz, ReaL_4 lx, 
                ReaL_4 ly, ReaL_4 lz, ReaL_4 ax, ReaL_4 ay, ReaL_4 spin)
{
   extern struct config  parm;
   ReaL_4 a0,a1,a2,sum,mag_a,mag_b,x_rot,y_rot,z_rot = 0.0;
   ReaL_4 a0sqr,a1sqr,a2sqr,conv;
   ReaL_4 cx,cy,cz,sx,sy,sz;
   ReaL_8 RX[16],RY[16],RZ[16],TP[16],EYE[16];
   register ReaL_8 *d1,*d2,*d3;
   register ReaL_4 *f1;
   ReaL_8 *end;
   struct window *wn;

/** First place view plane looking down x axis at yz plane with **/
/** up along the +z direction                                   **/

   d1 = EYE;

   *d1++ =  0;
   *d1++ = -1;
   *d1++ =  0;
   *d1++ =  0;

   *d1++ =  0;
   *d1++ =  0;
   *d1++ =  1;
   *d1++ =  0;

   *d1++ = -1;
   *d1++ =  0;
   *d1++ =  0;
   *d1++ =  0;

   *d1++ =  0;
   *d1++ =  0;
   *d1++ =  0;
   *d1++ =  1;

/**  Get the rotation angles **/

   a0 = vx - lx;
   a1 = vy - ly;
   a2 = vz - lz;

   a0sqr = a0*a0;
   a1sqr = a1*a1;
   a2sqr = a2*a2;

   conv = 180.0/M_PI;

   y_rot = -atan2 (a1,a0) * conv;

   sum = (a0sqr + a1sqr);
   mag_a = sqrt(sum);
   sum = (a0sqr + a1sqr + a2sqr);
   mag_b = sqrt(sum);

   x_rot = atan2 (a2,mag_a) * conv;

/**  Form sines and cosines **/

   cy = cosin(y_rot);
   cx = cosin(x_rot);
   sy = sine(y_rot);
   sx = sine(x_rot);

/** Diagonalize rotation matrices **/

   for (d1 = RY, d2 = RX, d3 = RZ; d1 < RY + 15;) 
   {
      *d1++ = 1.0;
      *d2++ = 1.0;
      *d3++ = 1.0;
      end = d1 + 4;
      for ( ; d1 < end; )
      {
         *d1++ = 0.0;
         *d2++ = 0.0;
         *d3++ = 0.0;
      }
   }
   *d1 = 1.0;
   *d2 = 1.0;
   *d3 = 1.0;

   if (w != parm.wn_num)
      window (w,"EYE_POS");
   wn = parm.win;

/* Form Rotation Matrices **/

   RY[0] = cy;
   RY[2] = sy;
   RY[8] = -sy;
   RY[10] = cy;

   RX[5] = cx;
   RX[6] = sx;
   RX[9] = -sx;
   RX[10] = cx;

   mult_mtx(4,4,4,RX,RY,TP);

   if (spin > 0.0)
   {
      cz = cosin(spin);
      sz = sine(spin);
      RZ[0] = cz;
      RZ[1] = sz;
      RZ[4] = -sz;
      RZ[5] = cz;
      mult_mtx(4,4,4,RZ,TP,RX);
      mult_mtx(4,4,4,RX,EYE,RY);
   }
   else
      mult_mtx(4,4,4,TP,EYE,RY);

   d1 = RY;
   f1 = wn->e_mat;

   *f1++  = *d1;
   *f1++  = *(d1 + 4);
   *f1++  = *(d1 + 8);
   *f1++  = *(d1++ + 12);

   *f1++  = *d1;
   *f1++  = *(d1 + 4);
   *f1++  = *(d1 + 8);
   *f1++  = *(d1++ + 12);

   *f1++  = *d1;
   *f1++  = *(d1 + 4);
   *f1++  = *(d1 + 8);
   *f1++  = *(d1++ + 12);

   d1 = EYE;
   *f1++  = 0.0;
   *f1++  = 0.0;
   *f1++  = mag_b;
   *f1  = 1.0;

   f1 = wn->eye;
   *f1++ = vx;
   *f1++ = vy;
   *f1++ = vz;
   *f1++ = x_rot;
   *f1++ = y_rot;
   *f1++ = z_rot;
   *f1++ = 1.0/tan (ax * M_PI / 180.0); 
   *f1   = 1.0/tan (ay * M_PI / 180.0); 
}
