;%W% %G%
; Insert housekeeping into a window without overwriting the contents.
;
; insertHsk, Limits, Imageinfo
;
; PARAMETERS
;
;  Limits
;
;  A four element vector defining the coordinates of a diagonal from the
;  lower left to the upper right corners of the allowable drawing area.
;
;  Imageinfo
;
;  A structure containing all data needed for plotting.
;
;  COMMENTS
;
;  Do not clobber anything outside of the rectangle defined by the
;  Limits parameter.
;
;
PRO insertHsk, Limits, inst, record
;
@fuv_cmnblk
;
    ; Get our drawing region
    llx = Limits(0)
    lly = Limits(1)
    urx = Limits(2)
    ury = Limits(3)
    xsize = urx - llx + 1
    ysize = ury - lly + 1

    ; Get the size of our characters
    x_char_size = 7.
    y_char_size = 10.
    if (ps_flag eq 1) then ch_size=0.8 else ch_size=1.0

    ; Leave a 5 pixel border around our drawing area
    border = 5
;
  if (cor eq 0) then begin
    numfields = 13		;Five columns of two rowsplus 3
    s = strarr(numfields)
    xpos = intarr(numfields)
    ypos = intarr(numfields)

    linehgt = y_char_size + y_char_size / 2

    s(0) = STRING(FORMAT='("FOVSCL: ",I1)',ImageInfo(inst).fovscale)
    xpos(0) = llx + border + 5
    ypos(0) = lly + border

    if (inst eq 0) then s(1) = STRING(FORMAT='("MCP: ", F6.1)', ImageInfo(inst).hv_mcp) $
    else s(1) = STRING(FORMAT='("HV: ", F6.1)', ImageInfo(inst).hv_mcp)
    xpos(1) = xpos(0)
    ypos(1) = ypos(0) + linehgt
;
    s(2) = STRING(FORMAT='("Spin_angle:", F6.1)', ImageInfo(inst).spin_phase)
    xpos(2) = xpos(0) + 155
    ypos(2) = ypos(0)
;
    if (inst eq 0) then $
     s(3) = STRING(FORMAT='("PHOS: " , F6.1)',ImageInfo(inst).hv_phos) $
    else  s(3) = '     '
    xpos(3) = xpos(2)
    ypos(3) = ypos(1)
;
    s(4) = STRING(FORMAT='("HFOV: " , F6.1)',ImageInfo(inst).hfov)
    xpos(4) = xpos(2)+135
    ypos(4) = ypos(0)
;
    s(5) = STRING(FORMAT='("VFOV: ", F6.1)', ImageInfo(inst).vfov)
    xpos(5) = xpos(4)
    ypos(5) = ypos(1)
;
;    s(6) = STRING(FORMAT='("Spin#:     ", I6)', ImageInfo(inst).spin)
;    xpos(6) = xpos(4) + 100
;    ypos(6) = ypos(0)
;
    s(7) = STRING(FORMAT='("GC Alt: ", F3.1, " Re")', ImageInfo(inst).hgt)
    xpos(7) = urx - 95
    ypos(7) = lly + border - linehgt
;
    s(8) = STRING(FORMAT='("GLat: ", F5.1)', ImageInfo(inst).lat_ctr)
    xpos(8) = xpos(7)
    ypos(8) = ypos(0)
;
    s(9) = STRING(FORMAT='("GLon: ", F5.1)', ImageInfo(inst).lon_ctr)
    xpos(9) = xpos(7)
    ypos(9) = ypos(1)
;
    s(10) = STRING(FORMAT='("[", F4.2, ",", F5.3, ",", I3, "]")', ImageInfo(inst).airglow_scale[0],$
       ImageInfo(inst).airglow_scale[1],ImageInfo(inst).airglow_scale[2])
    xpos(10) = xpos[0]
    ypos(10) = lly + border - linehgt - linehgt
;
    s(11) = STRING(FORMAT='("Emis_hgt:", I4, " km")', ImageInfo(inst).emis_hgt)
    xpos(11) = xpos(2)
    ypos(11) = lly + border - linehgt
;
    s(12) = STRING("Dayglow:")
    xpos(12) = xpos[0]
    ypos(12) = lly + border - linehgt
;
    xyouts, float(xpos)/xwin, float(ypos)/ywin, s,COLOR = txt_clr,/NORMAL,CHARSIZE=ch_size
  endif else begin
   numfields = 7		;two columns of two rows+ 3
   s = strarr(numfields)
   xpos = intarr(numfields)
   ypos = intarr(numfields)

   linehgt = y_char_size + y_char_size / 2
   k=0
   x_align=llx+border
   for i=0,2 do begin
    if (avail_inst(i) eq 1) then begin
     s(0) = STRING(FORMAT='("FOVSCL: ",I1)',ImageInfo(i).fovscale)
     xpos(0) = x_align
     ypos(0) = lly + border

     if (i eq 0) then s(1) = STRING(FORMAT='("MCP: ", F6.0)', ImageInfo(i).hv_mcp) $
     else s(1) = STRING(FORMAT='("HV: ", F6.0)', ImageInfo(i).hv_mcp)
     xpos(1) = xpos(0)
     ypos(1) = ypos(0) + linehgt
;
     s(2) = STRING(FORMAT='("Spin_angle:", F6.1)', ImageInfo(i).spin_phase)
     xpos(2) = x_align+120
     ypos(2) = ypos(0)
;
     if (i eq 0) then $
      s(3) = STRING(FORMAT='("PHOS: " , F6.0)',ImageInfo(i).hv_phos) $
     else  s(3) = '      '
     xpos(3) = xpos(2)
     ypos(3) = ypos(1)
;
    s(4) = STRING("Dayglow:")
    xpos(4) = xpos[0]
    ypos(4) = lly + border - linehgt

    s(5) = STRING(FORMAT='("Emis.:", I4, " km")', ImageInfo(inst).emis_hgt)
    xpos(5) = xpos(2)
    ypos(5) = lly + border - linehgt
;
    s(6) = STRING(FORMAT='("[", F4.2, ",", F5.3, ",", I3, "]")', ImageInfo(inst).airglow_scale[0],$
       ImageInfo(inst).airglow_scale[1],ImageInfo(inst).airglow_scale[2])
    xpos(6) = xpos[0]
    ypos(6) = lly + border - linehgt - linehgt

    xyouts, float(xpos)/xwin, float(ypos)/ywin, s,COLOR = txt_clr,/NORMAL,CHARSIZE=ch_size
     x_align=x_align+275
	endif
   endfor
    s(0) = STRING(FORMAT='("GC Alt: ", F3.1, " Re")', ImageInfo(inst).hgt)
     xpos(0) = urx - 95
     ypos(0) = lly + border - linehgt
;
    s(1) = STRING(FORMAT='("GLat: ", F5.1)', ImageInfo(inst).lat_ctr)
     xpos(1) = xpos(0)
     ypos(1) = ypos(0) + linehgt
;
    s(2) = '     '
     xpos(2) = xpos(0)+80
     ypos(2) = ypos(0)
;
    s(3) = STRING(FORMAT='("GLon: ", F5.1)', ImageInfo(inst).lon_ctr)
    xpos(3) = xpos(0)
    ypos(3) = ypos(1) + linehgt
;
    s(4) = '     '
     xpos(4) = xpos(0)+80
     ypos(4) = ypos(0)
;
    s(5) = '     '
     xpos(5) = xpos(0)+80
     ypos(5) = ypos(0)
;
    s(6) = '     '
     xpos(6) = xpos(0)+80
     ypos(6) = ypos(0)
;
    xyouts, float(xpos)/xwin, float(ypos)/ywin, s,COLOR = txt_clr,/NORMAL,CHARSIZE=ch_size
  endelse
END
