;@(#)getdir.pro	1.2 08/25/99
; This procedure picks the directory name (such as 1999/121/) from /UVIDATA 
; directory.
; Builds Level one, Orbit, Attitude, and Partial Attitude filenames, 
; Searches and selects the latest version of files.(KM);
; Default file locations
;-----------------------------------------------------------------------------
; This the latest version of GIFWALK program.  Applying the FUV modification 
;
;Modified:
;
; Hassan Dougani	10/04/1999	Applying the lastes FUV modifications
; Hassan Dougani	10/28/1999	Applying the lastes FUV modifications
; Harald Frey		01/17/2000	Introducing filetype_flag for UDF files
;
;-----------------------------------------------------------------------------
;
pro getfile, err_no,inst, id,maxrecord,picked_file,filetype_flag

@fuv_cmnblk



	;Set initial path for WIC file
err_no = 0
L1path =DATA_PATH
l1count=0
pocount=0
nrcount = 0

if (picked_file eq '') then begin
    case filetype_flag of
    1: picked_file=DIALOG_PICKFILE(PATH=L1path, $
    	TITLE='Please select a Level 1 File ')
    20: picked_file=DIALOG_PICKFILE(PATH=L1path, $
    	TITLE='Please select a Level 1 File ',FILTER='IMFHWIC2000*D') 
    21: picked_file=DIALOG_PICKFILE(PATH=L1path, $
    	TITLE='Please select a Level 1 File ',FILTER='IMFHWIC2001*D') 
    22: picked_file=DIALOG_PICKFILE(PATH=L1path, $
    	TITLE='Please select a Level 1 File ',FILTER='IMFHWIC2002*D') 
    23: picked_file=DIALOG_PICKFILE(PATH=L1path, $
    	TITLE='Please select a Level 1 File ',FILTER='IMFHWIC2003*D') 
    24: picked_file=DIALOG_PICKFILE(PATH=L1path, $
    	TITLE='Please select a Level 1 File ',FILTER='IMFHWIC2004*D') 
    25: picked_file=DIALOG_PICKFILE(PATH=L1path, $
    	TITLE='Please select a Level 1 File ',FILTER='IMFHWIC2005*D') 
    26: picked_file=DIALOG_PICKFILE(PATH=L1path, $
    	TITLE='Please select a Level 1 File ',FILTER='IMFHWIC2006*D') 
    27: picked_file=DIALOG_PICKFILE(PATH=L1path, $
    	TITLE='Please select a Level 1 File ',FILTER='IMFHWIC2007*D') 
    28: picked_file=DIALOG_PICKFILE(PATH=L1path, $
    	TITLE='Please select a Level 1 File ',FILTER='IMFHWIC2008*D') 
    30: picked_file=DIALOG_PICKFILE(PATH=L1path, $
    	TITLE='Please select a Level 1 File ',FILTER='IMF12LSI2000*D') 
    31: picked_file=DIALOG_PICKFILE(PATH=L1path, $
    	TITLE='Please select a Level 1 File ',FILTER='IMF12LSI2001*D') 
    32: picked_file=DIALOG_PICKFILE(PATH=L1path, $
    	TITLE='Please select a Level 1 File ',FILTER='IMF12LSI2002*D') 
    33: picked_file=DIALOG_PICKFILE(PATH=L1path, $
    	TITLE='Please select a Level 1 File ',FILTER='IMF12LSI2003*D') 
    34: picked_file=DIALOG_PICKFILE(PATH=L1path, $
    	TITLE='Please select a Level 1 File ',FILTER='IMF12LSI2004*D') 
    35: picked_file=DIALOG_PICKFILE(PATH=L1path, $
    	TITLE='Please select a Level 1 File ',FILTER='IMF12LSI2005*D') 
    36: picked_file=DIALOG_PICKFILE(PATH=L1path, $
    	TITLE='Please select a Level 1 File ',FILTER='IMF12LSI2006*D') 
    37: picked_file=DIALOG_PICKFILE(PATH=L1path, $
    	TITLE='Please select a Level 1 File ',FILTER='IMF12LSI2007*D') 
    38: picked_file=DIALOG_PICKFILE(PATH=L1path, $
    	TITLE='Please select a Level 1 File ',FILTER='IMF12LSI2008*D') 
    40: picked_file=DIALOG_PICKFILE(PATH=L1path, $
    	TITLE='Please select a Level 1 File ',FILTER='IMF13LSI2000*D') 
    41: picked_file=DIALOG_PICKFILE(PATH=L1path, $
    	TITLE='Please select a Level 1 File ',FILTER='IMF13LSI2001*D') 
    42: picked_file=DIALOG_PICKFILE(PATH=L1path, $
    	TITLE='Please select a Level 1 File ',FILTER='IMF13LSI2002*D') 
    43: picked_file=DIALOG_PICKFILE(PATH=L1path, $
    	TITLE='Please select a Level 1 File ',FILTER='IMF13LSI2003*D') 
    44: picked_file=DIALOG_PICKFILE(PATH=L1path, $
    	TITLE='Please select a Level 1 File ',FILTER='IMF13LSI2004*D') 
    45: picked_file=DIALOG_PICKFILE(PATH=L1path, $
    	TITLE='Please select a Level 1 File ',FILTER='IMF13LSI2005*D') 
    46: picked_file=DIALOG_PICKFILE(PATH=L1path, $
    	TITLE='Please select a Level 1 File ',FILTER='IMF13LSI2006*D') 
    47: picked_file=DIALOG_PICKFILE(PATH=L1path, $
    	TITLE='Please select a Level 1 File ',FILTER='IMF13LSI2007*D') 
    48: picked_file=DIALOG_PICKFILE(PATH=L1path, $
    	TITLE='Please select a Level 1 File ',FILTER='IMF13LSI2008*D') 
    else: stop
    endcase
    endif

; ******* For Timas Group
; If Cancel selected
if (picked_file eq '') then begin
  err_no = 1
  return
endif
; *******

	; Get file picked
print,' you have picked file =', picked_file
p2len= strlen(picked_file)

tmp=''
filetypes=STRUPCASE(strmid(picked_file,p2len-3,3))
filetype_flag=0			; nothing defined

	; CDF part
if (filetypes eq 'CDF') then begin
   open_cdf,picked_file,id,maxrecord
   if (id eq 0) then begin
      err_no=1
      stat_txt= 'Error reading file '+picked_file+', Select again.'
      widget_control, status_id, set_value=stat_txt
      return
   endif else begin
      cdf_varget1,id,'INSTRUMENT_ID',/string,tmp
      case STRTRIM(tmp,2) of
       'WIC': inst=0
       'SI1218':inst=1
       'SI1356':inst=2
       else: begin
    	err_no=1
    	stat_txt= 'No such instrument supported.'
    	widget_control, status_id, set_value=stat_txt
	return
	endcase
      endcase
      filetype_flag=1		; cdf-file
   endelse
endif else begin

	; UDF part
  if strupcase(strmid(picked_file,p2len-1,1) eq 'D') then  begin
     maxrecord=!values.f_nan			; do not know here
     filetype_flag=2				; udf-file
     id=!values.f_nan
     id_start_pos=strpos(picked_file,'IMF')
     instrument_string=strmid(picked_file,id_start_pos+3,4)

	; we have no extension .udf or something like this
     case instrument_string of
       '12LS' : inst=1
       '12HS' : inst=1
       '13LS' : inst=2
       '13HS' : inst=2
       'HWIC' : inst=0
       'LWIC' : inst=0
       ELSE: inst=!values.f_nan		; not supported
     endcase
  endif  else   begin			; made some mistake during file selection
     err_no=1
     stat_txt= 'No Level 1 UDF found, Select again.'
     widget_control, status_id, set_value=stat_txt
     return
     endelse
endelse
;
end
