;%W% %G%
;
;to get help: IDL> ptg,/help


; ancillary routines --------------------------------------------

;@/home/immel/idl/sun3.pro	;now in distribution directory
@degree_trig.pro		;contains cosd sind etc...


FUNCTION atan2d,x1,x2
   RETURN,DOUBLE(ATAN(x1,x2)/!DTOR)
END

FUNCTION dtand,x
    RETURN,DOUBLE(TAN(x*!DTOR))
END

FUNCTION datand,x
    RETURN,DOUBLE(ATAN(x)/!DTOR)
END

FUNCTION fgeodeP,a,b,v1x,v1y,v1z,v2x,v2y,v2z
    RETURN,v1x*v2x + v1y*v2y + v1z*v2z * a*a/(b*b)
END

FUNCTION dfmag,x1,x2,x3
    RETURN,DOUBLE(SQRT(x1*x1+x2*x2+x3*x3))
END

;---------------------------------------------------------------

PRO vector_to_ra_decP,x,y,z,ra,dec


COMMON datainfo, emis_hgt,latmin,apxfile

    fill_value = -1.D31
    ndx = WHERE(z NE 0,count)
    IF(count GT 0) THEN dec(ndx) = 90.*z(ndx)/ABS(z(ndx))

    tmp = SQRT(x*x + y*y)
    ndx = WHERE(tmp NE 0,count)
    IF (count GT 0) THEN BEGIN
      dec(ndx) = atan2d(z(ndx),tmp(ndx))
      ra(ndx)  = atan2d(y(ndx),x(ndx))
    ENDIF

    ndx = WHERE((ra LT 0) AND (ra NE fill_value),count)
    IF (count GT 0) THEN ra(ndx) = ra(ndx) + 360.

END

;---------------------------------------------------------------

PRO drtollP,x,y,z,lat,lon,r

COMMON datainfo, emis_hgt,latmin,apxfile

      lat = atan2d(z,SQRT(x*x + y*y))
      lon = atan2d(y,x)
      r   = SQRT(x*x + y*y + z*z)

      tmp = WHERE(x EQ Y) AND WHERE(x EQ 0)
      IF ((size(tmp))(0) NE 0) THEN BEGIN
         lat(tmp)  = DOUBLE(90.D * z(tmp)/ABS(z(tmp)))
         lon(tmp) = 0.D
         r = 6378.D
      ENDIF

      tmp2 = WHERE(lon LT 0)
      IF ((size(tmp2))(0) NE 0) THEN BEGIN
         lon(tmp2) = lon(tmp2) + 360.D
      ENDIF

END

;---------------------------------------------------------------

PRO get_scalarP,Ox,Oy,Oz,Lx,Ly,Lz,emis_hgt,ncols,nrows,s,f, $
                off_axis,num_off_axis

;...  Equatoral radius (km) and polar flattening of the earth
;     Ref: Table 15.4, 'Explanatory Supplement to the
;          Astronomical Almanac,' K. Seidelmann, ed. (1992).
      re_eq = 6378.136D
      inv_f = 298.257D

;...  initialize output
      s =  DBLARR(ncols,nrows)
      s1 = DBLARR(ncols,nrows)
      s2 = DBLARR(ncols,nrows)

;...  get polar radius
      re_po = re_eq*(1.D - 1.D / inv_f)

;...  get radii to assumed emission height
      ree = re_eq + emis_hgt
      rep = re_po + emis_hgt

;...  get flattening factor based on new radii
      f = (ree - rep)/ree

;...  get elements of quadratic formula
      a = fgeodeP(ree,rep,Lx,Ly,Lz,Lx,Ly,Lz)
      b = fgeodeP(ree,rep,Lx,Ly,Lz,Ox,Oy,Oz) * 2.D
      c = fgeodeP(ree,rep,Ox,Oy,Oz,Ox,Oy,Oz) - ree*ree

;...  check solutions to quadratic formula
      determinant = b*b - 4.D * a*c
;...  remove points off the earth
      determinant = determinant > 0.
      off_axis = WHERE(determinant EQ 0.,num_off_axis)
      IF(num_off_axis GT 0) THEN b(off_axis) = 0.D
;...  solve quadratic formula (choose smallest solution)
      s1 = ( -b + SQRT(determinant) ) / ( 2.D * a )
      s2 = ( -b - SQRT(determinant) ) / ( 2.D * a )

      s = s1<s2

END

;-------------------------------------------------------------------------
;  ROUTINE:	fuv_ptg
;-------------------------------------------------------------------------
;  this routine is based on the POLAR UVI ptg.pro but was modified for the
;	IMAGE FUV instrument
;	Harald Frey, 01/05/2000
;	Thomas Immel 03/2001  load_stars now called


PRO fuv_ptg,image_info_for_instrument,time,emis_hgt,gclat,gclon,l0,ras,decl $
       ,geodetic=geodetic,getra=getra,ra=ra,dec=dec,s=s $
       ,LpixX=LpixX,LpixY=LpixY,LpixZ=LpixZ $
       ,posX=posX,posY=posY,posZ=posZ $
       ,versStr=versStr,help=help $
       ,earthlat=earthlat,earthlon=earthlon, gsecoords = gsecoords $
       ,stopper = stopper, clock = clock, nocommon = nocommon

if keyword_set(nocommon) gt 0 then goto, skip_common

;@fuv_cmnblk    ;so we can load sza/dza into imageinfo

COMMON FUV_struct1, ImageInfo,cilon,cilat	
COMMON fuv_observ,  sza_arr,dza_arr
COMMON FUV_stars,new_starsx,new_starsy,star_flag

skip_common:

if keyword_set(nocommon) gt 0 then star_flag =  0 ;this is assigned at a point in fuview

    IF(KEYWORD_SET(help)) THEN BEGIN
       PRINT,''
       PRINT,' PRO fuv_ptg,system,time,emis_hgt,gclat,gclon,l0,ras,decl
       PRINT,''
       PRINT,' Original base code:  UVIPTG'
       PRINT,' 7/31/95  Author:  G. Germany'
       PRINT,' Development into PTG: 01/15/98'
       PRINT,' Authors:  Mitch Brittnacher & John O''Meara'
       PRINT,'           changed into fuv_ptg by Harald Frey, 01/05/2000'
       PRINT,''
       PRINT,' calculates geocentric lat,lon, for a complete image
       PRINT,'
       PRINT,' input
       PRINT,'    image_info_for_instrument   structure which contains all values
       PRINT,'    				for pointing calculation
       PRINT,'    time            time(1)=yyyyddd, time(2)=msec of day
       PRINT,'    emis_hgt        los altitude
       PRINT,'
       PRINT,' output
       PRINT,'	  l0		  look direction in gci for central pixel'
       PRINT,'    ras		  RA for central pixel'
       PRINT,'	  decl		  DEC for central pixel'
       PRINT,'    gclat           geocentric latitude'
       PRINT,'    gclon           geocentric longitude'
       PRINT,''
       PRINT,' keywords'
       PRINT,'    geodetic        (set) returns geodetic values if set'
       PRINT,'    getra           (set) calulates ra & dec if set'
       PRINT,'       ra           (out) right ascension (deg)'
       PRINT,'      dec           (out) declination (deg)'
       PRINT,'        s           (out) scalar for lpix'
       PRINT,'    lpixX           (out) x component of unit look direction'
       PRINT,'    lpixY           (out) y component of unit look direction'
       PRINT,'    lpixZ           (out) z component of unit look direction'
       PRINT,'     posX           (out) x,y,z components of vector from'
       PRINT,'     posY           (out)       earth center to emission'
       PRINT,'     posZ           (out)'
       PRINT,'     earthlat       (out) hfrey, added 10/23/2000 center of proj.'
       PRINT,'     earthlon       (out) hfrey, added 10/23/2000 center of proj.'
       PRINT,'     gse      (out) tji, added 2-10-2003. gse coords of pixels'
       PRINT,'     clock    (out) tji, added 2-12-2003. clock ang. of pixels'
       PRINT,'     nocommon (set) tji, added 2-12-2003. for use independent of fuview'
       PRINT,'  versStr           (out) software version string'
       PRINT,'
       PRINT,' external library routines required'
       PRINT,'    ic_gci_to_geo'
       PRINT,'    ic_gci_to_gse (optional)'
       PRINT,'    fuv_rotation_matrix'
       PRINT,''
       PRINT,' NOTES:'
       PRINT,''
       PRINT,' 1. Unlike UVIPTG, this routine returns latitude and longitude'
       PRINT,'    for all pixels in an image.  It does the calculation in a'
       PRINT,'    fraction of the time required by UVIPTG.'
       PRINT,''
       PRINT,' 2. The default lat/lon values are in geocentric coordinates.'
       PRINT,'    Geographic (geocentric) coordinates assume the earth is'
       PRINT,'    a sphere and are defined from the center of the sphere.'
       PRINT,'    For geodetic coordinates, the earth is assumed to be an'
       PRINT,'    ellipsoid of revolution.  See the routine fgeode for'
       PRINT,'    details.'
       PRINT,'    Geodetic coordinates are defined from the normal to the'
       PRINT,'    geode surface.  To enable geodetic calculations, set the'
       PRINT,'    keyword /GEODETIC.'
       PRINT,''
       PRINT,' 3. The look direction for a specified pixel (Lpix) is'
       PRINT,'    calculated from the rotation matrix provided by the'
       PRINT,'    routine fuv_rotation_matrix.'
       PRINT,'    Each pixel is assumed to have'
       PRINT,'    a fixed angular width.  The angular distance from the center'
       PRINT,'    of the pixel to the center of the fov is calculated and then'
       PRINT,'    the look direction of this pixel is determined.'
       PRINT,''
       PRINT,' 5. Geocentric lat/lon values are the intersection'
       PRINT,'    of the look direction for the specified pixel (Lpix) and'
       PRINT,'    the surface of the earth.  The geocentric values are then'
       PRINT,'    transformed into geodetic values.  The vector from the'
       PRINT,'    center of the earth to the intersection is pos so that'
       PRINT,'    pos = orb + S*Lpix, where orb is the GCI orbit vector'
       PRINT,'    and S is a scalar.'
       PRINT,''
       PRINT,' 6. The intersection of Lpix and the earth is calculated first'
       PRINT,'    in GCI coordinates and then converted to geographic'
       PRINT,'    coordinates.  The conversion is by means of ic_gci_to_geo.'
       PRINT,'    This routine and its supporting routines, was taken from'
       PRINT,'    the CDHF and is part of the ICSS_TRANSF_orb call.'
       PRINT,''
       PRINT,' 7. The viewed emissions are assumed to originate emis_hgt km'
       PRINT,'    above the surface of the earth.  See get_scalar for details.'
       PRINT,''
       PRINT,'10. The keywords POS(xyz) are needed for LOS corrections.'
       PRINT,''
       PRINT,' Version History 1.0 All above authors and functions apply'
       PRINT,'		       1.1 -stars common block'
       PRINT,'		           -displacement in x for prepare_mpeg keyword?'
       PRINT,'			   -remove orbpos from call, same as o_gci(0:2)'
       PRINT,'			   -/sza and /dza, create common block,'
       PRINT,'				and keyword_set'
       PRINT,'			   -add @fuv_cmnblk.pro to load common blocks'
       RETURN
     ENDIF

	; here we define individual variables
	; this may look ugly, but we use as much of the old ptg.pro as possible
     nrows = image_info_for_instrument.rows
     ncols = image_info_for_instrument.cols
     pr = image_info_for_instrument.angl_res_r
     pc = image_info_for_instrument.angl_res_c

     versStr = 'FUV_PTG v1.2  3/2001  TJI'
     zrot  = DBLARR(ncols,nrows)
     yrot  = DBLARR(ncols,nrows)
     gclat = DBLARR(ncols,nrows)
     gclon = DBLARR(ncols,nrows)
     ra    = DBLARR(ncols,nrows)
     dec   = DBLARR(ncols,nrows)

     fill_value = -1.D31

;... initialize output arrays to default
     gclat(*,*) = fill_value
     gclon(*,*) = fill_value
        ra(*,*) = fill_value
       dec(*,*) = fill_value

;... find rotation angles for each pixel
;    unless in uvilook, the axis definition is different for FUV
;    UVI defined the image axes as
;
;              UVI			FUV
;	zrot going horizontally		xrot going horizontally
;	yrot going vertically		yrot going vertically
;	x    going outward		z    going inward as photons

     a = (FINDGEN(ncols)- (ncols-1)/2)*pc
     b = REPLICATE(1.,nrows)
     xrot = a#b
     c = (FINDGEN(nrows)- (nrows-1)/2)*pr
     d = REPLICATE(1.,ncols)
     yrot = d#c

;... Determine Lpix
     tanx = tan(xrot*!DPI/180d)
     tany = tan(yrot*!DPI/180d)

     lpz = -1.D /SQRT(1.D + tany*tany + tanx*tanx)
     lpx = -lpz*tanx
     lpy = -lpz*tany

;... call the routine which determines the rotation matrix

     omega = image_info_for_instrument.inst_roll
     theta = image_info_for_instrument.inst_co_elev
     phi   = image_info_for_instrument.inst_azimuth
     scsv_x = image_info_for_instrument.sc_sv[0]
     scsv_y = image_info_for_instrument.sc_sv[1]
     scsv_z = image_info_for_instrument.sc_sv[2]
     sc_x = image_info_for_instrument.a_gci3[0]
     sc_y = image_info_for_instrument.a_gci3[1]
     sc_z = image_info_for_instrument.a_gci3[2]
     psi = image_info_for_instrument.spin_phase		; in degrees

;---these used to be defined later, but are needed now!

     Ox = image_info_for_instrument.o_gci[0]
     Oy = image_info_for_instrument.o_gci[1]
     Oz = image_info_for_instrument.o_gci[2]

	print,phi,theta,omega,' Printed Phi, Theta etc...'

     transformation_matrix = fuv_rotation_matrix(omega,theta,phi, $
        scsv_x,scsv_y,scsv_z,sc_x,sc_y,sc_z,psi,image_info_for_instrument)

;... apply rotation

     result = transformation_matrix ## [[lpx[*]],[lpy[*]],[lpz[*]]]

;... determine Lpix

     LpixX = reverse(reform(result[*,0],ncols,nrows),1)
     LpixY = reverse(reform(result[*,1],ncols,nrows),1)
     LpixZ = reverse(reform(result[*,2],ncols,nrows),1)

;    calculate right ascension and declination
     IF(KEYWORD_SET(getra)) THEN $
        vector_to_ra_decP,LpixX,LpixY,LpixZ,ra,dec

;... Find scalar (s) such that s*L0 points to
;    the imaged emission source.  If the line of
;    sight does not intersect the earth s=0.0
     Ox = image_info_for_instrument.o_gci[0]
     Oy = image_info_for_instrument.o_gci[1]
     Oz = image_info_for_instrument.o_gci[2]

     get_scalarP,Ox,Oy,Oz,LpixX,LpixY,LpixZ,emis_hgt,ncols,nrows,s,f, $
                off_axis,num_off_axis

;---these are the GCI coords of each observed location on Earth
     posX = Ox + s*LpixX
     posY = Oy + s*LpixY
     posZ = Oz + s*LpixZ

;... Convert from GCI to GEO coordinates.  ROTM is the
;    rotation matrix.
     ic_gci_to_geo,time,rotm
     p_geoX = rotm(0,0)*posX + rotm(1,0)*posY + rotm(2,0)*posZ
     p_geoY = rotm(0,1)*posX + rotm(1,1)*posY + rotm(2,1)*posZ
     p_geoZ = rotm(0,2)*posX + rotm(1,2)*posY + rotm(2,2)*posZ

;... Get geocentric lat/lon.  this converts from
;    a 3 element vector to two angles: lat & longitude
     drtollP,p_geoX,p_geoY,p_geoZ,gclat,gclon,r
     gclat = gclat < 90.

;... Convert to geodetic lat/lon.  F is the flattening
;    factor of the Earth.  See get_scalar for details.
;    Ref: Spacecraft Attitude Determination and Control,
;    J.R. Wertz, ed., 1991, p.821.
     IF(KEYWORD_SET(geodetic)) THEN BEGIN
        gdlat = 90.D + 0.D * gclat
        ndx = WHERE(gclat LT 90.,count)
        IF(count GT 0) THEN BEGIN
           gdlat(ndx) = datand(dtand(gclat(ndx))/((1.D - f)*(1.D - f)))
        ENDIF
        gclat = gdlat
     ENDIF

     IF (num_off_axis GT 0) THEN BEGIN
       gclat(off_axis) = fill_value
       gclon(off_axis) = fill_value
     ENDIF

;... provide some more output variables, at the moment I don't know if they
;	are really necessary, but who knows?

     l0=[LpixX[ncols/2-1,nrows/2-1], $
         LpixY[ncols/2-1,nrows/2-1], $
         LpixZ[ncols/2-1,nrows/2-1]]
     ras = 0d
     decl = 0d
     vector_to_ra_decP,l0[0],l0[1],l0[2],ras,decl

;--- load star positions into common block STARS 

if (star_flag eq 1) then load_stars,transformation_matrix,l0 else begin
	new_starsx=findgen(5)	
	new_starsy=findgen(5)
endelse	
;------------------

;... NEW - calculate solar zenith angle:::

dummy=lpixx & dummy(*)=0 & if off_axis(0) ne -1 then dummy(off_axis)=1

;---get solar angular coordinates, this procedure is in ~immel/idl

;     print, '--->Doing solar zenith angles'
	image_info_for_instrument.time=time
     SUN3,image_info_for_instrument,GST,SLON,RA,DEC
;	print,ra,dec

;---convert to GCI vector of sun [sun_x,sun_y,sun_z]

     sun_z=sind(dec)
     sun_x=cosd(dec)*cosd(ra)
     sun_y=cosd(dec)*sind(ra)	;a much smaller unit vector, but no matter.

;---calculate magnitude of each array of vectors, and dot product thereof

     mag_a=(sun_x^2+sun_y^2+sun_z^2)^(0.5)	;
     mag_b=(posx^2+posy^2+posz^2)^(0.5)
     dot=sun_x*posx+sun_y*posy+sun_z*posz
     sza_arr=acos(dot/(mag_a*mag_b))*!radeg
     if off_axis(0) ne -1 then sza_arr(off_axis)=-1
     sza_arr=reverse(sza_arr,1)	
     
;--- quickly calculate clock angle, the angle about the subsolar point

     new_trans = fltarr(3, 3)
     new_trans(*, 0) = [cosd(ra)*(cosd(dec)), $
                        sind(ra)*(sind(dec)), sind(dec)]
     new_trans(*, 1) = [-sind(ra), cosd(ra), 0]
     new_trans(*, 2) = [sind(dec)*cosd(ra), sind(dec)*sind(ra), cosd(dec)]

     new_result = new_trans ## [[posx[*]],[posy[*]],[posz[*]]]

     clocky = posx &  clockz = posx
     clocky(*) = new_result(*, 1)
     clockz(*) = new_result(*, 2)
     clock_arr = atan(clocky/clockz) * !radeg
     clock_arr = reverse(clock_arr, 1)
     clock = clock_arr
;	ImageInfo(inst).sza=sza_arr
;	pass in common block FUV_observ instead!!!

;--- now do spacecraft zenith angles...

;     print,'--->Doing spacecraft zenith angles'
     to_x=(Ox-posx)
     to_y=(Oy-posy)
     to_z=(Oz-posz)

;---calculate magnitude of each array of vectors, and dot product thereof
 
     mag_a=(to_x^2+to_y^2+to_z^2)^(0.5)
     mag_b=(posx^2+posy^2+posz^2)^(0.5)
     dot=to_x*posx+to_y*posy+to_z*posz
;---dza is simple
     dza_arr=acos(dot/(mag_a*mag_b))*!radeg
     if off_axis(0) ne -1 then dza_arr(off_axis)=-1
     dza_arr=reverse(dza_arr,1)

;    ImageInfo(inst).dza=dza_arr
;    pass in common block FUV_observ instead!!!
;... calculate the geographic coordinate of center of projection,
;    this is not the center of the image, as we apply sometimes an 
;    offset to limb. The output earthlat and earthlon are used in 
;    auroral_image.

     earth_x=-ox/sqrt(ox^2+oy^2+oz^2)
     earth_y=-oy/sqrt(ox^2+oy^2+oz^2)
     earth_z=-oz/sqrt(ox^2+oy^2+oz^2)
     get_scalarP,Ox,Oy,Oz,earth_x,earth_y,earth_z,emis_hgt,1,1,$
                 sres,f_earth,off_array,num_off
     pos_earth_X = Ox + sres*earth_x
     pos_earth_Y = Oy + sres*earth_y
     pos_earth_Z = Oz + sres*earth_z
     p_earthX = rotm(0,0)*pos_earth_X + rotm(1,0)*pos_earth_Y + rotm(2,0)*pos_earth_Z
     p_earthY = rotm(0,1)*pos_earth_X + rotm(1,1)*pos_earth_Y + rotm(2,1)*pos_earth_Z
     p_earthZ = rotm(0,2)*pos_earth_X + rotm(1,2)*pos_earth_Y + rotm(2,2)*pos_earth_Z
     drtollP,p_earthX,p_earthY,p_earthZ,earthlat,earthlon,earthr
     earthlat = earthlat < 90.

;--- NEW - calculate gse coordinates for each pixel
if keyword_set(gsecoords) gt 0 then begin
     posRA = atan(posy, posx)*!radeg
     posDec = atan(posz, (posx^2+posy^2)^0.5) *!radeg
     todo = where(gclat gt -1000, todocount)
     gci_coords = fltarr(2, todocount) 
     gci_coords(0, *) = posRA(todo) &  gci_coords(1, *) = posDec(todo)
;--- all at once do the following
     ic_gci_2_gse, gci_coords, gse_coords, RA, DEC;, /stopper
;--- one at a time do this
;     gse_coords = fltarr(3, todocount)
;     for i = 0l, todocount -1 do begin
;       ic_gci_2_gse, reform(gci_coords(*, i)), gse_holder, ra, dec
;       gse_coords(*, i) = gse_holder
;     endfor

     gse_x = gse_coords(0, *) & gse_y = gse_coords(1, *) & gse_z = gse_coords(2, *) &  
     newhelp = size(gclat)
     gsecoords = fltarr(newhelp(1), newhelp(2), 3)
     dummy = fltarr(newhelp(1), newhelp(2))
     todox = todo mod newhelp(1)
     todoy = todo/newhelp(1)
     dummy(todo) = gse_x  &  gsecoords(*, *, 0) = dummy 
     dummy(todo) = gse_y  &  gsecoords(*, *, 1) = dummy
     dummy(todo) = gse_z  &  gsecoords(*, *, 2) = dummy

endif


if keyword_set(stopper) gt 0 then stop



END
