;+-------------------------------------------------------------
; NAME:
;       mk_bitarray
; PURPOSE:
;       Create an array of 1's & 0's corresponding to input bits set
;	(works for negative numbers, too, unlike similar routines)
; CATEGORY:
;       Bits
; CALLING SEQUENCE:
;       IDL> array= mk_bitarray( input )
;       IDL> array= mk_bitarray( input, nbits=5 )
; INPUTS:
;       input = whatever; might be something like !X.STYLE  
; KEYWORD PARAMETERS:
;	NBITS=nbits - length of returned array (default to input type)
;	PRINT - if set, will print bits in groups of fours.
; OUTPUTS:
;       Byte array containing 1's and 0's               	out
; COMMON BLOCKS:
;       NONE
; EXAMPLE:
;	IDL> print,mk_bitarray(3, nbits=8)
;	   1   1   0   0   0   0   0   0
;	IDL> dum = mk_bitarray( 1025, /print )'
;	 1 0 0 0   0 0 0 0   0 0 1 0   0 0 0 0
; LIMITATION:
;	Only works on a scalar.
; MODIFICATION HISTORY:
;	05-Jun-00 default nbits to input type. add print keyword.
;       30-Mar-99 Written by Bill Davis, PPPL
;--------------------------------------------------------------
FUNCTION mk_bitarray, input, NBITS=nbits, PRINT=print

IF N_ELEMENTS( nbits ) EQ 0 THEN BEGIN
   nbits = 32
   siz = size(input)
   typ = siz( siz(0)+1 )
   if (typ EQ 1) then nbits = 8 $
   else if (typ EQ 2) then nbits = 16 $
   else if (typ EQ 3) then nbits = 32 $
   ELSE BEGIN
      nbits = 32
      input = LONG(input)
   ENDELSE
ENDIF ELSE BEGIN	; must be an integer for ishift to work
   siz = size(input)
   typ = siz( siz(0)+1 )
   if (typ GT 3) then BEGIN
;      IF MAX(input) GE 2l^16 THEN BEGIN
	 nbits = 32
	 input = LONG(input)
;      ENDIF ELSE BEGIN
;	 nbits = 16
;	 input = FIX(input)
;      ENDELSE
   ENDIF
ENDELSE

IF siz(0) GT 0 THEN BEGIN
   array = BYTARR( nbits, siz(1) )
   for j = 0, siz(1)-1 DO BEGIN
      for i = 0, nbits-1 do BEGIN
	 array(i, j) = ISHFT( input(j), i*(-1)) AND 1
      ENDFOR
   ENDFOR
ENDIF ELSE BEGIN
   array = BYTARR( nbits )
   for i = 0, nbits-1 do BEGIN
      array(i) = ISHFT( input, i*(-1)) AND 1
   ENDFOR
ENDELSE

IF KEYWORD_SET( Print ) THEN print,array,format='(8(4i2,2x))'

RETURN, array

END

