; @(#)main_scr3.pro	8.0 November 2, 2006
;------------------------------------------------------------------------------------
; This the latest version of FUView
;
;Modified:
;
; Hassan Dougani	10/26/1999	Applying the lastes FUV modifications
; Hassan Dougani	1/12/1999	Modifying keogram menubar function: adding config. option
; Harald Frey		01/18/2000	reading UDF files
; Hassan Dougani	02/10/2000      Add scaling and Cursor Inquiry
; Harald Frey		Mar 2000-Sep 2001 Added several features like dayglow,
;					scaling, Rayleigh conversion, made keograms work etc....
; Harald Frey           04/21/2003	works now for southern hemisphere, 5.3
; Harald Frey           11/21/2005      works now with IDL udf_dlm of Chris Gurgiolo
; Harald Frey           11/02/2006      pointing correction with satellite data
;------------------------------------------------------------------------------------
;
FUNCTION get_fname,stime
 ;
 @fuv_cmnblk
 ; Create a filename for Create Gif option

    cdf_epoch, stime.epoch, $
        year, month, day, hour, minute,second,/BREAKDOWN_EPOCH
; Set File extension
    fext='.gif'
    if (ps_flag eq 1) then fext='.ps'
    if (xdr_flag eq 1) then fext='_'
;
; For default (all)
    if(cor eq 0 or xdr_flag eq 1)  then begin
        fname=string(FORMAT='(I4,I2.2,I2.2,I2.2,I2.2,I2.2)', $
        year, month, day, hour, minute,second)+fext

        return, fname
    endif
;
; For Geodetic images
    if(cor eq 1 and xdr_flag eq 0)   then begin
      if (multi_inst gt 1) then $
          fname=string(FORMAT='(I4,I2.2,I2.2,I2.2,I2.2,I2.2,"_gd_cmp")', $
          year, month, day, hour, minute,second) + fext $
      else  $
          fname=string(FORMAT='(I4,I2.2,I2.2,I2.2,I2.2,I2.2,"_gd")', $
          year, month, day, hour, minute,second)+fext
;
          gif_x = 15.5*border+nypix
          return, fname
    endif

;; For Magnetic
    if(cor eq 2 and xdr_flag eq 0) then begin
      if (multi_inst gt 1) then $
          fname=string(FORMAT='(I4,I2.2,I2.2,I2.2,I2.2,I2.2,"_mag_cmp")', $
          year, month, day, hour, minute,second)+fext $
      else  $
          fname=string(FORMAT='(I4,I2.2,I2.2,I2.2,I2.2,I2.2,"_mag")', $
          year, month, day, hour, minute,second)+fext
           return, fname
    endif
 return,-1
end
;----------------------------------------------------------------------
function  put_doy,year,d_oy

;C****************************************************
;C
;C   author : hfrey, 12-06-99
;C
;C   general description:
;C   This function converts the day of year to month and day.
;C
;C   call_var.  dim. type  I/O  description
;C   MM               I    i    UT Month
;C   DD               I    i    UT Day
;C
;C   returns                    message
;C   date                       if values ok
;C
;C**********************************************************************

doy=d_oy
dtab=[31,28,31,30,31,30,31,31,30,31,30,31]

if (year lt 1901 or year gt 2099) then return,-1
if (doy gt 366 or doy lt 1) then return,-1

if((year mod 4) eq 0 and doy eq 60) then feb=1 else feb=0	; 29th February
if((year mod 4) eq 0 and doy gt 59) then doy=doy-1	; leap year

i=-1
repeat begin
	i=i+1
	doy=doy-dtab[i]
	endrep until (doy le 0)

mm=i+1
if (mm lt 10) then month=strcompress('0'+string(fix(mm)),/remove_all) else $
	month=strcompress(string(mm),/remove_all)
dd=doy+dtab[i]+feb
if (dd lt 10) then day=strcompress('0'+string(fix(dd)),/remove_all) else $
	day=strcompress(string(dd),/remove_all)

date=strcompress(month+'-'+day)

return,date

end

;--------------------------------------------------------------
pro main_scr_event, event
;
@fuv_cmnblk

    name = tag_names(event, /structure)

;

    WIDGET_CONTROL,event.id, GET_UVALUE=type

;; 1: Time Record Selected  2210-2220: Background Color 2310-2350: Text color 2410-2450: Line color 2510-2550: Grid color
;; 2610-2660: cont color 3110-3120: Coordinates  3210: ColorBar

   case type of
;
;; Make selection from list
;; Displays Image when "Highlighted time record" on right hand side when clicked
      1: begin
            widget_control, /HOURGLASS
            get_list
         end
;
;Set background color
    2210: begin
              bkgrnd = white_clr  ;White background
              refresh
          end
    2220: begin
              bkgrnd = black  ;Black background
              refresh
          end

;Set text color
    2310: begin
              txt_clr = black
              refresh
          end
    2320: begin
              txt_clr = blue
              refresh
          end
    2330: begin
              txt_clr = red
              refresh
          end
    2340: begin
              txt_clr = white_clr
              refresh
          end
    2350: begin
              txt_clr = green
              refresh
          end

;Set line color

    2410: begin
            lin_clr = black
            refresh
          end
    2420: begin
            lin_clr = blue
            refresh
          end
    2430: begin
            lin_clr = red
            refresh
          end
    2440: begin
            lin_clr = white_clr
            refresh
          end

    2450: begin
           lin_clr = green
           refresh
          end

;Set grid color
    2510: begin
           grd_color = black
           refresh
          end
    2520: begin
           grd_color = blue
           refresh
          end

    2530: begin
           grd_color = red
           refresh
          end
    2540: begin
            grd_color = white_clr
            refresh
          end
    2550: begin
            grd_color = green
            refresh
          end


;Set continent color
    2610: begin
            con_color = black
            refresh
          end
    2620: begin
            con_color = blue
            refresh
          end
    2630: begin
            con_color = red
            refresh
          end
    2640: begin
            con_color = white_clr
            refresh
          end
    2650: begin
            con_color = green
            refresh
          end
; Take Off Continents line
    2660: begin
            drawcont = 0
            refresh
          end

; Turn On Continents line
    2670: begin
            drawcont = 1
            test_latlon=0
            refresh
          end
; Stars
; Take Off Continents line
    2760: begin
            star_flag = 0
            refresh
          end

; Turn On Continents line
    2770: begin
            star_flag = 1
            refresh
          end
;
;Set Geographic Coordinates GDI
	3010: begin
            widget_control, /HOURGLASS
			gci_flag=0
			WIDGET_CONTROL,gdi_opt_id,SENSITIVE=0
			WIDGET_CONTROL,gci_opt_id,SENSITIVE=1
			prevrec=-1					;Force Recalculation
            getplot,active_inst,current
		  end
;
;Set Geographic Coordinates GCI
	3020: begin
            widget_control, /HOURGLASS
			gci_flag=1
			WIDGET_CONTROL,gdi_opt_id,SENSITIVE=1
			WIDGET_CONTROL,gci_opt_id,SENSITIVE=0
			prevrec=-1					;Force Recalculation
            getplot,active_inst,current
		  end
;
;Set coordinate system
    3110: begin		;Geographic
              if (cor ne 1) then begin
               cor = 1
               change_size
              endif
          end
    3120: begin		;Magnetic
              if (cor ne 2) then begin
               cor = 2
               change_size
              endif
          end
    3130: begin		;Both
              if (cor ne 0) then begin
               cor = 0
               change_size
              endif
          end

;Set color bar
    3210: begin		;On
              baronof = 1
              change_size
          end
    3220: begin		;Off
              baronof = 0
              change_size
          end
;
;Position Longitude and Latitude
	9515: begin
			WIDGET_CONTROL,GET_VALUE=tmp,position_lon_id
			    dummy=strsplit(tmp,',',/extract)
			    if (n_elements(dummy) eq 2) then begin
			      position_long=[position_long,float(dummy[0])]
			      position_lati=[position_lati,float(dummy[1])]
                              refresh						;Refresh with new Position
                              endif else res=dialog_message('Separate Long. and Lat. with comma')
		  end

;Position Longitude and Latitude
	9516: begin
			WIDGET_CONTROL,GET_VALUE=tmp,position_lon_id
			    position_long=0.
			    position_lati=0.
                            refresh						;Refresh with new Position
		  end

;
;Get hemisphere
	9300: begin
			WIDGET_CONTROL,GET_VALUE=tmp,sphere_id
			   sphere=-2*tmp+1
		prevrec=-1					;Force Recalculation
                getplot,active_inst,current
		  end
; *****ESC, Stop button added to allow recompiling subroutines
; Stop button
	9350: begin
			str2='To continue, enter .con'
			PRINT,''
			PRINT,'% fuview: Execution of fuview is suspended. '+str2
			PRINT,'          Now you can edit and compile any routine that'
			PRINT,'          fuview uses, apart from the routines in main_scr.pro'
			PRINT,'          Used for editing or debugging, esp. plot routines'
			stop,''
		  end
; *****ESC
; change minimum latitude
        9360: begin
              if (latmin eq 50.) then latmin=40. else latmin=50.
		prevrec=-1					;Force Recalculation
                getplot,active_inst,current
              end

;Get Calibration Type
	9400: begin
			WIDGET_CONTROL,GET_VALUE=tmp,calib_id
			if (calibration_flag ne tmp) then begin
			   calibration_flag=tmp
			   endif
		  end
;Get Scaling Type
	9500: begin
			WIDGET_CONTROL,GET_VALUE=tmp,scale_id
			if (scale_type ne tmp) then begin
			 scale_type=tmp
			 if (tmp eq 0) then begin
;			  WIDGET_CONTROL,lin_slider_id,sensitive=0
			  WIDGET_CONTROL,log_min_id,SET_VALUE=log_scl_min
			  WIDGET_CONTROL,log_max_id,SET_VALUE=log_scl_max
			 endif else begin
;			  WIDGET_CONTROL,lin_slider_id,sensitive=1
			  WIDGET_CONTROL,log_min_id,SET_VALUE=lin_scl_min
			  WIDGET_CONTROL,log_max_id,SET_VALUE=lin_scl_max
			 endelse
             refresh								;Refersh with new scaling
			endif
		  end
;
;scale min value
	9510: begin
			WIDGET_CONTROL,GET_VALUE=tmp,log_min_id
			if (scale_type eq 0) then begin
			 if (log_scl_min ne tmp) then begin
			  if (tmp le 0 ) then begin
			   WIDGET_CONTROL,status_id,set_value=keo_errmsg[4]		; Invalid value
			   WIDGET_CONTROL,SET_VALUE=log_scl_min,log_min_id
			  endif else begin
			   if (tmp ge log_scl_max) then begin
			    WIDGET_CONTROL,status_id,set_value=keo_errmsg[1]		; Invalid value
			    WIDGET_CONTROL,SET_VALUE=log_scl_min,log_min_id
			   endif else begin
			    log_scl_min=tmp
                refresh								;Refersh with new log min value
               endelse
              endelse
			 endif
			endif else begin
			 if (lin_scl_min ne tmp) then begin
			  if (tmp ge lin_scl_max) then begin
			   WIDGET_CONTROL,status_id,set_value=keo_errmsg[1]		; Invalid value
			   WIDGET_CONTROL,SET_VALUE=lin_scl_min,log_min_id
			  endif else begin
			   lin_scl_min=tmp
               refresh								;Refersh with new log min value
              endelse
			 endif
			endelse
		  end
;
;scale max value
	9520: begin
			WIDGET_CONTROL,GET_VALUE=tmp,log_max_id
			if (scale_type eq 0) then begin
			 if (log_scl_max ne tmp) then begin
			  if (tmp le 0 ) then begin
			   WIDGET_CONTROL,status_id,set_value=keo_errmsg[4]		; Invalid value
			   WIDGET_CONTROL,SET_VALUE=log_scl_max,log_max_id
			  endif else begin
			   if (tmp le log_scl_min) then begin
			    WIDGET_CONTROL,status_id,set_value=keo_errmsg[1]		; Invalid value
			    WIDGET_CONTROL,SET_VALUE=log_scl_max,log_max_id
			   endif else begin
			    log_scl_max=tmp
                refresh								;Refersh with new log min value
               endelse
              endelse
			 endif
			endif else begin
			 if (lin_scl_max ne tmp) then begin
			  if (tmp le lin_scl_min) then begin
			   WIDGET_CONTROL,status_id,set_value=keo_errmsg[1]		; Invalid value
			   WIDGET_CONTROL,SET_VALUE=lin_scl_max,log_max_id
			  endif else begin
			   lin_scl_max=tmp
               refresh								;Refersh with new log min value
              endelse
			 endif
			endelse
		  end
;
;Get Auto Scale Status
;
    9530: begin
    	  end
;
;Get slider value
;	9540: begin
;			WIDGET_CONTROL,GET_VALUE=tmp,lin_slider_id
;			if (lin_scale ne tmp) then begin
;			 lin_scale=tmp
;            refresh								;Refersh with new linear scaling value
;			endif
;		  end
;
;Get Airglow flag
	9600: begin
			WIDGET_CONTROL,GET_VALUE=tmp,air_id
			if (airglow_flag ne tmp) then begin
			 airglow_flag=tmp

;--- want to set airglow scale once only, then leave the operator
;--- alone in case one wants to click back and forth.

			 if airglow_flag eq 1 and total(airglow_scale) eq 0 $
			 then airglow_scale=[1.0,1.0,0.0]
			 if airglow_flag eq 2 and total(airglow_scale) eq 0 $
			 then airglow_scale=[1.0,1.0,0.0]

			WIDGET_CONTROL,air_scl_id1,SET_VALUE=airglow_scale(0)
			WIDGET_CONTROL,air_scl_id2,SET_VALUE=airglow_scale(1)
			WIDGET_CONTROL,air_scl_id3,SET_VALUE=airglow_scale(2)
			endif
		  end
;airglow correction value
	9610: begin
			WIDGET_CONTROL,GET_VALUE=tmp,air_scl_id1
			if (airglow_scale(0) ne tmp) then begin
			airglow_scale(0)=tmp
			if (total(airglow_scale) eq 0.0) then begin
			   airglow_flag=0
			   WIDGET_CONTROL,air_id,SET_VALUE=0
			endif else begin
			   airglow_flag=1
			   WIDGET_CONTROL,air_id,SET_VALUE=1
			endelse
			endif

	      endcase

	9612: begin
			WIDGET_CONTROL,GET_VALUE=tmp,air_scl_id2
			if (airglow_scale(1) ne tmp) then begin
			airglow_scale(1)=tmp
			if (total(airglow_scale) eq 0.0) then begin
			   airglow_flag=0
			   WIDGET_CONTROL,air_id,SET_VALUE=0
			endif else begin
			   airglow_flag=1
			   WIDGET_CONTROL,air_id,SET_VALUE=1
			endelse
			endif

	      endcase

	9614: begin
			WIDGET_CONTROL,GET_VALUE=tmp,air_scl_id3
			if (airglow_scale(2) ne tmp) then begin
			airglow_scale(2)=tmp
			if (total(airglow_scale) eq 0.0) then begin
			   airglow_flag=0
			   WIDGET_CONTROL,air_id,SET_VALUE=0
			endif else begin
			   airglow_flag=1
			   WIDGET_CONTROL,air_id,SET_VALUE=1
			endelse
			endif

	      endcase


;;;;;;;
     endcase
   end

;
; Create GIFs button click event procedure
pro btnCreateGif_Click, event
@fuv_cmnblk

    makegif = 1
    pad = 5

;
    widget_control, /HOURGLASS
;
; plot to Z Buffer
    set_plot, 'Z'
    device, z_Buffering = 1
    if (cor eq 0) then $
      device, set_resolution = [640,460] $
    else begin
      xs=(multi_inst*270)+100
      if (multi_inst eq 1) then xs=xs+50
      device, set_resolution = [xs,460]
    endelse
;    num_list = N_ElEMENTS(listid)
    runflag = 0	;Clear the run flag
    giflist
    if (!d.name eq 'Z') then device, z_Buffering = 0
    if (!d.name eq 'Z') then device, /close
    set_plot,win_dev

 end

;========================================================================
; Create PS button click event procedure
pro btnPrintPS, event
@fuv_cmnblk
widget_control, event.id, get_uvalue = eventval

;
; Default item ( first one in the list)
    widget_control, stopevnt, sensitive = 0          ; Disable Stop
    widget_control, pausevnt, sensitive = 0          ; Disable Pause
    widget_control, backward_all, sensitive = 0      ; Disable Play back
    widget_control, nextall, sensitive = 0           ; Disable Play next
    widget_control, next, sensitive = 0              ; Disable next
    widget_control, prevkey, sensitive = 0           ; Disable previous

	ps_flag=1
;
; Default item ( first one in the list)
       widget_control, /HOURGLASS
       if(num_list eq 0) then  begin
            stat_txt = 'Loading  Image . '
            WIDGET_CONTROL,status_id, set_value=stat_txt
            psp.xsize = float(!D.X_SIZE*2)/100.
            psp.ysize = float(!D.Y_SIZE*2)/100.

            SET_PLOT,'ps'
            DEVICE,FILE='idl.ps',/COLOR,BITS=8,/TIMES,  $
                   SCALE_FACTOR=1., YSIZE=psp.ysize, XSIZE=psp.xsize, $
                   XOFFSET=psp.x_off, YOFFSET=psp.y_off,FONT_SIZE=8
            TVLCT,rct,gct,bct
            getplot,active_inst,current
            DEVICE,/CLOSE
            SET_PLOT,win_dev
            case eventval of
            4010: command=print_black_white + ' idl.ps'
            4020: command=print_color + ' idl.ps'
            endcase
            SPAWN, command
            stat_txt = 'Postscript Print Completed '
            WIDGET_CONTROL, status_id, set_value=stat_txt
       endif else begin

; Check if user wants to Cancel
       widget_control, stopevnt, sensitive = 1          ; enble Stop
       psp.xsize = float(!D.X_SIZE*2)/100.
       psp.ysize = float(!D.Y_SIZE*2)/100.

       runflag=1
             for i= 0,num_list-1 do begin
                  getout=widget_event(stopevnt,/NOWAIT)
                  if(runflag eq 0)then goto, stop_ps
                  current= recnum(listid(i))

                  SET_PLOT,'ps'
            	  DEVICE,FILE='idl.ps',/COLOR,BITS=8,/TIMES, $
                   SCALE_FACTOR=1., YSIZE=psp.ysize, XSIZE=psp.xsize, $
                   XOFFSET=psp.x_off, YOFFSET=psp.y_off,FONT_SIZE=8
                  TVLCT,rct,gct,bct
                  getplot,active_inst,current
                  DEVICE,/CLOSE
                  SET_PLOT,win_dev
                  case eventval of
                  4010: command=print_black_white + ' idl.ps'
                  4020: command=print_color + ' idl.ps'
                  endcase
                  SPAWN, command
                  stat_txt = 'Postscript Print Completed '
                  WIDGET_CONTROL, status_id, set_value=stat_txt
              endfor
       runflag=0
      endelse
;
stop_ps:
    widget_control, stopevnt, sensitive = 0
    widget_control, pausevnt, sensitive = 0
    widget_control, backward_all, sensitive = 1
    widget_control, nextall, sensitive = 1
    widget_control, next, sensitive = 1
    widget_control, prevkey, sensitive = 1
;
	ps_flag=0
 end
;================================================================
;
; Create PS button click event procedure
pro btnCreatePS_Click, event
@fuv_cmnblk

;
	ps_flag=1
;
; Default item ( first one in the list)
    widget_control, stopevnt, sensitive = 0          ; Disable Stop
    widget_control, pausevnt, sensitive = 0          ; Disable Pause
    widget_control, backward_all, sensitive = 0      ; Disable Play back
    widget_control, nextall, sensitive = 0           ; Disable Play next
    widget_control, next, sensitive = 0              ; Disable next
    widget_control, prevkey, sensitive = 0           ; Disable previous

;; plot to PS
       gifreslt =  dialog_pickfile(/DIR, PATH=GIFDIR, GET_PATH=GIFDIRT, $
       		TITLE='Select directory for Postscript file(s).')
       ; If Cancel selected
       if (gifreslt eq '') then return
; fix UNIX dialog_pickfile under IDL 6.0
        if (gifdirt ne '') then begin
           numb1=strpos(gifdirt,'/.')
           if (numb1 ne -1) then begin
             numb2=strlen(gifdirt)
             gifdir=strmid(gifdirt,0,numb1)+strmid(gifdirt,numb1+2,numb2-numb1-2)
             endif else gifdir=gifdirt
  	   endif

       widget_control, /HOURGLASS
       if(num_list eq 0) then  begin
            stat_txt = 'Loading  Image . '
            WIDGET_CONTROL,status_id, set_value=stat_txt
            psp.xsize = float(!D.X_SIZE*2)/100.
            psp.ysize = float(!D.Y_SIZE*2)/100.

            CASE active_inst of
            0: inst_name='wic_'
            1: inst_name='s12_'
            2: inst_name='s13_'
            ENDCASE
            SET_PLOT,'ps'
            psfile=GIFDIR+inst_name+get_fname(dstr(current,active_inst))
            DEVICE,FILE=psfile,/COLOR,BITS=8,/TIMES,  $
                   SCALE_FACTOR=1., YSIZE=psp.ysize, XSIZE=psp.xsize, $
                   XOFFSET=psp.x_off, YOFFSET=psp.y_off,FONT_SIZE=8
;            TVLCT,rct,gct,bct
            getplot,active_inst,current
            DEVICE,/CLOSE
            SET_PLOT,win_dev
            stat_txt = 'Postscript Operation Completed -> ' + psfile
            WIDGET_CONTROL, status_id, set_value=stat_txt
       endif else begin

; Check if user wants to Cancel
       widget_control, stopevnt, sensitive = 1          ; enble Stop
       psp.xsize = float(!D.X_SIZE*2)/100.
       psp.ysize = float(!D.Y_SIZE*2)/100.

       runflag=1
             for i= 0,num_list-1 do begin
                  getout=widget_event(stopevnt,/NOWAIT)
                  if(runflag eq 0)then goto, stop_ps
                  current= recnum(listid(i))

            	  CASE active_inst of
           	  0: inst_name='wic_'
            	  1: inst_name='s12_'
            	  2: inst_name='s13_'
            	  ENDCASE
                  SET_PLOT,'ps'
                  psfile=GIFDIR+inst_name+get_fname(dstr(current,active_inst))
            	  DEVICE,FILE=psfile,/COLOR,BITS=8,/TIMES, $
                   SCALE_FACTOR=1., YSIZE=psp.ysize, XSIZE=psp.xsize, $
                   XOFFSET=psp.x_off, YOFFSET=psp.y_off,FONT_SIZE=8
;                  TVLCT,rct,gct,bct
                  getplot,active_inst,current
                  DEVICE,/CLOSE
                  SET_PLOT,win_dev
                  stat_txt = 'Postscript Operation Completed -> ' + psfile
                  WIDGET_CONTROL, status_id, set_value=stat_txt
              endfor
       runflag=0
      endelse
;
stop_ps:
    widget_control, stopevnt, sensitive = 0
    widget_control, pausevnt, sensitive = 0
    widget_control, backward_all, sensitive = 1
    widget_control, nextall, sensitive = 1
    widget_control, next, sensitive = 1
    widget_control, prevkey, sensitive = 1
;
	ps_flag=0
 end
;================================================================
;
; Create XDR button click event procedure
pro btnCreateXDR_Click, event

@fuv_cmnblk

widget_control, event.id, get_uvalue = eventval

;
;  code minimum magnetic latitude into image
   imageinfo.mlt_img[0,0]=latmin*1.e-6
;  code hemisphere
   imageinfo.mlt_img[0,1]=sphere*1.e-6
;
;; Write XDR
;    num_list = N_ElEMENTS(listid)
    gifreslt =  dialog_pickfile(/DIR, PATH=GIFDIR, GET_PATH=GIFDIRT, TITLE='Select directory for XDR file(s).')
    ; If Cancel selected
    if (gifreslt eq '') then return
; fix UNIX dialog_pickfile under IDL 6.0
        if (gifdirt ne '') then begin
           numb1=strpos(gifdirt,'/.')
           if (numb1 ne -1) then begin
             numb2=strlen(gifdirt)
             gifdir=strmid(gifdirt,0,numb1)+strmid(gifdirt,numb1+2,numb2-numb1-2)
             endif else gifdir=gifdirt
  	   endif
;
; Default item ( first one in the list)
    widget_control, stopevnt, sensitive = 0          ; Disable Stop
    widget_control, pausevnt, sensitive = 0          ; Disable Pause
    widget_control, backward_all, sensitive = 0      ; Disable Play back
    widget_control, nextall, sensitive = 0           ; Disable Play next
    widget_control, next, sensitive = 0              ; Disable next
    widget_control, prevkey, sensitive = 0           ; Disable previous
;
    if (eventval eq 1280) then begin
       fast_flag=1
       if (fast_answer eq '') then fast_answer='y'
       endif
    widget_control, /HOURGLASS
    xdr_flag=1
    if(num_list eq 0) then  begin
       stat_txt = 'Loading  Image . '
       WIDGET_CONTROL,status_id, set_value=stat_txt
       getplot,active_inst,current
       xdrfile_tmp=GIFDIR+tmpfile
       for i=0,2 do begin
   	if (avail_inst(i) eq 1) then begin
	  CASE eventval of
          1230: begin
                xdr_image=imageinfo(i).image
                xdr_lat=imageinfo(i).glat
                xdr_lon=imageinfo(i).glon
                dummy=where(xdr_lat lt -1.e10,count)
                if (count gt 0) then xdr_lat[dummy]=!values.f_nan
                dummy=where(xdr_lon lt -1.e10,count)
                if (count gt 0) then xdr_lon[dummy]=!values.f_nan
                case i of
              	0:xdrfile=xdrfile_tmp+'wic'+'.sav'
              	1:xdrfile=xdrfile_tmp+'s12'+'.sav'
              	2:xdrfile=xdrfile_tmp+'s13'+'.sav'
                endcase
 	        xdr_image=rotate(xdr_image,3)
	        xdr_lat=reverse(xdr_lat,1)
	        xdr_lon=reverse(xdr_lon,1)
	        print, 'Saving file: ' + xdrfile
	        save,xdr_image,xdr_lat,xdr_lon,filename=xdrfile,/xdr
	        ENDCASE

          1232: begin
                xdr_image=imageinfo(i).image
                xdr_lat=imageinfo(i).glat
                xdr_lon=imageinfo(i).glon
                dummy=where(xdr_lat lt -1.e10,count)
                if (count gt 0) then xdr_lat[dummy]=!values.f_nan
                dummy=where(xdr_lon lt -1.e10,count)
                if (count gt 0) then xdr_lon[dummy]=!values.f_nan
                case i of
              	0:xdrfile=xdrfile_tmp+'wic'+'.sav'
              	1:xdrfile=xdrfile_tmp+'s12'+'.sav'
              	2:xdrfile=xdrfile_tmp+'s13'+'.sav'
                endcase
 	        xdr_image=rotate(xdr_image,3)
	        xdr_lat=reverse(xdr_lat,1)
	        xdr_lon=reverse(xdr_lon,1)
	        print, 'Saving file: ' + xdrfile
	        save,xdr_image,xdr_lat,xdr_lon,filename=xdrfile,/xdr,/compress
	        ENDCASE

	  1265: begin			;yyyymmdd
		case i of
              	0:xdrfile=xdrfile_tmp+'wici.sav'
              	1:xdrfile=xdrfile_tmp+'s12i.sav'
              	2:xdrfile=xdrfile_tmp+'s13i.sav'
                endcase
	        print, 'Saving file: ' + xdrfile
	        info_save=imageinfo	;very important
	        fuv_rt_rotations		;new 7-2-01 TJI 
	        imageinfo=imageinfo[i]
 	        if (active_inst ge 1) then begin	
	           downshift		;load siinfo array	
	           imageinfo=siinfo(active_inst)
	           endif
	        save,imageinfo,filename=xdrfile,/xdr
	        imageinfo=info_save
	        info_save=0
	        ENDCASE

	  1266: begin			;yyyymmdd
		case i of
              	0:xdrfile=xdrfile_tmp+'wici.sav'
              	1:xdrfile=xdrfile_tmp+'s12i.sav'
              	2:xdrfile=xdrfile_tmp+'s13i.sav'
                endcase
	        print, 'Saving file: ' + xdrfile
	        info_save=imageinfo	;very important
	        fuv_rt_rotations		;new 7-2-01 TJI 
	        imageinfo=imageinfo[i]
 	        if (active_inst ge 1) then begin	
	           downshift		;load siinfo array	
	           imageinfo=siinfo(active_inst)
	           endif
	        save,imageinfo,filename=xdrfile,/xdr,/compress
	        imageinfo=info_save
	        info_save=0
	        ENDCASE

	  1270: begin			;yyyyddd
		create_filename,i,imageinfo(i).time,xdrfile
		xdr_file=GIFDIR + xdrfile
	        print, 'Saving file: ' + xdr_file
	        info_save=imageinfo	;very important
	        fuv_rt_rotations		;new 7-2-01 TJI 
	        imageinfo=imageinfo[i]
 	        if (active_inst ge 1) then begin	
	          downshift		;load siinfo array	
	          imageinfo=siinfo(active_inst)
	          endif
	        save,imageinfo,filename=xdr_file,/xdr
	        imageinfo=info_save
	        info_save=0
	        ENDCASE
	        
	  1271: begin			;yyyyddd
		create_filename,i,imageinfo(i).time,xdrfile
		xdr_file=GIFDIR + xdrfile
	        print, 'Saving file: ' + xdr_file
	        info_save=imageinfo	;very important
	        fuv_rt_rotations		;new 7-2-01 TJI 
	        imageinfo=imageinfo[i]
 	        if (active_inst ge 1) then begin	
	          downshift		;load siinfo array	
	          imageinfo=siinfo(active_inst)
	          endif
	        save,imageinfo,filename=xdr_file,/xdr,/compress
	        imageinfo=info_save
	        info_save=0
	        ENDCASE
	        
	  1280: begin			;yyyyddd imageinfo and fast_data
		case i of
              	0:xdrfile=xdrfile_tmp+'wicf.sav'
              	1:xdrfile=xdrfile_tmp+'s12f.sav'
              	2:xdrfile=xdrfile_tmp+'s13f.sav'
                endcase
	        print, 'Saving file: ' + xdrfile
	        info_save=imageinfo	;very important
	        fuv_rt_rotations		;new 7-2-01 TJI 
	        imageinfo=imageinfo[i]
 	        if (active_inst ge 1) then begin	
	          downshift		;load siinfo array	
	          imageinfo=siinfo(active_inst)
	          fast_data.xarr=fast_data.xarr/2.
	          fast_data.yarr=fast_data.yarr/2.
	          endif
	        save,imageinfo,fast_data,filename=xdrfile,/xdr
	        imageinfo=info_save
	        info_save=0
	        ENDCASE
	        ENDCASE
	        
	 endif
	endfor
;
            stat_txt = 'XDR File Operation Completed -> ' + xdrfile
            WIDGET_CONTROL, status_id, set_value=stat_txt
    endif else begin

; Check if user wants to Cancel
       widget_control, stopevnt, sensitive = 1          ; Enable Stop
       runflag=1
       for j= 0,num_list-1 do begin
         getout=widget_event(stopevnt,/NOWAIT)
         if(runflag eq 0)then goto, stop_xdr
         current= recnum(listid(j))

         getplot,active_inst,current
         xdrfile_tmp=GIFDIR+tmpfile
  	  for i=0,2 do begin
   	    if (avail_inst(i) eq 1) then begin
	  CASE eventval of
          1230: begin
  		xdr_image=imageinfo(i).image
        	xdr_lat=imageinfo(i).glat
        	xdr_lon=imageinfo(i).glon
		dummy=where(xdr_lat lt -1.e10,count)
        	if (count gt 0) then xdr_lat[dummy]=!values.f_nan
        	dummy=where(xdr_lon lt -1.e10,count)
        	if (count gt 0) then xdr_lon[dummy]=!values.f_nan
        	case i of
		0:xdrfile=xdrfile_tmp+'wic'+'.sav'
		1:xdrfile=xdrfile_tmp+'s12'+'.sav'
		2:xdrfile=xdrfile_tmp+'s13'+'.sav'
       		endcase
		xdr_image=rotate(xdr_image,3)
		xdr_lat=reverse(xdr_lat,1)
		xdr_lon=reverse(xdr_lon,1)
	  	print, 'Saving file: ' + xdrfile
		save,xdr_image,xdr_lat,xdr_lon,filename=xdrfile,/xdr
		ENDCASE
          1232: begin
  		xdr_image=imageinfo(i).image
        	xdr_lat=imageinfo(i).glat
        	xdr_lon=imageinfo(i).glon
		dummy=where(xdr_lat lt -1.e10,count)
        	if (count gt 0) then xdr_lat[dummy]=!values.f_nan
        	dummy=where(xdr_lon lt -1.e10,count)
        	if (count gt 0) then xdr_lon[dummy]=!values.f_nan
        	case i of
		0:xdrfile=xdrfile_tmp+'wic'+'.sav'
		1:xdrfile=xdrfile_tmp+'s12'+'.sav'
		2:xdrfile=xdrfile_tmp+'s13'+'.sav'
       		endcase
		xdr_image=rotate(xdr_image,3)
		xdr_lat=reverse(xdr_lat,1)
		xdr_lon=reverse(xdr_lon,1)
	  	print, 'Saving file: ' + xdrfile
		save,xdr_image,xdr_lat,xdr_lon,filename=xdrfile,/xdr,/compress
		ENDCASE
	  1265: begin	;yyyymmdd
        	case i of
		  0:xdrfile=xdrfile_tmp+'wici'+'.sav'
		  1:xdrfile=xdrfile_tmp+'s12i'+'.sav'
		  2:xdrfile=xdrfile_tmp+'s13i'+'.sav'
       		endcase
	        print, 'Saving file: ' + xdrfile
	        info_save=imageinfo	;very important
	        fuv_rt_rotations		;new 7-2-01 TJI 
	        imageinfo=imageinfo[i]
 	        if (active_inst ge 1) then begin	
	           downshift		;load siinfo array	
	           imageinfo=siinfo(active_inst)
	           endif
	        save,imageinfo,filename=xdrfile,/xdr
	        imageinfo=info_save
	        info_save=0
	        ENDCASE

	  1266: begin	;yyyymmdd
        	case i of
		  0:xdrfile=xdrfile_tmp+'wici'+'.sav'
		  1:xdrfile=xdrfile_tmp+'s12i'+'.sav'
		  2:xdrfile=xdrfile_tmp+'s13i'+'.sav'
       		endcase
	        print, 'Saving file: ' + xdrfile
	        info_save=imageinfo	;very important
	        fuv_rt_rotations		;new 7-2-01 TJI 
	        imageinfo=imageinfo[i]
 	        if (active_inst ge 1) then begin	
	           downshift		;load siinfo array	
	           imageinfo=siinfo(active_inst)
	           endif
	        save,imageinfo,filename=xdrfile,/xdr,/compress
	        imageinfo=info_save
	        info_save=0
	        ENDCASE

	  1270: begin			;yyyyddd
		create_filename,i,imageinfo(i).time,xdrfile
		xdrfile=GIFDIR + xdrfile
	  	print, 'Saving file: ' + xdrfile
	        info_save=imageinfo	;very important
		fuv_rt_rotations	;NEW 7-2-01 TJI
	        imageinfo=imageinfo[i]
 	        if (active_inst eq 1 or active_inst eq 2) then begin	
	          downshift		;load siinfo array	
	          imageinfo=siinfo(active_inst)
 	        endif
	        save,imageinfo,filename=xdrfile,/xdr
	        imageinfo=info_save
	        info_save=0
		ENDCASE

	  1271: begin			;yyyyddd
		create_filename,i,imageinfo(i).time,xdrfile
		xdrfile=GIFDIR + xdrfile
	  	print, 'Saving file: ' + xdrfile
	        info_save=imageinfo	;very important
		fuv_rt_rotations	;NEW 7-2-01 TJI
	        imageinfo=imageinfo[i]
 	        if (active_inst eq 1 or active_inst eq 2) then begin	
	          downshift		;load siinfo array	
	          imageinfo=siinfo(active_inst)
 	        endif
	        save,imageinfo,filename=xdrfile,/xdr,/compress
	        imageinfo=info_save
	        info_save=0
		ENDCASE

	  1280: begin			;yyyyddd imageinfo and fast_data
		case i of
              	0:xdrfile=xdrfile_tmp+'wicf.sav'
              	1:xdrfile=xdrfile_tmp+'s12f.sav'
              	2:xdrfile=xdrfile_tmp+'s13f.sav'
                endcase
	        print, 'Saving file: ' + xdrfile
	        info_save=imageinfo	;very important
	        fuv_rt_rotations		;new 7-2-01 TJI 
	        imageinfo=imageinfo[i]
 	        if (active_inst ge 1) then begin	
	          downshift		;load siinfo array	
	          imageinfo=siinfo(active_inst)
	          fast_data.xarr=fast_data.xarr/2.
	          fast_data.yarr=fast_data.yarr/2.
	          endif
	        save,imageinfo,fast_data,filename=xdrfile,/xdr
	        imageinfo=info_save
	        info_save=0
	        ENDCASE
	        ENDCASE
	  
            endif
          endfor
             stat_txt = 'XDR File Operation Completed -> ' + xdrfile
             WIDGET_CONTROL, status_id, set_value=stat_txt
       endfor
       runflag=0
    endelse
;
stop_xdr:
    widget_control, stopevnt, sensitive = 0
    widget_control, pausevnt, sensitive = 0
    widget_control, backward_all, sensitive = 1
    widget_control, nextall, sensitive = 1
    widget_control, next, sensitive = 1
    widget_control, prevkey, sensitive = 1
;
	xdr_flag=0
    if (eventval eq 1280) then begin
       fast_flag=0
       fast_answer=''
       endif
 end
;
;=================================================================
;
; Create XDR button click event procedure
pro btnCreateMagXDR_Click, event
@fuv_cmnblk

;
;; Write XDR
;    num_list = N_ElEMENTS(listid)
    gifreslt =  dialog_pickfile(/DIR, PATH=GIFDIR, GET_PATH=GIFDIRT, TITLE='Select directory for XDR file(s).')
    ; If Cancel selected
    if (gifreslt eq '') then return
; fix UNIX dialog_pickfile under IDL 6.0
        if (gifdirt ne '') then begin
           numb1=strpos(gifdirt,'/.')
           if (numb1 ne -1) then begin
             numb2=strlen(gifdirt)
             gifdir=strmid(gifdirt,0,numb1)+strmid(gifdirt,numb1+2,numb2-numb1-2)
             endif else gifdir=gifdirt
  	   endif
;
; Default item ( first one in the list)
    widget_control, stopevnt, sensitive = 0          ; Disable Stop
    widget_control, pausevnt, sensitive = 0          ; Disable Pause
    widget_control, backward_all, sensitive = 0      ; Disable Play back
    widget_control, nextall, sensitive = 0           ; Disable Play next
    widget_control, next, sensitive = 0              ; Disable next
    widget_control, prevkey, sensitive = 0           ; Disable previous
;
    widget_control, /HOURGLASS
	xdr_flag=1
    if(num_list eq 0) then  begin
            stat_txt = 'Loading  Image . '
            WIDGET_CONTROL,status_id, set_value=stat_txt
            getplot,active_inst,current
            xdrfile_tmp=GIFDIR+tmpfile
  	for i=0,2 do begin
   	  if (avail_inst(i) eq 1) then begin
              mlt_image=imageinfo(i).mlt_img
              mlt_lat=imageinfo(i).mlat
              mlt_lon=imageinfo(i).mlt
              dummy=where(mlt_lat lt -1.e10,count)
              if (count gt 0) then mlt_lat[dummy]=!values.f_nan
              dummy=where(mlt_lon lt -1.e10,count)
              if (count gt 0) then mlt_lon[dummy]=!values.f_nan
              case i of
              	0:xdrfile=xdrfile_tmp+'wic'+'mag.sav'
              	1:xdrfile=xdrfile_tmp+'s12'+'mag.sav'
              	2:xdrfile=xdrfile_tmp+'s13'+'mag.sav'
              endcase
	  print, 'Saving file: ' + xdrfile
	  save,mlt_image,mlt_lat,mlt_lon,filename=xdrfile,/xdr
	 endif
	endfor
;
            stat_txt = 'XDR File Operation Completed -> ' + xdrfile
            WIDGET_CONTROL, status_id, set_value=stat_txt
    endif else begin

; Check if user wants to Cancel
       widget_control, stopevnt, sensitive = 1          ; Enable Stop
       runflag=1
       for j= 0,num_list-1 do begin
         getout=widget_event(stopevnt,/NOWAIT)
         if(runflag eq 0)then goto, stop_xdr
         current= recnum(listid(j))

         getplot,active_inst,current
         xdrfile_tmp=GIFDIR+tmpfile
  	  for i=0,2 do begin
   	   if (avail_inst(i) eq 1) then begin
  		mlt_image=imageinfo(i).mlt_img
        	mlt_lat=imageinfo(i).mlat
        	mlt_lon=imageinfo(i).mlt
		dummy=where(mlt_lat lt -1.e10,count)
        	if (count gt 0) then mlt_lat[dummy]=!values.f_nan
        	dummy=where(mlt_lon lt -1.e10,count)
        	if (count gt 0) then mlt_lon[dummy]=!values.f_nan
        	case i of
		0:xdrfile=xdrfile_tmp+'wic'+'mag.sav'
		1:xdrfile=xdrfile_tmp+'s12'+'mag.sav'
		2:xdrfile=xdrfile_tmp+'s13'+'mag.sav'
       		endcase
	  	print, 'Saving file: ' + xdrfile
		save,mlt_image,mlt_lat,mlt_lon,filename=xdrfile,/xdr
                endif
              endfor
             stat_txt = 'XDR File Operation Completed -> ' + xdrfile
             WIDGET_CONTROL, status_id, set_value=stat_txt
         endfor
      runflag=0
    endelse
;
stop_xdr:
    widget_control, stopevnt, sensitive = 0
    widget_control, pausevnt, sensitive = 0
    widget_control, backward_all, sensitive = 1
    widget_control, nextall, sensitive = 1
    widget_control, next, sensitive = 1
    widget_control, prevkey, sensitive = 1
;
xdr_flag=0
 end

;=================================================================
; Create Mac button click event procedure
pro btnCreateMac_Click, event
@fuv_cmnblk

;
;
;; Write Mac
    num_list = N_ElEMENTS(listid)
    gifreslt =  dialog_pickfile(/DIR, PATH=GIFDIR, GET_PATH=GIFDIRT, TITLE='Select directory for XDR file(s).')
       if (gifreslt eq '') then return
; fix UNIX dialog_pickfile under IDL 6.0
        if (gifdirt ne '') then begin
           numb1=strpos(gifdirt,'/.')
           if (numb1 ne -1) then begin
             numb2=strlen(gifdirt)
             gifdir=strmid(gifdirt,0,numb1)+strmid(gifdirt,numb1+2,numb2-numb1-2)
             endif else gifdir=gifdirt
  	   endif
;
; Default item ( first one in the list)
    widget_control, stopevnt, sensitive = 0          ; Disable Stop
    widget_control, pausevnt, sensitive = 0          ; Disable Pause
    widget_control, backward_all, sensitive = 0      ; Disable Play back
    widget_control, nextall, sensitive = 0           ; Disable Play next
    widget_control, next, sensitive = 0              ; Disable next
    widget_control, prevkey, sensitive = 0           ; Disable previous
;

    widget_control, /HOURGLASS
	xdr_flag=1
    if(num_list eq 0) then  begin
            stat_txt = 'Loadig  Image . '
            WIDGET_CONTROL,status_id, set_value=stat_txt
            getplot,active_inst,current
            xdrfile_tmp=GIFDIR+'/'+tmpfile
  	for i=0,2 do begin
   	 if (avail_inst(i) eq 1) then begin
              xdr_lat=reverse(imageinfo(i).glat,1)
              xdr_lon=reverse(imageinfo(i).glon,1)
              case i of
              	0:begin
	          image=rotate(imageinfo[i].image,3)
              	  result_bild=bytarr(512,256)
              	  macfile=xdrfile_tmp+'wic'+'.grd'
    	          for i=0,510,2 do result_bild[i:i+1,*]= $
  	            [image[i/2,*]-(long(image[i/2,*])/2L^8)*2l^8,byte(image[i/2,*]/2L^8)]
              	  endcase
              	1:begin
	          image=rotate(congrid(imageinfo[i].image,128,128),3)
              	  result_bild=bytarr(256,128)
              	  macfile=xdrfile_tmp+'s12'+'.grd'
		  for i=0,254,2 do result_bild[i:i+1,*]= $
  	  	    [byte(image[i/2,*]/2L^8),image[i/2,*]-(long(image[i/2,*])/2L^8)*2l^8]
              	  endcase
              	2:begin
	          image=rotate(congrid(imageinfo[i].image,128,128),3)
              	  result_bild=bytarr(256,128)
              	  macfile=xdrfile_tmp+'s13'+'.grd'
		  for i=0,254,2 do result_bild[i:i+1,*]= $
  	  	    [byte(image[i/2,*]/2L^8),image[i/2,*]-(long(image[i/2,*])/2L^8)*2l^8]
              	  endcase
              endcase
	 ss=size(image)
	 set_plot,'z'
	 device,set_resolution=[ss[1],ss[2]]
         PLOT,[0,0],[0.0],/NODATA,XRANGE=[0,ss[1]-1],YRANGE=[0,ss[2]-1], $
           POSITION=[0,0,ss[1]-1,ss[2]-1],XSTYLE=13,YSTYLE=13, BACKGROUND=0
         t_lat = CONGRID(xdr_lat, ss[1], ss[2], /INTERP)	 
         t_lon = CONGRID(xdr_lon, ss[1], ss[2], /INTERP)
         lat_lev=findgen(13)*15.-90.
         lon_lev=findgen(8)*45.
         contour,t_lat,levels=lat_lev,color=255,/overplot	 
         contour,t_lon,levels=lon_lev,color=255,/overplot
         grid_image=byte(tvrd())
         set_plot,'x'	 
         openw,unit,macfile,/get_lun
         writeu,unit,result_bild,grid_image
         free_lun,unit 
	 endif
	endfor
;
;
            stat_txt = 'Mac File Operation Completed -> ' + macfile
            WIDGET_CONTROL, status_id, set_value=stat_txt
    endif else begin

; Check if user wants to Cancel
       widget_control, stopevnt, sensitive = 1          ; Enable Stop
       runflag=1
       for j= 0,num_list-1 do begin
         getout=widget_event(stopevnt,/NOWAIT)
         if(runflag eq 0)then goto, stop_xdr
         current= recnum(listid(j))

         getplot,active_inst,current
         xdrfile_tmp=GIFDIR+'/'+tmpfile
  	  for i=0,2 do begin
   	   if (avail_inst(i) eq 1) then begin
        	xdr_lat=reverse(imageinfo(i).glat,1)
        	xdr_lon=reverse(imageinfo(i).glon,1)
              case i of
              	0:begin
	          image=rotate(imageinfo[i].image,3)
              	  result_bild=bytarr(512,256)
              	  macfile=xdrfile_tmp+'wic'+'.grd'
    	          for i=0,510,2 do result_bild[i:i+1,*]= $
  	            [image[i/2,*]-(long(image[i/2,*])/2L^8)*2l^8,byte(image[i/2,*]/2L^8)]
              	  endcase
              	1:begin
	          image=rotate(congrid(imageinfo[i].image,128,128),3)
              	  result_bild=bytarr(256,128)
              	  macfile=xdrfile_tmp+'s12'+'.grd'
		  for i=0,254,2 do result_bild[i:i+1,*]= $
  	  	    [byte(image[i/2,*]/2L^8),image[i/2,*]-(long(image[i/2,*])/2L^8)*2l^8]
              	  endcase
              	2:begin
	          image=rotate(congrid(imageinfo[i].image,128,128),3)
              	  result_bild=bytarr(256,128)
              	  macfile=xdrfile_tmp+'s13'+'.grd'
		  for i=0,254,2 do result_bild[i:i+1,*]= $
  	  	    [byte(image[i/2,*]/2L^8),image[i/2,*]-(long(image[i/2,*])/2L^8)*2l^8]
              	  endcase
                endcase
	      ss=size(image)
	      set_plot,'z'
	      device,set_resolution=[ss[1],ss[2]]
              PLOT,[0,0],[0.0],/NODATA,XRANGE=[0,ss[1]-1],YRANGE=[0,ss[2]-1], $
               POSITION=[0,0,ss[1]-1,ss[2]-1],XSTYLE=13,YSTYLE=13, BACKGROUND=0
              t_lat = CONGRID(xdr_lat, ss[1], ss[2], /INTERP)	 
              t_lon = CONGRID(xdr_lon, ss[1], ss[2], /INTERP)
              lat_lev=findgen(13)*15.-90.
              lon_lev=findgen(8)*45.
              contour,t_lat,levels=lat_lev,color=255,/overplot	 
              contour,t_lon,levels=lon_lev,color=255,/overplot
              grid_image=byte(tvrd())
              set_plot,'x'	 
              openw,unit,macfile,/get_lun
              writeu,unit,result_bild,grid_image
              free_lun,unit 
                endif
              endfor
             stat_txt = 'Mac File Operation Completed -> ' + macfile
             WIDGET_CONTROL, status_id, set_value=stat_txt
         endfor
      runflag=0
    endelse
;
stop_xdr:
    widget_control, stopevnt, sensitive = 0
    widget_control, pausevnt, sensitive = 0
    widget_control, backward_all, sensitive = 1
    widget_control, nextall, sensitive = 1
    widget_control, next, sensitive = 1
    widget_control, prevkey, sensitive = 1
;
	xdr_flag=0
 end
;==================================================================
; Create Mac button click event procedure
pro btnCreateMac_special_Click, event
@fuv_cmnblk

;
;
;; Write Mac
    num_list = N_ElEMENTS(listid)
    gifreslt =  dialog_pickfile(/DIR, PATH=GIFDIR, GET_PATH=GIFDIRT, TITLE='Select directory for XDR file(s).')
       if (gifreslt eq '') then return
; fix UNIX dialog_pickfile under IDL 6.0
        if (gifdirt ne '') then begin
           numb1=strpos(gifdirt,'/.')
           if (numb1 ne -1) then begin
             numb2=strlen(gifdirt)
             gifdir=strmid(gifdirt,0,numb1)+strmid(gifdirt,numb1+2,numb2-numb1-2)
             endif else gifdir=gifdirt
  	   endif
;
; Default item ( first one in the list)
    widget_control, stopevnt, sensitive = 0          ; Disable Stop
    widget_control, pausevnt, sensitive = 0          ; Disable Pause
    widget_control, backward_all, sensitive = 0      ; Disable Play back
    widget_control, nextall, sensitive = 0           ; Disable Play next
    widget_control, next, sensitive = 0              ; Disable next
    widget_control, prevkey, sensitive = 0           ; Disable previous
;
    CASE active_inst of
    0: begin
    	mac_max=12000
    	mac_grid=200
    	endcase
    1: begin
    	mac_max=50
    	mac_grid=200
    	endcase
    2: begin
    	mac_max=50
    	mac_grid=200
    	endcase
    endcase
    usrBase=WIDGET_BASE(COLUMN=1,TITLE='Select Default Settings')
    imgID=CW_FIELD(usrBase,TITLE='Image value scaled to 255:',VALUE=mac_max $
                       ,/INTEGER,/RETURN_EVENTS)
    bkgID=CW_FIELD(usrBase,TITLE='      Byte value for grid:',VALUE=mac_grid $
                      ,/INTEGER,/RETURN_EVENTS)

    WIDGET_CONTROL,usrBase,/REALIZE
    uevent=WIDGET_EVENT(usrBase) 

    WIDGET_CONTROL, imgID, GET_VALUE=img_value
    WIDGET_CONTROL, bkgID, GET_VALUE=grid_value
    WIDGET_CONTROL, usrBase, /DESTROY

;
    widget_control, /HOURGLASS
	xdr_flag=1
    if(num_list eq 0) then  begin
            stat_txt = 'Loadig  Image . '
            WIDGET_CONTROL,status_id, set_value=stat_txt
            getplot,active_inst,current
            xdrfile_tmp=GIFDIR+'/'+tmpfile
  	for i=0,2 do begin
   	 if (avail_inst(i) eq 1) then begin
              xdr_lat=reverse(imageinfo(i).glat,1)
              xdr_lon=reverse(imageinfo(i).glon,1)
              case i of
              	0:begin
	          image=bytscl(rotate(imageinfo[i].image,3),max=img_value)
              	  macfile=xdrfile_tmp+'wic'+'.sc_grd'
              	  endcase
              	1:begin
	          image=bytscl(congrid(rotate(imageinfo[i].image,3),128,128),max=img_value)
              	  macfile=xdrfile_tmp+'s12'+'.sc_grd'
              	  endcase
              	2:begin
	          image=bytscl(congrid(rotate(imageinfo[i].image,3),128,128),max=img_value)
              	  macfile=xdrfile_tmp+'s13'+'.sc_grd'
              	  endcase
              endcase
	 ss=size(image)
	 set_plot,'z'
	 device,set_resolution=[ss[1],ss[2]]
         PLOT,[0,0],[0.0],/NODATA,XRANGE=[0,ss[1]-1],YRANGE=[0,ss[2]-1], $
           POSITION=[0,0,ss[1]-1,ss[2]-1],XSTYLE=13,YSTYLE=13, BACKGROUND=0
         t_lat = CONGRID(xdr_lat, ss[1], ss[2], /INTERP)	 
         t_lon = CONGRID(xdr_lon, ss[1], ss[2], /INTERP)
         lat_lev=findgen(13)*15.-90.
         lon_lev=findgen(8)*45.
         contour,t_lat,levels=lat_lev,color=grid_value,/overplot	 
         contour,t_lon,levels=lon_lev,color=grid_value,/overplot
         grid_image=tvrd()
         result_bild=image
         result_bild[where(grid_image eq grid_value)]=grid_value
         set_plot,'x'	 
         openw,unit,macfile,/get_lun
         writeu,unit,result_bild
         free_lun,unit
	 endif
	endfor
;
            stat_txt = 'Mac File Operation Completed -> ' + macfile
            WIDGET_CONTROL, status_id, set_value=stat_txt
    endif else begin

; Check if user wants to Cancel
       widget_control, stopevnt, sensitive = 1          ; Enable Stop
       runflag=1
       for j= 0,num_list-1 do begin
         getout=widget_event(stopevnt,/NOWAIT)
         if(runflag eq 0)then goto, stop_xdr
         current= recnum(listid(j))

         getplot,active_inst,current
         xdrfile_tmp=GIFDIR+'/'+tmpfile
  	  for i=0,2 do begin
   	   if (avail_inst(i) eq 1) then begin
        	xdr_lat=reverse(imageinfo(i).glat,1)
        	xdr_lon=reverse(imageinfo(i).glon,1)
              case i of
              	0:begin
              	  macfile=xdrfile_tmp+'wic'+'.sc_grd'
	          image=bytscl(rotate(imageinfo[i].image,3),max=img_value)
              	  endcase
              	1:begin
              	  macfile=xdrfile_tmp+'s12'+'.sc_grd'
	          image=bytscl(congrid(rotate(imageinfo[i].image,3),128,128),max=img_value)
              	  endcase
              	2:begin
              	  macfile=xdrfile_tmp+'s13'+'.sc_grd'
	          image=bytscl(congrid(rotate(imageinfo[i].image,3),128,128),max=img_value)
              	  endcase
                endcase
	      ss=size(image)
	      set_plot,'z'
	      device,set_resolution=[ss[1],ss[2]]
              PLOT,[0,0],[0.0],/NODATA,XRANGE=[0,ss[1]-1],YRANGE=[0,ss[2]-1], $
               POSITION=[0,0,ss[1]-1,ss[2]-1],XSTYLE=13,YSTYLE=13, BACKGROUND=0
              t_lat = CONGRID(xdr_lat, ss[1], ss[2], /INTERP)	 
              t_lon = CONGRID(xdr_lon, ss[1], ss[2], /INTERP)
              lat_lev=findgen(13)*15.-90.
              lon_lev=findgen(8)*45.
              contour,t_lat,levels=lat_lev,color=grid_value,/overplot	 
              contour,t_lon,levels=lon_lev,color=grid_value,/overplot
              grid_image=tvrd()
         	result_bild=image
         	result_bild[where(grid_image eq grid_value)]=grid_value
              set_plot,'x'	 
              openw,unit,macfile,/get_lun
              writeu,unit,result_bild
              free_lun,unit
                endif
              endfor
             stat_txt = 'Mac File Operation Completed -> ' + macfile
             WIDGET_CONTROL, status_id, set_value=stat_txt
         endfor
      runflag=0
    endelse
;
stop_xdr:
    widget_control, stopevnt, sensitive = 0
    widget_control, pausevnt, sensitive = 0
    widget_control, backward_all, sensitive = 1
    widget_control, nextall, sensitive = 1
    widget_control, next, sensitive = 1
    widget_control, prevkey, sensitive = 1
;
	xdr_flag=0
 end


;==================================================================
; Create MPEG button click event procedure
pro btnCreateMpeg_Click, event
  make_movie
end

; Event
; Exit button click event
pro btnExit_Click, event
    WIDGET_CONTROL, /DESTROY,event.top
end

; Help GifWalk button click event
pro btnHelpFUView_Click, event
@fuv_cmnblk
;
    XDISPLAYFILE, FILE_PATH+Dir_sep+'help.pro', title = 'FUView Help Menu'
end

;
;; Event to open FUV set files
 pro btnOpen_file, event

@fuv_cmnblk
;
	widget_control,event.id,get_uvalue = eventval
	case eventval of
	1110: filetype_flag=1	; cdf
	11110: filetype_flag=20	; udf WIC
	11111: filetype_flag=21	; udf WIC
	11112: filetype_flag=22	; udf WIC
	11113: filetype_flag=23	; udf WIC
	11114: filetype_flag=24	; udf WIC
	11115: filetype_flag=25	; udf WIC
	11116: filetype_flag=26	; udf WIC
	11117: filetype_flag=27	; udf WIC
	11118: filetype_flag=28	; udf WIC
	11120: filetype_flag=30	; udf SI12
	11121: filetype_flag=31	; udf SI12
	11122: filetype_flag=32	; udf SI12
	11123: filetype_flag=33	; udf SI12
	11124: filetype_flag=34	; udf SI12
	11125: filetype_flag=35	; udf SI12
	11126: filetype_flag=36	; udf SI12
	11127: filetype_flag=37	; udf SI12
	11128: filetype_flag=38	; udf SI12
	11130: filetype_flag=40	; udf SI13
	11131: filetype_flag=41	; udf SI13
	11132: filetype_flag=42	; udf SI13
	11133: filetype_flag=43	; udf SI13
	11134: filetype_flag=44	; udf SI13
	11135: filetype_flag=45	; udf SI13
	11136: filetype_flag=46	; udf SI13
	11137: filetype_flag=47	; udf SI13
	11138: filetype_flag=48	; udf SI13
	endcase
     ret_err=0
     file_op=''

     getfile, ret_err,active_inst,id,maxrecord,file_op,filetype_flag
     if (ret_err eq 1) then return
     widget_control, /HOURGLASS
     selected_inst[*] = 0
     avail_inst[*]=0
     selected_inst(active_inst)=1
     L1DIRFILE(active_inst)=file_op
	; here we destinguish between udf and cdf
   case filetype_flag of
    1: begin						; cdf-file
     cdf_id(active_inst)=id
     maxrec(active_inst)=maxrecord
     print,' Level 1 File =',L1DIRFILE(active_inst)
;
     open_files,active_inst, ret_err, /GEN_LIST
     if (ret_err eq 0) then begin
      current = 0
      prevrec = 0
      num_list=1
      nextnum=0
      widget_control, both_coor, sensitive=1
      if (multi_inst gt 1) then begin
       multi_inst=1
       change_size
;      endif else getplot,active_inst,current
	  endif else begin
          stat_txt = 'Processing Plot...'
          WIDGET_CONTROL,status_id, set_value=stat_txt
          captured_img = display_img(active_inst,current)
          stat_txt = ' '
          WIDGET_CONTROL,status_id, set_value=stat_txt
	  endelse
      widget_control, datawid, set_list_select = 1
      widget_control, datawid, set_list_select = current
 	  widget_control, mnuout, sensitive=1          ; enable output menu option
;
     endif else begin
      stat_txt='Error during read.... File'+L1DIRFILE(active_inst)
      widget_control,status_id,set_value=stat_txt
      current=-1
      prevrec=-1
      selected_inst[*] = 0
      avail_inst[*]=0
     endelse
     catch, error_status
     endcase
    2: begin						; udf-file

       cdf_id(active_inst)=id
       print,' Level 1 File =',L1DIRFILE(active_inst)
;
;Make sure search text is compatable in all platforms supported
;
	   search_txt=Dir_sep+'IMF'
       inst_pos=strpos(file_op,search_txt)+3
       first_year=strpos(file_op,'19',inst_pos)		; 1999
  	   ; I know that I here produce a Y21H bug, because the whole thing
  	   ; does not work after the year 2099
  	   ; hopefully nobody will use UDF at that time anymore
       second_year=strpos(file_op,'20',inst_pos)	; 2000 and later
       if (first_year eq -1) then first_year=100000l
       if (second_year eq -1) then second_year=100000l
       laenge=min([first_year,second_year])
;       ImageInfo.src = strmid(file_op,inst_pos+1,laenge-inst_pos-1)	; 1 because /

;---  added by TJI  3-22-2001 ---;

;	imageinfo.src=strmid(imageinfo.src,0,4)

;---  this standardizes the structure string to 4 characters ---;

	; this part is for all non-real-time files
	; reading twice is still faster than everything
	tnm=strmid(file_op,inst_pos+9,laenge-inst_pos-2)
       return_value=fuv_read_udf(file=file_op,/inventory)
       if (n_elements(return_value) gt 730) then return_value=return_value[0:729]       
       maxrec(active_inst)=n_elements(return_value)

       fuv_mission_correction,return_value[0].btime.year,return_value[0].btime.doy,correction_value
       if (correction_value[0] eq 1. and correction_value[1] eq 1. and correction_value[2] eq 1.) then begin
           calibration_flag=0
           WIDGET_CONTROL,SET_VALUE=calibration_flag,calib_id
       	   result=dialog_message('Only raw counts possible for this day')
           endif

		; updated messages about pointing
       case 1 of
       (return_value[0].btime.year eq 2000 and return_value[0].btime.doy lt 157): begin
       		result=dialog_message('Warning! Pointing unreliable for this day')
       		endcase
       (return_value[0].btime.year eq 2001 and return_value[0].btime.doy ge 159 and return_value[0].btime.doy lt 233): $
        	  result=dialog_message('Warning! Pointing unreliable for this day! Summer vacation of star tracker!')
       (return_value[0].btime.year eq 2002 and return_value[0].btime.doy ge 142 and return_value[0].btime.doy lt 234): $
        	  result=dialog_message('Warning! Pointing unreliable for this day! Summer vacation of star tracker!')
       (return_value[0].btime.year eq 2003 and return_value[0].btime.doy ge 160 and return_value[0].btime.doy lt 228): $
        	  result=dialog_message('Warning! Pointing unreliable for this day! Summer vacation of star tracker!')
       (return_value[0].btime.year eq 2004 and return_value[0].btime.doy ge 162 and return_value[0].btime.doy lt 243): $
        	  result=dialog_message('Warning! Pointing unreliable for this day! Summer vacation of star tracker!')
       (return_value[0].btime.year eq 2005 and return_value[0].btime.doy ge 165 and return_value[0].btime.doy lt 238): $
        	  result=dialog_message('Warning! Pointing unreliable for this day! Summer vacation of star tracker!')
       ELSE: ok=1
       endcase

;       altitude_array=fuv_read_udf(file=file_op,variable='RADIUS')
;       altitudes=reform(altitude_array[0,*]/6372.)
	altitudes=fltarr(n_elements(return_value))+3.
       open_files,active_inst, ret_err, /GEN_LIST,udf_times=return_value	;current is not set yet,
										;TJI software depends on 
										;;current!!!

       if (ret_err eq 0) then begin
         current = 0
         prevrec = 0
         num_list=1
         nextnum=0
         widget_control, both_coor, sensitive=1
         if (multi_inst gt 1) then begin
           multi_inst=1
           change_size
;         endif else getplot,active_inst,current
	     endif else begin
          stat_txt = 'Processing Plot...'
          WIDGET_CONTROL,status_id, set_value=stat_txt
          captured_img = display_img(active_inst,current)
          stat_txt = ' '
          WIDGET_CONTROL,status_id, set_value=stat_txt
	     endelse
         widget_control, datawid, set_list_select = 1
         widget_control, datawid, set_list_select = current
 		 widget_control, mnuout, sensitive=1          ; enable output menu option
;
       endif else begin
         stat_txt='Error during read.... File'+L1DIRFILE(active_inst)
         widget_control,status_id,set_value=stat_txt
         current=-1
         prevrec=-1
         selected_inst[*] = 0
         avail_inst[*]=0
       endelse
     catch, error_status
     endcase
    ELSE: begin
       stat_txt='Error during read.... File'+L1DIRFILE(active_inst)
       return
       endcase
    endcase
end
;
;
;; Event to open FUV set files
 pro btnOpen_set, event
;
@fuv_cmnblk
;
     WIDGET_CONTROL,event.id,GET_UVALUE=eventval

     nfile = strarr(5)
     active_inst=0
     ret_err = 0
     if (eventval ne 8) then getudfdir,/nselect,ret_err,wic_ret,s12_ret,s13_ret,eventval else begin
        getudfdir,/nselect,ret_err,wic_ret,s12_ret,s13_ret,eventval,starttime=fix([yeara,doya,houra,0]),$
        stoptime=fix([years,doys,hours])
        mlt_rdy=0
        selected_inst=[1,1,1]
        endelse
     if (ret_err eq 1) then return
;
     file_avail=0
     retval = 0
     crec=0

         ret_err=0
         if (selected_inst[0]) then $
         if (active_inst eq 0) then open_files,0,ret_err,udf_times=wic_ret, /GEN_LIST else $
           open_files,0,ret_err,udf_times=wic_ret
         if (avail_inst[0]) then file_avail=file_avail+1
         if (selected_inst[1]) then $
         if (active_inst eq 1) then open_files,1,ret_err,udf_times=s12_ret, /GEN_LIST else $
           open_files,1,ret_err,udf_times=s12_ret
         if (avail_inst[1]) then file_avail=file_avail+1
         if (selected_inst[2]) then $
         if (active_inst eq 2) then open_files,2,ret_err,udf_times=s13_ret, /GEN_LIST else $
           open_files,2,ret_err,udf_times=s13_ret
         if (avail_inst[2]) then file_avail=file_avail+1

;
     if (file_avail eq 0)then begin
      stat_txt = 'There are no files available or files are not valid in the selected directory, Try agin..'
      widget_control,status_id,set_value=stat_txt
      current=-1
      prevrec=-1
      selected_inst[*] = 0
      avail_inst[*]=0
      return
     endif
;

     if (avail_inst(active_inst) eq 0 ) then begin
      i=0
      while (avail_inst(i) eq 0) do i=i+1
      active_inst = i
      showstr,active_inst,ret_err
     endif

     current = 0
     prevrec = 0
     num_list=1
     nextnum=0
;
	 if (file_avail eq 1) then  widget_control, both_coor, sensitive=1 $
	 else begin
	  widget_control, both_coor, sensitive=0
	  if (cor eq 0) then cor =1
	 endelse
;
	 if (multi_inst ne file_avail) then begin
      multi_inst=file_avail
      change_size
;     endif else getplot,active_inst,current
	 endif else begin
          stat_txt = 'Processing Plot...'
          WIDGET_CONTROL,status_id, set_value=stat_txt
          captured_img = display_img(active_inst,current)
          stat_txt = ' '
          WIDGET_CONTROL,status_id, set_value=stat_txt
	 endelse
     widget_control, datawid, set_list_select = 1
     widget_control, datawid, set_list_select = current
 	 widget_control, mnuout, sensitive=1          ; enable output menu option
;
;
     catch, error_status
end

 ;; Previous Event ( < clicked on)

pro previous_event,event
;
@fuv_cmnblk
;
  widget_control, mnuout, sensitive = 1

  if(num_list eq 1)then begin
    if (current eq firstrec) then return
    current = recnum(current-1)
    widget_control, datawid, set_list_select = current, /HOURGLASS
    getplot,active_inst,current
  endif
  if(num_list gt 1)then begin
    if (nextnum gt 0) then begin
       widget_control, /HOURGLASS
       nextnum = nextnum -1
       current = recnum(listid(nextnum))
       getplot,active_inst,current
    endif
  endif
 end

;Event procedure for stop button
pro stop_event,event
  @fuv_cmnblk
  widget_control, mnuout, sensitive = 0    ; Make Gif and Movie option disable
  widget_control, stopevnt, sensitive=0        ;enable stop button  sept23-99
  widget_control, pausevnt, sensitive=0,set_value='Pause'        ;enable pause button  sept23-99
  widget_control, backward_all, sensitive=1    ;enable play backward button  sept23-99
  widget_control, nextall, sensitive=1         ;disable play forward button  sept23-99
  widget_control, next, sensitive=1            ;disable next button  sept23-99
  widget_control, prevkey, sensitive=1         ;disable previous button  sept23-99
  runflag = 0	;Clear the run flag
  resumeflag=0
  if (num_list gt 1) then begin
    backnum=nextnum
    gonum=nextnum
    makegif=0
  endif
end


;Event procedure for pause/resume button

pro pause_event,event
  @fuv_cmnblk
  widget_control, pausevnt, get_value=eventval
  if(eventval eq 'Pause') then begin
       widget_control, mnuout, sensitive =0      ; Make Gif and Movie option dis able
       widget_control, pausevnt, sensitive=1, set_value='Resume'
       resumeflag = 1
       runflag = 0	;Clear the run flag
  endif else begin      ;Button is resume
 ;     resumeflag =1
       runflag = 1	;set the run flag
       widget_control, pausevnt, set_value='Pause'
; Find out the state
       if(nextflag) then nextlist,/Play_fwd
       if(backflag) then nextlist,/Play_rev
;       widget_control, pausevnt, sensitive=0
  endelse

 end



;Event procedure for Play fwd button

pro Play_fwd_event,event
@fuv_cmnblk
  resumeflag = 0
  backflag  = 0
  nextflag = 1
  widget_control, mnuout, sensitive = 0
  nextlist,/Play_fwd
  widget_control, mnuout, sensitive = 1
 end


 ;; Next Event ( > Clicked on)

pro next_event,event

@fuv_cmnblk
  widget_control, mnuout, sensitive = 1

  if(num_list eq 1)then begin
    if (current eq lastrec) then return
    current = recnum(current+1)
    widget_control, datawid, set_list_select = current,/HOURGLASS
    getplot,active_inst,current
  endif

  if(num_list gt  1)then begin
    if (nextnum le num_list-2) then begin
       widget_control, /HOURGLASS
       nextnum=nextnum+1
       current = recnum(listid(nextnum))
       getplot,active_inst,current
    endif
  endif

 end

; Go Backward for selected list

pro Play_rev_event,event
@fuv_cmnblk
  resumeflag = 0
  backflag = 1
  nextflag = 0
  widget_control, mnuout, sensitive = 0

  nextlist,/Play_rev
  widget_control, mnuout, sensitive = 1
end
;
;
pro config_keo, event
;
@fuv_cmnblk

if (WIDGET_INFO(keodraw_id,/VALID_ID) eq 1) then $
 if (WIDGET_INFO(keodraw_id,/REALIZED)) then begin
  stat_txt= ' Keogram Plotting window is already active..'
  WIDGET_CONTROL,status_id, set_value=stat_txt
  return
 endif

if (WIDGET_INFO(keo_cfg_chi1,/VALID_ID) eq 1) then $
 if (WIDGET_INFO(keo_cfg_chi1,/REALIZED)) then begin
  stat_txt= ' Keogram Configuration window is already active..'
  WIDGET_CONTROL,status_id, set_value=stat_txt
  return
 endif
;
 result=DIALOG_MESSAGE('Are you sure the pointing is corrected?')
 widget_control,event.top,GET_UVALUE=info
 oldinfo=info
 oldwin=!d.window
 ;
 keo_dspl_opt=['Geographic','MLT','Mag-Lon','Along MLT']
 keo_lonmlt_txt=['Longitude (deg)','MLT (hour)       ','Mag. Lon. (deg)','MLT (hour)       ']
 keo_cfg_base=widget_base(/COLUMN,Title='Keogram Configuration',GROUP_LEADER=info.base,UVALUE=event.top)
 ;
 keo_cfg_chi1=widget_base(keo_cfg_base,/COLUMN,/ALIGN_CENTER)
 keo_geo_id=CW_BGROUP(keo_cfg_chi1,/ROW,UVALUE=1,/EXCLUSIVE,keo_dspl_opt,SET_VALUE=keo_mlt_flg)
 ;
 keo_cfg_chi2=WIDGET_BASE(Keo_cfg_base,/ROW,/ALIGN_LEFT,FRAME=5)
 keo_cfg_sib1=WIDGET_BASE(keo_cfg_chi2,/COLUMN)
 keo_cfg_sib2=WIDGET_BASE(keo_cfg_chi2,/COLUMN)

 keo_cfg_lonmlt_txt=WIDGET_LABEL(keo_cfg_sib1,VALUE=keo_lonmlt_txt[keo_mlt_flg])
 keo_cfg_lat_txt=WIDGET_LABEL(keo_cfg_sib2,VALUE='Latitude (deg)')

keo_cfg_sib1_1=WIDGET_BASE(keo_cfg_sib1,/COLUMN,FRAME=5)
keo_cfg_sib2_1=WIDGET_BASE(keo_cfg_sib2,/COLUMN,FRAME=5)
 ;

 if (keo_mlt_flg eq 0 or keo_mlt_flg eq 2) then begin
   minval=keo_lonmin
   maxval=keo_lonmax
   lonmlt_val=keo_lonres
 endif else begin
   minval=keo_mltmin
   maxval=keo_mltmax
   lonmlt_val=keo_mltres
 endelse
 keo_cfg_lonmlt_min=CW_FIELD(keo_cfg_sib1_1,UVALUE=2,TITLE='Minimum   : ',VALUE=minval,$
 						 xsize=8,/ROW,/FLOATING,/ALL_EVENTS)
 keo_cfg_lonmlt_max=CW_FIELD(keo_cfg_sib1_1,UVALUE=3,TITLE='Maximum  : ',VALUE=maxval,$
 						 xsize=8,/ROW,/FLOATING,/ALL_EVENTS)
 keo_cfg_lonmlt=CW_FIELD(keo_cfg_sib1_1,UVALUE=4,TITLE='Resolution:  ',VALUE=lonmlt_val,$
 						 xsize=8,/ROW,/FLOATING,/ALL_EVENTS)
;
 keo_cfg_latmin=CW_FIELD(keo_cfg_sib2_1,UVALUE=5,TITLE='Equator     : ',VALUE=keo_latmin,$
 						 xsize=8,/ROW,/FLOATING,/ALL_EVENTS)
 keo_cfg_latmax=CW_FIELD(keo_cfg_sib2_1,UVALUE=6,TITLE='Pole           : ',VALUE=keo_latmax,$
 						 xsize=8,/ROW,/FLOATING,/ALL_EVENTS)
 keo_cfg_latres=CW_FIELD(keo_cfg_sib2_1,UVALUE=7,TITLE='Resolution: ',VALUE=keo_latres,$
 						 xsize=8,/ROW,/FLOATING,/ALL_EVENTS)
;
 keo_cfg_chi2=WIDGET_BASE(keo_cfg_base,/COLUMN,/ALIGN_CENTER)
 keo_apply=widget_button(keo_cfg_chi2,UVALUE=8,VALUE='Apply',/ALIGN_CENTER)
 ;
 keo_cfg_err=WIDGET_LABEL(keo_cfg_base, value='', /DYNAMIC_RESIZE, /ALIGN_LEFT)
 ;
 widget_control,keo_cfg_chi1,/REALIZE

 xmanager,'keocfg',keo_cfg_base
end

pro keocfg_event, event
;
@fuv_cmnblk
;
WIDGET_CONTROL,event.id,GET_UVALUE=type

;
case type of
 1: begin
     WIDGET_CONTROL,GET_VALUE=tmp_mlt_flg,keo_geo_id
     if (tmp_mlt_flg eq 0 or tmp_mlt_flg eq 2) then begin
      WIDGET_CONTROL,SET_VALUE='Longitude (deg)',keo_cfg_lonmlt_txt
      WIDGET_CONTROL,SET_VALUE=keo_lonmin,keo_cfg_lonmlt_min
      WIDGET_CONTROL,SET_VALUE=keo_lonmax,keo_cfg_lonmlt_max
      WIDGET_CONTROL,SET_VALUE=keo_lonres,keo_cfg_lonmlt
      tmp_lonmlt_min=keo_lonmin
      tmp_lonmlt_max=keo_lonmax
      tmp_lonmlt=keo_lonres
     endif else begin
      WIDGET_CONTROL,SET_VALUE='MLT (hour)      ',keo_cfg_lonmlt_txt
      WIDGET_CONTROL,SET_VALUE=keo_mltmin,keo_cfg_lonmlt_min
      WIDGET_CONTROL,SET_VALUE=keo_mltmax,keo_cfg_lonmlt_max
      WIDGET_CONTROL,SET_VALUE=keo_mltres,keo_cfg_lonmlt
      tmp_lonmlt_min=keo_mltmin
      tmp_lonmlt_max=keo_mltmax
      tmp_lonmlt=keo_mltres
     endelse

    end
;
 2: begin
     WIDGET_CONTROL,GET_VALUE=tmp_lonmlt_min,keo_cfg_lonmlt_min
    end
;
 3: begin
     WIDGET_CONTROL,GET_VALUE=tmp_lonmlt_max,keo_cfg_lonmlt_max
    end
;
 4: begin
     WIDGET_CONTROL,GET_VALUE=tmp_lonmlt,keo_cfg_lonmlt
    end
;
 5: begin
     WIDGET_CONTROL,GET_VALUE=tmp_latmin,keo_cfg_latmin
    end
;
 6: begin
     WIDGET_CONTROL,GET_VALUE=tmp_latmax,keo_cfg_latmax
    end
;
 7: begin
     WIDGET_CONTROL,GET_VALUE=tmp_latres,keo_cfg_latres
    end
;
 8: begin
     err=-1
     if (tmp_lonmlt_min lt 0 or tmp_lonmlt_max lt 0) then err=0
;     if (tmp_lonmlt_min ge tmp_lonmlt_max) then err =1
;     if (tmp_lonmlt le 0 or tmp_lonmlt gt (tmp_lonmlt_max-tmp_lonmlt_min)) then err=2
     if (tmp_lonmlt le 0) then err=2
     if (tmp_lonmlt_max gt tmp_lonmlt_min and tmp_lonmlt/2. gt (tmp_lonmlt_max-tmp_lonmlt_min)) then err=2
     if (tmp_mlt_flg eq 0 or tmp_mlt_flg eq 2) then begin
       if (tmp_lonmlt_max lt tmp_lonmlt_min and tmp_lonmlt/2. gt (tmp_lonmlt_max+360.-tmp_lonmlt_min)) then err=2
       endif else if (tmp_lonmlt_max lt tmp_lonmlt_min and tmp_lonmlt/2. gt (tmp_lonmlt_max+24.-tmp_lonmlt_min)) then err=2
     if (tmp_mlt_flg eq 0 or tmp_mlt_flg eq 2) then begin
      if (tmp_lonmlt_min gt 360. or tmp_lonmlt_max gt 360. or tmp_lonmlt gt 360.) then err=0
     endif else if (tmp_lonmlt_min gt 24. or tmp_lonmlt_max gt 24. or tmp_lonmlt gt 24.) then err=0
     if (tmp_latmin lt -90. or tmp_latmin gt 90. or tmp_latmax lt -90. or tmp_latmax gt 90.) then err=0
     if (abs(tmp_latmin) ge abs(tmp_latmax)) then err =1
     if (tmp_latres le 0 or tmp_latres gt abs(tmp_latmax-tmp_latmin)) then err=2
     if (err eq -1) then begin
      keo_mlt_flg=tmp_mlt_flg
      if (keo_mlt_flg eq 0 or keo_mlt_flg eq 2) then begin
       keo_lonmin=tmp_lonmlt_min
       keo_lonmax=tmp_lonmlt_max
       keo_lonres=tmp_lonmlt
      endif else begin
       keo_mltmin=tmp_lonmlt_min
       keo_mltmax=tmp_lonmlt_max
       keo_mltres=tmp_lonmlt
      endelse
;
      keo_latmin=tmp_latmin
      keo_latmax=tmp_latmax
      keo_latres=tmp_latres
;
 	  WIDGET_CONTROL,keo_cfg_err,SET_VALUE=''
 	  WIDGET_CONTROL,/DESTROY,event.top
 	 endif else begin
 	  WIDGET_CONTROL,keo_cfg_err,SET_VALUE=keo_errmsg[err]
 	 endelse
;
    end
;
endcase
end
;
pro mouse_event, event
;
@fuv_cmnblk
instlist=intarr(3)
;
 if (event.type eq 0) then  begin
  x=event.x
  y=event.y
  y=y-y_limit_low
;
  txt = 0
  if (y ge 0 and y lt 256) then begin
;Make the image square
   xl=x_limit_low
   case cor of
    0:	begin
    	 if (x ge xl and x lt (xl+nxpix)) then begin
		    image = CONGRID(ImageInfo(active_inst).image,nxpix,nypix)
		    geolat = CONGRID(ImageInfo(active_inst).glat,nxpix,nypix)
		    geolon = CONGRID(ImageInfo(active_inst).glon,nxpix,nypix)
    	 	image_type='Geographic'
    	 	x=x-xl
    	 	xr=nxpix-1-y
    	 	yr=x
    	 	xp=nxpix-1-x
    	 	yp=y
    	 	txt=imageinfo(active_inst).inst_id+' '+image_type
    	 	txt=[txt,'X: '+STRTRIM(STRING(x),2)+'  Y: '+STRTRIM(STRING(y),2)+$
    	 			 '  Value: '+STRTRIM(STRING(Image(xr,yr),FORMAT='(F8.2)'),2)]
		lonew='E'
		lon_val=geolon(xp,yp)
		txt=[txt,'Geog. Lat: '+STRTRIM(STRING(geolat(xp,yp),FORMAT='(F8.2)'),2)+ $
		    '  Lon: '+STRTRIM(STRING(lon_val,FORMAT='(F8.2)'),2)+lonew]
;
			WIDGET_CONTROL,mousewin,SET_VALUE=txt
    	 endif else begin
    	  xl=xl+nxpix+(2*image_align)-1
    	  if (x ge xl and x lt (xl+nxpix)) then begin
    	 	image_type='MLT'
    	 	x=x-xl	;-1
;    	 	y=y-1
    	 	txt=imageinfo(active_inst).inst_id+' '+image_type
    	 	txt=[txt,'X: '+STRTRIM(STRING(x),2)+'  Y: '+STRTRIM(STRING(y),2)+$
    	 			 '  Value: '+STRTRIM(STRING(Imageinfo(active_inst).mlt_img(x,y),$
    	 			 FORMAT='(F8.2)'),2)]
    	 	xr=(x-(nxpix-1)/2)*((90.-latmin)/((nxpix-1)/2))
    	 	yr=(y-(nypix-1)/2)*((90.-latmin)/((nypix-1)/2))
    	 	maglat=(90.0-SQRT(xr*xr+yr*yr))*sphere
    	 	maglt=(ATAN(-xr,yr)/!DTOR + 180.)/15.
    	 	txt=[txt,'Magnetic Lat: '+STRTRIM(STRING(maglat,FORMAT='(F8.2)'),2)+ $
    	 	         '  MLT: '+STRTRIM(STRING(maglt,FORMAT='(F8.2)'),2)]
		    WIDGET_CONTROL,mousewin,SET_VALUE=txt
    	  endif
    	 endelse
    	end

    1:	begin
         i=0
         while(i lt 3 and (x lt xl or x ge (xl+nxpix)) ) do begin
          i=i+1
          xl=xl+nxpix+(2*image_align)-1
         endwhile
         k=0
         for j=0,2 do begin
   		  if (avail_inst(j) eq 1) then begin
   		   instlist[k]=j
   		   k=k+1
   		  endif
         endfor
         if (i lt 3) then begin
          i=instlist[i]
		  image = CONGRID(ImageInfo(i).image,nxpix,nypix)
		  geolat = CONGRID(ImageInfo(i).glat,nxpix,nypix)
		  geolon = CONGRID(ImageInfo(i).glon,nxpix,nypix)
          x=x-xl
    	  xr=nxpix-1-y
    	  yr=x
    	  txt=imageinfo(i).inst_id+' '+'Geographic'
    	  xp=nxpix-1-x
    	  yp=y
    	  txt=[txt,'X: '+STRTRIM(STRING(x),2)+'  Y: '+STRTRIM(STRING(y),2)+$
    	  		   '  Value: '+STRTRIM(STRING(Image(xr,yr),FORMAT='(F8.2)'),2)]
	  lonew='E'
	  lon_val=geolon(xp,yp)
          if (geolon(xp,yp) gt 180.0) then begin
             lonew='W'
             lon_val=360.-lon_val
          endif
		  txt=[txt,'Geographic Lat: '+STRTRIM(STRING(geolat(xp,yp),FORMAT='(F8.2)'),2)+ $
		      '  Lon: '+STRTRIM(STRING(lon_val,FORMAT='(F8.2)'),2)+lonew]
;
		  WIDGET_CONTROL,mousewin,SET_VALUE=txt
		 endif
    	end
    2:	begin
         i=0
         while(i lt 3 and (x lt xl or x ge (xl+nxpix)) ) do begin
          i=i+1
          xl=xl+nxpix+(2*image_align)-1
         endwhile
         k=0
         for j=0,2 do begin
   		  if (avail_inst(j) eq 1) then begin
   		   instlist[k]=j
   		   k=k+1
   		  endif
         endfor
         if (i lt 3) then begin
          i=instlist[i]
          x=x-xl	;-1
;          y=y-1
    	  txt=imageinfo(i).inst_id+' '+'MLT'
    	  txt=[txt,'X: '+STRTRIM(STRING(x),2)+'  Y: '+STRTRIM(STRING(y),2)+$
    	 		 '  Value: '+STRTRIM(STRING(Imageinfo(i).mlt_img(x,y),FORMAT='(F8.2)'),2)]
    	  xr=(x-(nxpix-1)/2)*((90.-latmin)/((nxpix-1)/2))
    	  yr=(y-(nypix-1)/2)*((90.-latmin)/((nypix-1)/2))
    	  maglat=(90.0-SQRT(xr*xr+yr*yr))*sphere
    	  maglt=(ATAN(-xr,yr)/!DTOR + 180.)/15.
    	  txt=[txt,'Magnetic Lat: '+STRTRIM(STRING(maglat,FORMAT='(F8.2)'),2)+ $
    	           '  MLT: '+STRTRIM(STRING(maglt,FORMAT='(F8.2)'),2)]
		  WIDGET_CONTROL,mousewin,SET_VALUE=txt
		 endif
    	end
   endcase
  endif
 endif
;
;
end
;---------------------------------------------------
pro time_period, event
;
@fuv_cmnblk

 time_dspl_opt=['WIC','SI-12','SI-13','Set']
 time_lonmlt_txt='Start time'
 time_cfg_base=widget_base(/COLUMN,Title='Time period selection',UVALUE=event.top)
 ;
 time_cfg_chi1=widget_base(time_cfg_base,/COLUMN,/ALIGN_CENTER)
 time_inst_id=CW_BGROUP(time_cfg_chi1,/ROW,UVALUE=1,/EXCLUSIVE,time_dspl_opt,SET_VALUE=active_inst)
 ;
 time_cfg_chi2=WIDGET_BASE(time_cfg_base,/ROW,/ALIGN_LEFT,FRAME=5)
 time_cfg_sib1=WIDGET_BASE(time_cfg_chi2,/COLUMN)
 time_cfg_sib2=WIDGET_BASE(time_cfg_chi2,/COLUMN)

 time_cfg_lonmlt_txt=WIDGET_LABEL(time_cfg_sib1,VALUE=time_lonmlt_txt)
 time_cfg_lat_txt=WIDGET_LABEL(time_cfg_sib2,VALUE='Stop time')

 time_cfg_sib1_1=WIDGET_BASE(time_cfg_sib1,/COLUMN,FRAME=5)
 time_cfg_sib2_1=WIDGET_BASE(time_cfg_sib2,/COLUMN,FRAME=5)
 ;
 time_yeara=CW_FIELD(time_cfg_sib1_1,UVALUE=2,TITLE='Year: ',VALUE=yeara,$
 						 xsize=8,/ROW,/ALL_EVENTS,/integer)
 time_doya=CW_FIELD(time_cfg_sib1_1,UVALUE=3,TITLE='DoY : ',VALUE=doya,$
 						 xsize=8,/ROW,/ALL_EVENTS,/integer)
 time_houra=CW_FIELD(time_cfg_sib1_1,UVALUE=4,TITLE='Hour: ',VALUE=houra,$
 						 xsize=8,/ROW,/ALL_EVENTS,/integer)
;
 time_years=CW_FIELD(time_cfg_sib2_1,UVALUE=5,TITLE='Year: ',VALUE=years,$
 						 xsize=8,/ROW,/ALL_EVENTS,/integer)
 time_doys=CW_FIELD(time_cfg_sib2_1,UVALUE=6,TITLE='DoY : ',VALUE=doys,$
 						 xsize=8,/ROW,/ALL_EVENTS,/integer)
 time_hours=CW_FIELD(time_cfg_sib2_1,UVALUE=7,TITLE='Hour: ',VALUE=hours,$
 						 xsize=8,/ROW,/ALL_EVENTS,/integer)
;
 time_cfg_chi2=WIDGET_BASE(time_cfg_base,/COLUMN,/ALIGN_CENTER)
 time_apply=widget_button(time_cfg_chi2,UVALUE=8,VALUE='Apply',/ALIGN_CENTER)
 ;
 time_cfg_err=WIDGET_LABEL(time_cfg_base, value='', /DYNAMIC_RESIZE, /ALIGN_LEFT)
 ;
 widget_control,time_cfg_chi1,/REALIZE

 xmanager,'timecfg',time_cfg_base

end
;=======
pro timecfg_event, event
;
@fuv_cmnblk
;
WIDGET_CONTROL,event.id,GET_UVALUE=eventval
;
;
case eventval of
 1: WIDGET_CONTROL,GET_VALUE=tmp_inst,time_inst_id
 2: WIDGET_CONTROL,GET_VALUE=tmp_yeara,time_yeara
 3: WIDGET_CONTROL,GET_VALUE=tmp_doya,time_doya
 4: WIDGET_CONTROL,GET_VALUE=tmp_houra,time_houra
 5: WIDGET_CONTROL,GET_VALUE=tmp_years,time_years
 6: WIDGET_CONTROL,GET_VALUE=tmp_doys,time_doys
 7: WIDGET_CONTROL,GET_VALUE=tmp_hours,time_hours
 8: begin
      WIDGET_CONTROL,GET_VALUE=tmp_inst,time_inst_id
      WIDGET_CONTROL,GET_VALUE=tmp_yeara,time_yeara
      WIDGET_CONTROL,GET_VALUE=tmp_doya,time_doya
      WIDGET_CONTROL,GET_VALUE=tmp_houra,time_houra
      WIDGET_CONTROL,GET_VALUE=tmp_years,time_years
      WIDGET_CONTROL,GET_VALUE=tmp_doys,time_doys
      WIDGET_CONTROL,GET_VALUE=tmp_hours,time_hours
      err=-1
      if (tmp_yeara+tmp_doya/366.+tmp_houra/366./24. gt tmp_years+tmp_doys/366.+tmp_hours/366./24.) then err=0
      if ((tmp_doys-tmp_doya) gt 1) then err=1
      if (((tmp_years-tmp_yeara) ge 1) and (tmp_doys ne 1)) then err=1
      case err of
      -1: begin
          active_inst=tmp_inst
          yeara=tmp_yeara
          doya=tmp_doya
          houra=tmp_houra
          years=tmp_years
          doys=tmp_doys
          hours=tmp_hours
          WIDGET_CONTROL,time_cfg_err,SET_VALUE=''
          endcase
      0:  begin
 	  WIDGET_CONTROL,time_cfg_err,SET_VALUE='Stop time must be later than start time'
 	  return
 	  endcase
      1:  begin
 	  WIDGET_CONTROL,time_cfg_err,SET_VALUE='Too long time period'
 	  return
 	  endcase
      endcase
;
	; this part is for all non-real-time files
	; reading twice is still faster than everything
       filetypes='UDF'
       case active_inst of
       0: inst_id='IMFHWIC'
       1: inst_id='IMF12LSI'
       2: inst_id='IMF13LSI'
       3: begin
          btnOpen_set,event
          if (err eq -1) then WIDGET_CONTROL,/DESTROY,event.top
          return
          endcase
       endcase

       if (err eq -1) then WIDGET_CONTROL,/DESTROY,event.top

       return_value=fuv_read_udf(starttime=fix([yeara,doya,houra,0]),$
           stoptime=fix([years,doys,hours,0]),vinst=inst_id,/inventory)

       ss=size(return_value)
       if ss[2] eq 8 then begin
          case years of
          2000: days=366.
          2004: days=366.
;          2008: days=366.
;          2012: days=366.
          ELSE: days=365.
          endcase
          maxx=n_elements(return_value)-1
          time_diff=(return_value[maxx].btime.year+return_value[maxx].btime.doy/days+return_value[maxx].btime.hour/days/24.)-$
                (years+doys/days+hours/days/24.)
          endif else begin
       	   result=dialog_message('No data for this time period')
           return
           endelse
          
       if (n_elements(return_value) gt 730) then begin
           result=dialog_message('Too many records. Truncate at number 729')
           return_value=return_value[0:729]   
           endif    
       maxrec(active_inst)=n_elements(return_value)

       fuv_mission_correction,return_value[0].btime.year,return_value[0].btime.doy,correction_value
       if (correction_value[0] eq 1. and correction_value[1] eq 1. and correction_value[2] eq 1.) then begin
           calibration_flag=0
           WIDGET_CONTROL,SET_VALUE=calibration_flag,calib_id
       	   result=dialog_message('Only raw counts possible for this day')
           endif

;		; updated messages about pointing
;       case 1 of
;       (return_value[0].btime.year eq 2000 and return_value[0].btime.doy lt 157): begin
;       		result=dialog_message('Warning! Pointing unreliable for this day')
;       		endcase
;       (return_value[0].btime.year eq 2001 and return_value[0].btime.doy ge 159 and return_value[0].btime.doy lt 233): $
;        	  result=dialog_message('Warning! Pointing unreliable for this day! Summer vacation of star tracker!')
;       (return_value[0].btime.year eq 2002 and return_value[0].btime.doy ge 142 and return_value[0].btime.doy lt 234): $
;        	  result=dialog_message('Warning! Pointing unreliable for this day! Summer vacation of star tracker!')
;       (return_value[0].btime.year eq 2003 and return_value[0].btime.doy ge 160 and return_value[0].btime.doy lt 228): $
;        	  result=dialog_message('Warning! Pointing unreliable for this day! Summer vacation of star tracker!')
;       (return_value[0].btime.year eq 2004 and return_value[0].btime.doy ge 162 and return_value[0].btime.doy lt 243): $
;        	  result=dialog_message('Warning! Pointing unreliable for this day! Summer vacation of star tracker!')
;       (return_value[0].btime.year eq 2005 and return_value[0].btime.doy ge 165 and return_value[0].btime.doy lt 238): $
;        	  result=dialog_message('Warning! Pointing unreliable for this day! Summer vacation of star tracker!')
;       ELSE: ok=1
;       endcase

       altitudes=fltarr(n_elements(return_value))+3.
       open_files,active_inst, ret_err, /GEN_LIST,udf_times=return_value	

       if (ret_err eq 0) then begin
         current = 0
         prevrec = 0
         num_list=1
         nextnum=0
         widget_control, both_coor, sensitive=1
         if (multi_inst gt 1) then begin
           multi_inst=1
           change_size
;         endif else getplot,active_inst,current
	     endif else begin
          stat_txt = 'Processing Plot...'
          WIDGET_CONTROL,status_id, set_value=stat_txt
          captured_img = display_img(active_inst,current)
          stat_txt = ' '
          WIDGET_CONTROL,status_id, set_value=stat_txt
	     endelse
         widget_control, datawid, set_list_select = 1
         widget_control, datawid, set_list_select = current
 		 widget_control, mnuout, sensitive=1          ; enable output menu option
;
       endif else begin
         stat_txt='Error during read.... File'+L1DIRFILE(active_inst)
         widget_control,status_id,set_value=stat_txt
         current=-1
         prevrec=-1
         selected_inst[*] = 0
         avail_inst[*]=0
       endelse
     catch, error_status

    end
;
endcase

end
;------------------------------------------
;
; Main driver for fuview program
;
;
; Changes made to code:  (05-99) By Krishna Majumdar(CSC).
;; June-99
; Added Menu Interface(IDL Widgets).
; Added Dialog_pickfile to select L1 directory
; Added data window to display time record with Filter (6-10-99)
; Added Color table to select colors, called XLOADCT  (7-27-99).
;; JULY -- August-99 ----------
; Removed XLOADCT call and added LOADCT call to select color from 7 color option from color table. (8-4-99).
; Removed hard-coded color calls from plotting procedures and  added color selection
; list for Text, Line, Grid, Continents.
; Added Color_value_Upd and Color_curr_upd procedures to toggle between default colors and current colors.
; Added  Dynamic resize with Widget_label status and Draw_xsize to resize image screen
; Added Color Bar option to show or not to show
; Added Background color
; Added Newdir.pro to select Year/Day from /UVIDATA.
; September 99 --
; Added Z-Buffer option for making GIF file.
; Reduce Screen size for Coordinate one and two option.
; Added Modifiled Color table and to select from 41 colors.
; Added Help text for Menu.
; Added Idl object graphics to make Mpeg movie.
; Replaced Refresh PLOT button, Added Cancel Button to stop or Interrupt plot
; Added NEXT(>), PREVIOUS(<),  Backward LIst(<<), NextList(>>) 9-24-99
; Replaced buttons with Menubar(OCT-99).

;; Main Screen Interface procedure

PRO main_scr3, fast=fast

@fuv_cmnblk

;    itemp = ['Create Gif']
    rtemp = ['Refresh Plot']
    barstr = ['COLOR BAR']
    pltcor = ['ALL', 'Geographic  ', 'MLT (APEX)']
    gifstr = ['No', 'Yes  ']
    prt = 0  ; For Gif
    refrs = [0,0]  ; For Refreshing
    cor = 0   ;; coordinate value
    baronof = 1 ;; show bar or not
    makegif = 0 ; No gif
    nselect = 0
    drawcont= 1 ; Draw Continent flag is on

;
     colrnames = 0   ; for Loadct call
;
;Initialization
     fuv_init, retval, fast=fast
;
; Load Default color table and get names of all color tables

     LOADCT,0, GET_NAMES = colrnames, FILE=FILE_PATH+Dir_sep+'colors.tbl'


; Main base

    ver_txt= 'FUVIEW Version 8.0.0 Last Modified 11/20/2006'  ; by HUF
    base = WIDGET_BASE(/COL, TITLE=ver_txt,MBAR=bar)

    row1 = WIDGET_BASE(base, /ROW)
    row2 = WIDGET_BASE(base, /ROW,/ALIGN_LEFT)
    row3 = WIDGET_BASE(base, /ROW,/ALIGN_CENTER)
    row4 = WIDGET_BASE(base, /ROW)

    widget_control,default_font='Helvetica-bold*16'

    ;Menu group 1000 (File)
       mnuFile = WIDGET_BUTTON(bar, VALUE='File', UVALUE=1000, /MENU)

       ;Menu item 1100 (Open)
       mnuopen = WIDGET_BUTTON(mnuFile, VALUE='Open', UVALUE=1100, /MENU)
       ;
       ;Menu Open individual File
       dummy = WIDGET_BUTTON(mnuopen, VALUE='Time period', UVALUE=11109, $
           event_pro='time_period')
       mnuwic = WIDGET_BUTTON(mnuopen, VALUE='WIC File', UVALUE=1101, /MENU)
       dummy = WIDGET_BUTTON(mnuwic, VALUE='WIC File 2000 (Individual)', UVALUE=11110, $
           event_pro='btnOpen_file')
       dummy = WIDGET_BUTTON(mnuwic, VALUE='WIC File 2001 (Individual)', UVALUE=11111, $
           event_pro='btnOpen_file')
       dummy = WIDGET_BUTTON(mnuwic, VALUE='WIC File 2002 (Individual)', UVALUE=11112, $
           event_pro='btnOpen_file')
       dummy = WIDGET_BUTTON(mnuwic, VALUE='WIC File 2003 (Individual)', UVALUE=11113, $
           event_pro='btnOpen_file')
       dummy = WIDGET_BUTTON(mnuwic, VALUE='WIC File 2004 (Individual)', UVALUE=11114, $
           event_pro='btnOpen_file')
       dummy = WIDGET_BUTTON(mnuwic, VALUE='WIC File 2005 (Individual)', UVALUE=11115, $
           event_pro='btnOpen_file')
;       dummy = WIDGET_BUTTON(mnuwic, VALUE='WIC File 2006 (Individual)', UVALUE=11116, $
;           event_pro='btnOpen_file')
;       dummy = WIDGET_BUTTON(mnuwic, VALUE='WIC File 2007 (Individual)', UVALUE=11117, $
;           event_pro='btnOpen_file')
;       dummy = WIDGET_BUTTON(mnuwic, VALUE='WIC File 2008 (Individual)', UVALUE=11118, $
;           event_pro='btnOpen_file')

       mnus12 = WIDGET_BUTTON(mnuopen, VALUE='SI12 File', UVALUE=1102, /MENU)
       dummy = WIDGET_BUTTON(mnus12, VALUE='SI12 File 2000 (Individual)', UVALUE=11120, $
           event_pro='btnOpen_file')
       dummy = WIDGET_BUTTON(mnus12, VALUE='SI12 File 2001 (Individual)', UVALUE=11121, $
           event_pro='btnOpen_file')
       dummy = WIDGET_BUTTON(mnus12, VALUE='SI12 File 2002 (Individual)', UVALUE=11122, $
           event_pro='btnOpen_file')
       dummy = WIDGET_BUTTON(mnus12, VALUE='SI12 File 2003 (Individual)', UVALUE=11123, $
           event_pro='btnOpen_file')
       dummy = WIDGET_BUTTON(mnus12, VALUE='SI12 File 2004 (Individual)', UVALUE=11124, $
           event_pro='btnOpen_file')
       dummy = WIDGET_BUTTON(mnus12, VALUE='SI12 File 2005 (Individual)', UVALUE=11125, $
           event_pro='btnOpen_file')
;       dummy = WIDGET_BUTTON(mnus12, VALUE='SI12 File 2006 (Individual)', UVALUE=11126, $
;           event_pro='btnOpen_file')
;       dummy = WIDGET_BUTTON(mnus12, VALUE='SI12 File 2007 (Individual)', UVALUE=11127, $
;           event_pro='btnOpen_file')
;       dummy = WIDGET_BUTTON(mnus12, VALUE='SI12 File 2008 (Individual)', UVALUE=11128, $
;           event_pro='btnOpen_file')

       mnus13 = WIDGET_BUTTON(mnuopen, VALUE='SI13 File', UVALUE=1103, /MENU)
       dummy = WIDGET_BUTTON(mnus13, VALUE='SI13 File 2000 (Individual)', UVALUE=11130, $
           event_pro='btnOpen_file')
       dummy = WIDGET_BUTTON(mnus13, VALUE='SI13 File 2001 (Individual)', UVALUE=11131, $
           event_pro='btnOpen_file')
       dummy = WIDGET_BUTTON(mnus13, VALUE='SI13 File 2002 (Individual)', UVALUE=11132, $
           event_pro='btnOpen_file')
       dummy = WIDGET_BUTTON(mnus13, VALUE='SI13 File 2003 (Individual)', UVALUE=11133, $
           event_pro='btnOpen_file')
       dummy = WIDGET_BUTTON(mnus13, VALUE='SI13 File 2004 (Individual)', UVALUE=11134, $
           event_pro='btnOpen_file')
       dummy = WIDGET_BUTTON(mnus13, VALUE='SI13 File 2005 (Individual)', UVALUE=11135, $
           event_pro='btnOpen_file')
;       dummy = WIDGET_BUTTON(mnus13, VALUE='SI13 File 2006 (Individual)', UVALUE=11136, $
;           event_pro='btnOpen_file')
;       dummy = WIDGET_BUTTON(mnus13, VALUE='SI13 File 2007 (Individual)', UVALUE=11137, $
;           event_pro='btnOpen_file')
;       dummy = WIDGET_BUTTON(mnus13, VALUE='SI13 File 2008 (Individual)', UVALUE=11138, $
;           event_pro='btnOpen_file')
       ;Menu Open FUV Set
       mnuset = WIDGET_BUTTON(mnuopen, VALUE='FUV Set (WIC/SI12/SI13)', UVALUE=1104, /MENU)
       dummy = WIDGET_BUTTON(mnuset, VALUE='FUV Set 2000 (WIC/SI12/SI13)', UVALUE=11300, $
           event_pro='btnOpen_set')
       dummy = WIDGET_BUTTON(mnuset, VALUE='FUV Set 2001 (WIC/SI12/SI13)', UVALUE=11301, $
           event_pro='btnOpen_set')
       dummy = WIDGET_BUTTON(mnuset, VALUE='FUV Set 2002 (WIC/SI12/SI13)', UVALUE=11302, $
           event_pro='btnOpen_set')
       dummy = WIDGET_BUTTON(mnuset, VALUE='FUV Set 2003 (WIC/SI12/SI13)', UVALUE=11303, $
           event_pro='btnOpen_set')
       dummy = WIDGET_BUTTON(mnuset, VALUE='FUV Set 2004 (WIC/SI12/SI13)', UVALUE=11304, $
           event_pro='btnOpen_set')
       dummy = WIDGET_BUTTON(mnuset, VALUE='FUV Set 2005 (WIC/SI12/SI13)', UVALUE=11305, $
           event_pro='btnOpen_set')
;       dummy = WIDGET_BUTTON(mnuset, VALUE='FUV Set 2006 (WIC/SI12/SI13)', UVALUE=11306, $
;           event_pro='btnOpen_set')
;       dummy = WIDGET_BUTTON(mnuset, VALUE='FUV Set 2007 (WIC/SI12/SI13)', UVALUE=11307, $
;           event_pro='btnOpen_set')
;       dummy = WIDGET_BUTTON(mnuset, VALUE='FUV Set 2008 (WIC/SI12/SI13)', UVALUE=11308, $
;           event_pro='btnOpen_set')
       ;
       ;Menu item 1200 (Output)
       mnuout = WIDGET_BUTTON(mnuFile, VALUE='Output', UVALUE=1200, /MENU,SENSITIVE=0)
	   ;
       ;Menu item 1210 (Create Gifs)
       gifdummy = WIDGET_BUTTON(mnuout, VALUE='GIF', UVALUE=1210, event_pro='btnCreateGif_Click')

       ;Menu item 1220 (Create PS)
       ps_id = WIDGET_BUTTON(mnuout, VALUE='PostScript', UVALUE=1220,event_pro='btnCreatePS_Click')

       ;Menu item 1230 (Create XDR)
       xdr_id = WIDGET_BUTTON(mnuout, VALUE='Write XDR', UVALUE=1230,event_pro='btnCreateXDR_Click')

       ;Menu item 1232 (Create XDR)
       xdr_id = WIDGET_BUTTON(mnuout, VALUE='Write compressed XDR', UVALUE=1232,event_pro='btnCreateXDR_Click')

       ;Menu item 1231 (Create XDR)
       xdr_id = WIDGET_BUTTON(mnuout, VALUE='Write Mag XDR', UVALUE=1231,event_pro='btnCreateMagXDR_Click')

       ;Menu item 1240 (Create Mac specific image)
       xdr_id = WIDGET_BUTTON(mnuout, VALUE='Write Mac', UVALUE=1240,event_pro='btnCreateMac_Click')

       ;Menu item 1250 (Create Mac specific image)
       xdr_id = WIDGET_BUTTON(mnuout, VALUE='Write Scaled Mac', UVALUE=1250,$
       		event_pro='btnCreateMac_special_Click')

       ;Menu item 1260 (Create Mac specific image)
       xdr_id2 = WIDGET_BUTTON(mnuout, VALUE='Write imageinfo', UVALUE=1260,$
       		event_pro='btnCreateXDR_Click',/MENU)

      xdr_name = WIDGET_BUTTON(xdr_id2,Value='yyyymmddhhmmss format',$
	UVALUE=1265,event_pro='btnCreateXDR_Click')

      xdr_name = WIDGET_BUTTON(xdr_id2,Value='yyyymmddhhmmss compressed',$
	UVALUE=1266,event_pro='btnCreateXDR_Click')

      xdr_name = WIDGET_BUTTON(xdr_id2,Value='yyyydddhhmm format',$
	 UVALUE=1270,event_pro='btnCreateXDR_Click')

      xdr_name = WIDGET_BUTTON(xdr_id2,Value='yyyydddhhmm compressed',$
	 UVALUE=1271,event_pro='btnCreateXDR_Click')

       ;Menu item 1280 (Create Mac specific image)
       if keyword_set(fast) then xdr_id2 = WIDGET_BUTTON(mnuout, VALUE='Write imageinfo+fast_data', UVALUE=1280,$
       		event_pro='btnCreateXDR_Click')

       ;Menu item 1300 (Create MPEG)
;       mpegdummy = WIDGET_BUTTON(mnuout, VALUE='MPEG', UVALUE=1300,event_pro='btnCreateMpeg_Click', $
;       							SENSITIVE=0)

	   ;
       ;Menu item 1900 (Exit)
       dummy = WIDGET_BUTTON(mnuFile, VALUE='Exit', UVALUE=1900, $
           /SEPARATOR, event_pro='btnExit_Click')

       ;Menu group 2000 (Colors)
       mnuColors = WIDGET_BUTTON(bar, VALUE='Colors', UVALUE=2000, /MENU)

       ;Menu subgroup 2100 (Color Table)
       mnuColorTable = WIDGET_BUTTON(mnuColors, VALUE='Color Table', $
           UVALUE=2100, /MENU)

       ;Create menu item for each color table
       numColors = n_elements(colrnames)
       menuitem = 2110
       for ct=0, numColors-1 do begin
           cbutton = WIDGET_BUTTON(mnuColorTable, VALUE=colrnames[ct], $
              uvalue = ct, EVENT_PRO='set_ct', FONT='Helvetica-bold*12')
           menuitem = menuitem + 1
       endfor

       ;Menu subgroup 2200 (Background)
       mnuBackground = WIDGET_BUTTON(mnuColors, $
           VALUE='Background', $
           UVALUE=2200, $
           /MENU)

       ;Menu item 2210 (White)
       dummy = WIDGET_BUTTON(mnuBackground, VALUE='White', UVALUE=2210)

       ;Menu item 2220 (Black)
       dummy = WIDGET_BUTTON(mnuBackground, VALUE='Black', UVALUE=2220)

       ;Menu subgroup 2300 (Text Color)
       mnuText = WIDGET_BUTTON(mnuColors, VALUE='Text', /MENU)

       ;Menu item 2310
       dummy = WIDGET_BUTTON(mnuText, VALUE='Black', UVALUE=2310)

       ;Menu item 2320
       dummy = WIDGET_BUTTON(mnuText, VALUE='Blue', UVALUE=2320)

       ;Menu item 2330
       dummy = WIDGET_BUTTON(mnuText, VALUE='Red', UVALUE=2330)

       ;Menu item 2340
       dummy = WIDGET_BUTTON(mnuText, VALUE='White', UVALUE=2340)

       ;Menu item 2350
       dummy = WIDGET_BUTTON(mnuText, VALUE='Green', UVALUE=2350)


       ;Menu subgroup 2400 (Line Color)
       mnuLine = WIDGET_BUTTON(mnuColors, VALUE='Line', /MENU)

       ;Menu item 2410
       dummy = WIDGET_BUTTON(mnuLine, VALUE='Black', UVALUE=2410)

       ;Menu item 2420
       dummy = WIDGET_BUTTON(mnuLine, VALUE='Blue', UVALUE=2420)

       ;Menu item 2430
       dummy = WIDGET_BUTTON(mnuLine, VALUE='Red', UVALUE=2430)

       ;Menu item 2440
       dummy = WIDGET_BUTTON(mnuLine, VALUE='White', UVALUE=2440)

       ;Menu item 2450
       dummy = WIDGET_BUTTON(mnuLine, VALUE='Green', UVALUE=2450)


       ;Menu subgroup 2500 (Grid Color)
       mnuGrid = WIDGET_BUTTON(mnuColors, VALUE='Grid', /MENU)

       ;Menu item 2510
       gbutton = WIDGET_BUTTON(mnuGrid, VALUE='Black', UVALUE=2510)

       ;Menu item 2520
       gbutton = WIDGET_BUTTON(mnuGrid, VALUE='Blue', UVALUE=2520)

       ;Menu item 2530
       gbutton = WIDGET_BUTTON(mnuGrid, VALUE='Red', UVALUE=2530)

       ;Menu item 2540
       gbutton = WIDGET_BUTTON(mnuGrid, VALUE='White', UVALUE=2540)

       ;Menu item 2550
       gbutton = WIDGET_BUTTON(mnuGrid, VALUE='Green', UVALUE=2550)


       ;Menu subgroup 2600 (Continent Color)
       mnuContinents = WIDGET_BUTTON(mnuColors, VALUE='Continents', /MENU)

       ;Menu item 2610
       dummy = WIDGET_BUTTON(mnuContinents, VALUE='Black', UVALUE=2610)

       ;Menu item 2620
       dummy = WIDGET_BUTTON(mnuContinents, VALUE='Blue', UVALUE=2620)

       ;Menu item 2630
       dummy = WIDGET_BUTTON(mnuContinents, VALUE='Red', UVALUE=2630)

       ;Menu item 2640
       dummy = WIDGET_BUTTON(mnuContinents, VALUE='White', UVALUE=2640)

       ;Menu item 2650
       dummy = WIDGET_BUTTON(mnuContinents, VALUE='Green', UVALUE=2650)
       dummy = WIDGET_BUTTON(mnuContinents, VALUE='Off', UVALUE=2660)
       dummy = WIDGET_BUTTON(mnuContinents, VALUE='ON', UVALUE=2670)

       ;Menu subgroup 2700 (stars)
       mnuStars = WIDGET_BUTTON(mnuColors, VALUE='Stars', /MENU)
       dummy = WIDGET_BUTTON(mnuStars, VALUE='Off', UVALUE=2760)
       dummy = WIDGET_BUTTON(mnuStars, VALUE='ON', UVALUE=2770)

       ;Menu group 3000 (Display)
       mnuDisplay = WIDGET_BUTTON(bar, VALUE='Display', UVALUE=3000, /MENU)

       ;Menu subgroup 3100 (Coordinate System)
       mnuCoordSys = WIDGET_BUTTON(mnuDisplay, VALUE='Coordinate System', $
           UVALUE=3100, /MENU)

       ;GDI Option
	   gdi_opt_id=WIDGET_BUTTON(mnuCoordSys,VALUE='Geodetic',UVALUE=3010,SENSITIVE=0)

       ;GCI Option
;	   gci_opt_id=WIDGET_BUTTON(mnuCoordSys,VALUE='Geocentric',UVALUE=3020)

       ;Menu item 3110 (Geographic)
       dummy = WIDGET_BUTTON(mnuCoordSys, VALUE='Geographic', UVALUE=3110,/SEPARATOR)

       ;Menu item 3120 (Magnetic)
       dummy = WIDGET_BUTTON(mnuCoordSys, VALUE='Magnetic', UVALUE=3120)

       ;Menu item 3130 (Both)
       both_coor = WIDGET_BUTTON(mnuCoordSys, VALUE='Both', UVALUE=3130)

       ;Menu subgroup 3200 (Color Bar)
       mnuColorBar = WIDGET_BUTTON(mnuDisplay, VALUE='Color Bar', $
           UVALUE=3200, /MENU)

       ;Menu item 3210 (On)
       dummy = WIDGET_BUTTON(mnuColorBar, VALUE='On', UVALUE=3210)

       ;Menu item 3220 (Off)
       dummy = WIDGET_BUTTON(mnuColorBar, VALUE='Off', UVALUE=3220)

	   ;Keogram menu bar options
       ;Menu subgroup 3300 (Keogram)
       keo_menu = WIDGET_BUTTON(mnuDisplay, VALUE='Keogram', UVALUE=3300, $
                                /MENU)
       ;Menu item 3310 (Keogram)
       keo_config = WIDGET_BUTTON(keo_menu, VALUE='Configure', UVALUE=3310, $
                                event_pro='config_keo')
       ;Menu item 3320 (Keogram)
       keo_create = WIDGET_BUTTON(keo_menu, VALUE='Create', UVALUE=3320, $
                                event_pro='create_keo')

       ;Menu group 4000 (Display)
       mnuPrint = WIDGET_BUTTON(bar, VALUE='Print', UVALUE=4000, /MENU)

      print_name = WIDGET_BUTTON(mnuPrint,Value='Print black/white',$
	UVALUE=4010,event_pro='btnPrintPS')

      print_name = WIDGET_BUTTON(mnuPrint,Value='Print color',$
	UVALUE=4020,event_pro='btnPrintPS')

       ;Menu group 9000
       mnuHelp = WIDGET_BUTTON(bar, VALUE='Help', UVALUE=9000, /HELP, /MENU)

       ;Menu item 9100
       btnHelpGifWalk = WIDGET_BUTTON(mnuHelp, VALUE='Help on FUVIEW', $
           UVALUE=9100, event_pro='btnHelpFUView_Click')

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; Changed height of list window TJI

     state = {bases: lonarr(2), name_list: 0L }
     draw_wid = WIDGET_BASE(row1, /COLUMN)
     draw_id = WIDGET_DRAW(draw_wid, XSIZE= xwin, YSIZE = ywin,/BUTTON_EVENT,EVENT_PRO='mouse_event')
     if !VERSION.OS eq 'Win32' then device, decomposed=0
     datastr = [' ',' ']

     listwid = WIDGET_BASE(row1,/COLUMN)
     datawid= WIDGET_LIST(listwid, uvalue=1, value=datastr, $
           YSIZE=18,XSIZE=6,/MULTIPLE)

; color name selection window
     color_list =['DEFAULT Color','B-W LINEAR', 'BLUE-WHITE', 'RED TEMPERATURE', 'STD GAMMA-II', 'RAINBOW', $
                        'GREEN/WHITE LINEAR', 'GRN/WHT EXPONENT']


    ;Status pane
    status_id = WIDGET_LABEL(row4, value='', /DYNAMIC_RESIZE)

; Set up for mousewindow and color bar scaling
    stchild0=WIDGET_BASE(row2,/ROW,/ALIGN_CENTER)
    stchild0_sib1=WIDGET_BASE(stchild0,/COLUMN)


; Mouse window
    sphere_id_txt=['North','South']
    sphere_value=abs(sphere/2.-0.5)

    ; *****ESC, Stop button added to allow recompiling subroutines
    stchild0_sib1_1=WIDGET_BASE(stchild0_sib1,/ROW,SPACE=20,XPAD=0)
    ;sphere_id=CW_BGROUP(stchild0_sib1,/ROW,UVALUE=9300,/EXCLUSIVE,sphere_id_txt,SET_VALUE=sphere_value,FRAME=2)
    sphere_id=CW_BGROUP(stchild0_sib1_1,/ROW,UVALUE=9300,/EXCLUSIVE,sphere_id_txt,SET_VALUE=sphere_value,FRAME=2)
    stop_fuview=WIDGET_BUTTON(stchild0_sib1_1, VALUE='Stop', UVALUE=9350)
    ; *****ESC
      ; minimum latitude
    minlat_fuview=WIDGET_BUTTON(stchild0_sib1_1, VALUE='40/50', UVALUE=9360)

;Position Option
	stchild0_sib1_3=WIDGET_BASE(stchild0_sib1,/ROW,FRAME=2)
	position_text='0.0 , 0.0'
	position_lon_id=CW_FIELD(stchild0_sib1_3,UVALUE=9515,TITLE='Geog. Lon., Lat.: ',VALUE=position_text,$
						   xsize=8,/ROW,/STRING,/RETURN_EVENTS,Ysize=1)
    position_reset=WIDGET_BUTTON(stchild0_sib1_3, VALUE='Reset', UVALUE=9516)

    calib_id_txt=['Raw','Corr. Count','Rayleigh']
    calib_id=CW_BGROUP(stchild0_sib1,/ROW,UVALUE=9400,/EXCLUSIVE,calib_id_txt,SET_VALUE=calibration_flag,FRAME=2)
    dummy=WIDGET_LABEL(stchild0_sib1,value='Mouse Location')
	mousewin=WIDGET_TEXT(stchild0_sib1,XSIZE=33,YSIZE=3,VALUE=' ')

	stchild0_sib2n=WIDGET_BASE(stchild0,/COLUMN)
	stchild0_sib2=WIDGET_BASE(stchild0_sib2n,/COLUMN,FRAME=2)
	stchild0_sib2_ch1=WIDGET_BASE(stchild0_sib2,/ROW)
	stchild0_sib2_ch2=WIDGET_BASE(stchild0_sib2,/ROW)

;Scaling Option
	scale_id_txt=['log Scale','Linear Scale']
	scale_id=CW_BGROUP(stchild0_sib2_ch1,/COLUMN,UVALUE=9500,/EXCLUSIVE,scale_id_txt,SET_VALUE=scale_type)

;Logrithm scale min max
	log_min_id=CW_FIELD(stchild0_sib2_ch1,UVALUE=9510,TITLE='Min: ',VALUE=log_scl_min,$
						   xsize=5,/ROW,/INTEGER,/RETURN_EVENTS,Ysize=1)
	log_max_id=CW_FIELD(stchild0_sib2_ch1,UVALUE=9520,TITLE='Max: ',VALUE=log_scl_max,$
						   xsize=5,/ROW,/LONG,/RETURN_EVENTS,Ysize=1)

;Airglow Option
	stchild0_sib3=WIDGET_BASE(stchild0_sib2n,/ROW,FRAME=2)
	stchild0_sib3_ch1=WIDGET_BASE(stchild0_sib3,/ROW)
	stchild0_sib3_ch2=WIDGET_BASE(stchild0_sib3,/ROW)
	air_id_txt=['No Airglow','Airglow Corr.','No active']
	air_id=CW_BGROUP(stchild0_sib3_ch1,/COLUMN,UVALUE=9600,/EXCLUSIVE,air_id_txt,SET_VALUE=airglow_flag)

;scaling option
	air_scl_id1=CW_FIELD(stchild0_sib3_ch2,UVALUE=9610,$
	TITLE='Multi: ',VALUE=airglow_scale(0),/FLOATING,$
	xsize=8,/COLUMN,/RETURN_EVENTS,Ysize=1)
	air_scl_id2=CW_FIELD(stchild0_sib3_ch2,UVALUE=9612,$
	TITLE='Power: ',VALUE=airglow_scale(1),/FLOATING,$
	xsize=8,/COLUMN,/RETURN_EVENTS,Ysize=1)
	air_scl_id3=CW_FIELD(stchild0_sib3_ch2,UVALUE=9614,$
	TITLE='Bias: ',VALUE=fix(airglow_scale(2)),/INTEGER,$
	xsize=8,/COLUMN,/RETURN_EVENTS,Ysize=1)

;Auto scale slider
;
;	auto_scl_id=CW_BGROUP(stchild0_sib2_ch2,/COLUMN,UVALUE=9530,/NONEXCLUSIVE,'Auto Scaling')
;	lin_slider_id=WIDGET_SLIDER(stchild0_sib2_ch2,UVALUE=9540,VALUE=slide_min,MAXIMUM=slide_max,$
;								MINIMUM=slide_min,xsize=188)
;    WIDGET_CONTROL,lin_slider_id,SENSITIVE=0
;
;Image pane
    stchild1 = WIDGET_BASE(row3, /ROW, /ALIGN_CENTER)
;
     ;VCR buttons
     backward_all = WIDGET_BUTTON(stchild1, VALUE='<< Play Reverse', event_pro ='Play_rev_event', sensitive=0)
     prevkey = WIDGET_BUTTON(stchild1, VALUE='< Step Reverse', event_pro = 'previous_event', sensitive=0)
     stopevnt = WIDGET_BUTTON(stchild1, VALUE='Stop', event_pro = 'stop_event', sensitive=0)
     pausevnt = WIDGET_BUTTON(stchild1, VALUE='Pause', event_pro = 'pause_event', sensitive=0)
     next = WIDGET_BUTTON(stchild1, VALUE='Step >', event_pro = 'next_event', sensitive=0)
     nextall = WIDGET_BUTTON(stchild1, VALUE='Play Fwd >> ', event_pro = 'Play_fwd_event', sensitive=0)

     stchild = WIDGET_BASE(draw_wid, /ROW,/ALIGN_CENTER)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

     WIDGET_CONTROL,base,/REALIZE
     widget_control,get_value=wd_index, draw_id
;
     info={base:base,draw_id:draw_id,wd_index:wd_index}

	 widget_control,base,SET_UVALUE=info
;
     xmanager,'main_scr', base
END

