;
;
pro load_stars,transformation_matrix,l0,no_print=no_print
;
; ;
; T Immel 		03/21/2001    Spring Cleaning
; H Frey		01/07/2004    added l0 as parameter
; H Frey                08/03/2006    corrected location for 2003
;
; input: tranformation_matrix calculated from $
; fuv_rotation_matrix(omega,theta,phi,scsv_x,scsv_y,scsv_z...)
;


@fuv_cmnblk
; need imageinfo
;
;


;earth_center_rec=180.d/!dpi*atan(-orbpos[1],-orbpos[0])
;earth_center_dec=180.d/!dpi*atan(-orbpos[2]/sqrt(orbpos[0]^2+orbpos[1]^2))

     Ox = imageinfo(active_inst).o_gci[0]
     Oy = imageinfo(active_inst).o_gci[1]
     Oz = imageinfo(active_inst).o_gci[2]
;     omega = imageinfo.inst_roll
;     theta = imageinfo.inst_co_elev
;     phi   = imageinfo.inst_azimuth
     pr = imageinfo(active_inst).angl_res_r  ; fov of WIC or SI
     pc = imageinfo(active_inst).angl_res_c 
;	print,phi,theta,omega,' Printed Phi, Theta etc...'


     earth_center_rec=180.d/!dpi*atan(-Oy,-Ox)
     earth_center_dec=180.d/!dpi*atan(-Oz / sqrt(Ox^2+Oy^2) )


starrec=[earth_center_rec,$
	215.6775,$	; epsilon apus
	161.4462,$	; delta chameleon
	184.6229,$	; beta chameleon
	189.3346,$	; alpha musca
	191.6104,$	; beta musca
	177.9954,$	; L musca
	184.6450,$	; zeta crux
	186.6858,$	; alpha crux
	173.9750,$	; lambda centaurus
	200.7008,$	; J centaurus
	211.0029,$	; beta centaurus
        191.9687,$	; beta crux
	183.8212,$	; delta crux
	193.6867,$	; my crux
	205.0142,$	; epsilon centaurus
        182.9475,$	; rho centaurus
	182.1237,$	; delta centaurus
	187.0458,$	; sigma centaurus
	196.7667,$	; xi2 centaurus
	190.4162,$	; gamma centaurus
	208.9321,$	; zeta centaurus
	201.3337,$	; alpha virgo, spica
	206.9129,$	; eta UMA
	193.5400,$	; epsilon UMa
	188.4017,$	; kappa draco
	 38.6662,$	; alpha umi, polaris
	 50.0637,$	; BK Cam
	 28.6533,$	; epsilon cas
	 14.2171,$	; gamma cassio
	 28.0471,$	; V436 perseus
	  9.2796,$	; zeta cas
	 25.9571,$	; phi perseus
	 12.4904,$	; nu andromeda
	  9.2558,$	; pi andromeda
	 16.4567,$	; psi pisces
	 14.6846,$	; alpha sculptor
	 39.9096,$	; epsilon hydrus
	 45.5679,$	; theta hydrus
	341.5850,$	; beta octans
	  7.9187,$	; beta tuc
	 24.4546]	; alpha eridani

stardec=[earth_center_dec,$
	-80.1214,$	; epsilon apus
	-80.5542,$	; delta chameleon
	-79.3272,$	; beta chameleon
	-69.1506,$	; alpha musca
	-68.1228,$	; beta musca
	-65.2208,$	; L musca
	-64.0181,$	; zeta crux
	-63.1139,$	; alpha crux
	-63.0344,$	; lambda centaurus
	-61.0025,$	; J centaurus
	-60.3861,$	; beta centaurus
        -59.7036,$	; beta crux
	-58.7639,$	; delta crux
	-57.1925,$	; my crux
	-53.4803,$	; epsilon centaurus
        -52.3836,$	; rho centaurus
	-50.7375,$	; delta centaurus
	-50.2456,$	; sigma centaurus
	-49.9208,$	; xi2 centaurus
	-48.9744,$	; gamma centaurus
	-47.3028,$	; zeta centaurus
	-11.1755,$	; alpha virgo, spica
	 49.2997,$	; eta UMA
	 55.9436,$	; epsilon UMa
	 69.7733,$	; kappa draco
	 89.2764,$	; alpha umi, polaris
 	 65.6630,$	; BK Cam
	 63.6847,$	; epsilon cas
	 60.7317,$	; gamma cassio
	 55.1622,$	; V436 perseus
	 53.9119,$	; zeta cas
	 50.7028,$	; phi perseus
	 41.0939,$	; nu andromeda
	 33.7344,$	; pi andromeda
	 21.4878,$	; psi pisces
	-29.3428,$	; alpha sculptor
	-68.2547,$	; epsilon hydrus
	-71.8914,$	; theta hydrus
	-81.3675,$	; beta octans
	-62.9433,$	; beta tuc
	-57.2228]	; alpha eridani

starnames=['Earth center',$
	'epsilon apus',$
	'delta chameleon',$
	'beta chameleon',$
	'alpha musca',$
	'beta musca',$
	'L musca',$
	'zeta crux',$
	'alpha crux',$
	'lambda centaurus',$
	'J centaurus',$
	'beta centaurus',$
        'beta crux',$
	'delta crux',$
	'my crux',$
	'epsilon centaurus',$
        'rho centaurus',$
	'delta centaurus',$
	'sigma centaurus',$
	'xi2 centaurus',$
	'gamma centaurus',$
	'zeta centaurus',$
	'alpha virgo, spica',$
	'eta UMa',$
	'epsilon UMa',$
	'kappa draco',$
	'alpha umi, polaris',$
	'BK Cam',$
	'epsilon cas',$
	'gamma cassio',$
	'V436 perseus',$
	'zeta cas',$
	'phi perseus',$
	'nu andromeda',$
	'pi andromeda',$
	'psi pisces',$
	'alpha sculptor',$
	'epsilon hydrus',$
	'theta hydrus',$
	'beta octans',$
	'beta tucana ',$
	'alpha eridani']

inside=strarr(n_elements(starnames))

;===============================================================
; convert star positions into x,y,z
starnum=n_elements(stardec)
f_lpixx=cos(!dtor*stardec)*cos(!dtor*starrec)
f_lpixy=cos(!dtor*stardec)*sin(!dtor*starrec)
f_lpixz=sin(!dtor*stardec)
f_res=dblarr(starnum,3)
f_res[*,0]=f_lpixx
f_res[*,1]=f_lpixy
f_res[*,2]=f_lpixz
f_lpx=transpose(transformation_matrix) ## f_res
f_lpx=reform(f_lpx,starnum,3)
n_startanx=-sqrt((1.-f_lpx[*,1]^2-f_lpx[*,2]^2) > 0.)/f_lpx[*,2]*f_lpx[*,0]/abs(f_lpx[*,0])
n_startany=-sqrt((1.-f_lpx[*,0]^2-f_lpx[*,2]^2) > 0.)/f_lpx[*,2]*f_lpx[*,1]/abs(f_lpx[*,1])
n_starsxrot=atan(n_startanx)*!radeg
n_starsyrot=atan(n_startany)*!radeg
new_starsx=n_starsxrot/pc+ (nrows-1)/2
new_starsy=n_starsyrot/pr+ (nrows-1)/2
	; correct for look direction
look_dir=l0[0]*f_lpixx[*]+l0[1]*f_lpixy[*]+l0[2]*f_lpixz[*]  ; scalar product

dummy=where(look_dir lt 0.,count)
if (count gt 0) then begin
  new_starsx[dummy]=2000.
  new_starsy[dummy]=2000.
  endif
dummy2=where(new_starsx ge 0. and new_starsx le 255. and $
	new_starsy ge 0. and new_starsy le 255.,count)
if (count gt 0) then begin
  inside[dummy2]='!!!!'
  endif

if not keyword_set(no_print) then begin
  print,'Calculated star positions in x,y'
  print,'============================================'
  print,'Ins.    x-pos.    y-pos.        Star-name'
  print,'============================================'
  for ippi=0,n_elements(starrec)-1 do print,inside[ippi],$
        new_starsx[ippi],new_starsy[ippi],starnames[ippi],format='(a4,2F10.4,a20)'
  print,' '
  endif

;stop

return
end

