;%W %G
; @(#)geo2mlt.pro	1.3 01/04/99
;
PRO geo2mlt,image,lat_mag,mlt,mlt_img,latmin,norm_rsat,sphere

; 23 Nov 98 M. Brittnacher - new algorithm, not flux preserving
;      but rather intensity preserving; undersampled data is
;      restored by averaging nearest neighbors

; INPUTS:
; image     calibrated image in photon flux units (200x228)
; lat_mag   magnetic latitude (256x256)
; mlt       mlt hour angle (256x256)
; latmin    minimum latitude (scalar)

; OUTPUTS   [ ncell = 4*(90 - latmin) ]
; mlt_img   transformed image (ncellxncell)

nxpix=(size(image))[1]
nypix=(size(image))[2]

ncell = FIX(4.*(90. - latmin))
mcell = ncell + 1
lat_lim = (90. - latmin)
del = 2.*lat_lim/FLOAT(ncell)

; use area weighting to populate cells
mlt_img = REPLICATE(0.,mcell,mcell)
mlt_cnt = REPLICATE(0.,mcell,mcell)
total_cnts=0.

case sphere of
1: begin
  ; ======= northern hemisphere ==========
; transform from lat/lon to cartesian coordinates
  xpr = lat_lim + (90. - lat_mag)*sin(15.D * mlt * !DTOR)
  ypr = lat_lim - (90. - lat_mag)*cos(15.D * mlt * !DTOR)

  FOR j=0,nypix-1 DO BEGIN
    FOR i=0,nxpix-1 DO BEGIN
;    m = FLOOR(xpr(i,j)/del)
;    n = FLOOR(ypr(i,j)/del)
      m = xpr(i,j)/del
      n = ypr(i,j)/del
      IF (lat_mag(i,j) GT latmin) THEN BEGIN
        mlt_img(m,n) = mlt_img(m,n) + image(i,j)
        mlt_cnt(m,n) = mlt_cnt(m,n) + 1
        total_cnts=total_cnts+image(i,j)
      ENDIF
    ENDFOR
  ENDFOR

; create mlt and lat arrays
  x = (del*FINDGEN(mcell) - lat_lim) # REPLICATE(1.,mcell)
  y = TRANSPOSE(x)
  mlat = 90. - SQRT(x*x + y*y)
  mlon = (ATAN(-x,y)/!DTOR + 180.)/15.

; fill in undersampled bins within the MLT dial
  usndx = WHERE(mlt_cnt EQ 0. AND mlat GE latmin,uscount)
  subarr = FLTARR(3,3)
  tmp_img = REPLICATE(0.,mcell,mcell)
  IF (uscount GT 0) THEN BEGIN
    FOR i=0,uscount-1 DO BEGIN
      m = usndx(i) MOD mcell
      n = FLOOR(1.*usndx(i)/mcell)
      IF (m*n GT 0 AND m LT mcell-1 AND n LT mcell-1) THEN BEGIN
        subimg = mlt_img(m-1:m+1,n-1:n+1)
        subcnt = mlt_cnt(m-1:m+1,n-1:n+1)
        good_ndx = WHERE(subcnt GT 0,ngdndx)
        IF (ngdndx GT 0) THEN $
;         tmp_img(m,n) = TOTAL(subimg(good_ndx))/ngdndx
           tmp_img(m,n) = TOTAL(subimg(good_ndx))/total(subcnt(good_ndx))
      ENDIF
   ENDFOR
  ENDIF
  mlt_img = mlt_img + tmp_img
  endcase

-1: begin  

;========== southern hemisphere =========
; transform from lat/lon to cartesian coordinates
  xpr = lat_lim - (-90. - lat_mag)*sin(15.D * mlt * !DTOR)
  ypr = lat_lim + (-90. - lat_mag)*cos(15.D * mlt * !DTOR)

  FOR j=0,nypix-1 DO BEGIN
    FOR i=0,nxpix-1 DO BEGIN
;    m = FLOOR(xpr(i,j)/del)
;    n = FLOOR(ypr(i,j)/del)
      m = xpr(i,j)/del
      n = ypr(i,j)/del
      IF (lat_mag(i,j) LT -latmin) THEN BEGIN
        mlt_img(m,n) = mlt_img(m,n) + image(i,j)
        mlt_cnt(m,n) = mlt_cnt(m,n) + 1
        total_cnts=total_cnts+image(i,j)
;        print,m,n,xpr[i,j],ypr[i,j],i,j
      ENDIF
    ENDFOR
  ENDFOR

; create mlt and lat arrays
  x = (del*FINDGEN(mcell) - lat_lim) # REPLICATE(1.,mcell)
  y = TRANSPOSE(x)
  mlat = 90. - SQRT(x*x + y*y)
  mlon = (ATAN(-x,y)/!DTOR + 180.)/15.

; fill in undersampled bins within the MLT dial
  usndx = WHERE(mlt_cnt EQ 0. AND mlat GE latmin,uscount)
  subarr = FLTARR(3,3)
  tmp_img = REPLICATE(0.,mcell,mcell)
  IF (uscount GT 0) THEN BEGIN
    FOR i=0,uscount-1 DO BEGIN
      m = usndx(i) MOD mcell
      n = FLOOR(1.*usndx(i)/mcell)
      IF (m*n GT 0 AND m LT mcell-1 AND n LT mcell-1) THEN BEGIN
        subimg = mlt_img(m-1:m+1,n-1:n+1)
        subcnt = mlt_cnt(m-1:m+1,n-1:n+1)
        good_ndx = WHERE(subcnt GT 0,ngdndx)
        IF (ngdndx GT 0) THEN $
;         tmp_img(m,n) = TOTAL(subimg(good_ndx))/ngdndx
           tmp_img(m,n) = TOTAL(subimg(good_ndx))/total(subcnt(good_ndx))
      ENDIF
   ENDFOR
  ENDIF

  mlt_img = mlt_img + tmp_img
  endcase
;==========================================
endcase

; average all bins
mlt_cnt = mlt_cnt > 1.  ; make sure we do not divide by 0
mlt_img = mlt_img/mlt_cnt
;
;print,'before scaling: ',max(mlt_img),mean(mlt_img),$
;	total_cnts,total(mlt_img),total_cnts/total(mlt_img)
;
;mlt_img=mlt_img*total_cnts/total(mlt_img)

END
