;@(#)fuv_init.pro	1.2 08/25/99
;
; Removed Z-Buffer plot option and added X-window plot option. (K.M)
;------------------------------------------------------------------------------------
; This the latest version of GIFWALK program.  Applying the FUV modification to it
;
;Modified:
;
; Hassan Dougani	10/04/1999			Applying the lastes FUV modifications
; Hassan Dougani	10/28/1999			Modify structures for multiple Instrument capability
; Hassan Dougani	02/10/2000			Added initialization values for scaling and MOUSE_EVENT
; Thomas Immel           2001                           Tuned to work with ENV variables 
; Dirk Lummerzheim      11/20/2002                       ~/.fuview/fuview.cfg checking improved
; Harald Frey           03/15/2006                      added keyword fast
;
;------------------------------------------------------------------------------------
;--- added mkblack keyword to not set X device colors- TJI
;
;
pro fuv_init,  retval, mkblack=mkblack,emission_alt=emission_alt, fast=fast
;
;Common block
@fuv_cmnblk

;if keyword_set(emission_alt) gt 0 then begin
;  print,emission_alt
;  print,'that was the emission alt passed to fuv_init'
;endif

;
;Set Operating system specific parameters
;
 case !VERSION.OS_FAMILY of
 'Windows':	begin
 				Dir_sep='\'
 				win_dev='WIN'
 			end
 'unix':	begin
 				Dir_sep='/'
 				win_dev='X'
 			end
 'vms':		begin
 				Dir_sep='.'
 				win_dev='X'
 			end
 'MacOS':	begin
 				Dir_sep=':'
 				win_dev='MAC'
 			end
 else:		begin
 				print,'you have to add supporting operating system to fuview.pro'
 				stop
 			end
 endcase
 ;
 if (float(!version.release) lt 5.2) then $
	print, 'Some of the program features may not be supported with your IDL release ver ',$
			!version.release
 if (float(!version.release) lt 5.3) then $
	res=DIALOG_MESSAGE('Some of the program features may not be supported with your IDL release ver '+$
			!version.release)
;
;define file related variables
;
  CALFILES= ' '
  CALFILES=replicate(CALFILES,3)		;calibration filenames
  cdf_id=lonarr(3)						;CDF of UDF file IDs
  L1DIR=' '
  L1DIR = replicate(L1DIR,3)			;CDF/UDF file directory path
  L1DIRFILE=' '
  L1DIRFILE=replicate(L1DIRFILE,3)		;CDF/UDF full filename
;
;get current Programs File Path
;  cd, CURRENT=FILE_PATH
;

;--- never will this next part run on a Mac. TJI
;--- unless it is an OS X machine! TJI 


;get Configuration file name
;  spawn,'ls $HOME/.fuview/fuview.cfg',home_cfg_file
;  if strlen(home_cfg_file(0)) gt 6 then begin
;    cfg_file=home_cfg_file(0)
;    print,'Using custom config file in ~/.fuview'
;  endif else cfg_file=FILE_PATH+Dir_sep+'fuview.cfg'
;
   cfg_file = findfile(getenv('HOME')+'/.fuview/fuview.cfg', count=test)
   if test le 0 then cfg_file=FILE_PATH+Dir_sep+'fuview.cfg' $
                else print,'Using custom config file in ~/.fuview'

  openr,unit,cfg_file,/get_lun
;
tmp=''
err_ret=1
;
;get data files path
;
fmt='(a120)'								; Format to read a configuration files
;
readf,unit,format=fmt,tmp
if (STRPOS(tmp,'1-') eq -1) then return
equal=STRPOS(tmp,'=')
if (equal eq -1) then return
DATA_PATH=STRTRIM(STRMID(tmp,equal+1,STRLEN(STRTRIM(tmp))),2)
print,'Read data path as:        ',data_path
;
;get ciamap file path
readf,unit,format=fmt,tmp
if (STRPOS(tmp,'2-') eq -1) then return
equal=STRPOS(tmp,'=')
if (equal eq -1) then return
CIAMAPFILE=STRTRIM(STRMID(tmp,equal+1,STRLEN(STRTRIM(tmp))),2)
print,'Using this CIA map file:  ',ciamapfile
;
;get APEX File
readf,unit,format=fmt,tmp
if (STRPOS(tmp,'3-') eq -1) then return
equal=STRPOS(tmp,'=')
if (equal eq -1) then return
APEXFILE=STRTRIM(STRMID(tmp,equal+1,STRLEN(STRTRIM(tmp))),2)
print,'Using this magnetic file: ', APEXFILE
;
;get program file path
readf,unit,format=fmt,tmp
if (STRPOS(tmp,'4-') eq -1) then return
equal=STRPOS(tmp,'=')
if (equal eq -1) then return
file_path=STRTRIM(STRMID(tmp,equal+1,STRLEN(STRTRIM(tmp))),2)
print,'Program file path:        ', file_path
;
;get WIC Calibration file
;readf,unit,format=fmt,tmp
;if (STRPOS(tmp,'4-') eq -1) then return
;equal=STRPOS(tmp,'=')
;if (equal eq -1) then return
;CALFILES(0)=STRTRIM(STRMID(tmp,equal+1,STRLEN(STRTRIM(tmp))),2)
;
;get SI12 Calibration file
readf,unit,format=fmt,tmp
if (STRPOS(tmp,'5-') eq -1) then return
equal=STRPOS(tmp,'=')
if (equal eq -1) then return
CALFILES(1)=STRTRIM(STRMID(tmp,equal+1,STRLEN(STRTRIM(tmp))),2)
;
;get SI13 Calibration file
readf,unit,format=fmt,tmp
if (STRPOS(tmp,'6-') eq -1) then return
equal=STRPOS(tmp,'=')
if (equal eq -1) then return
CALFILES(2)=STRTRIM(STRMID(tmp,equal+1,STRLEN(STRTRIM(tmp))),2)

readf,unit,format=fmt,tmp
if (STRPOS(tmp,'7-') eq -1) then return
equal=STRPOS(tmp,'=')
if (equal eq -1) then return
KEO_GIFPATH=STRTRIM(STRMID(tmp,equal+1,STRLEN(STRTRIM(tmp))),2)
KEO_ASCIIPATH=STRTRIM(STRMID(tmp,equal+1,STRLEN(STRTRIM(tmp))),2)
print,'Output into directory:    ',KEO_GIFPATH

readf,unit,format=fmt,tmp
if (STRPOS(tmp,'8-') eq -1) then return
equal=STRPOS(tmp,'=')
if (equal eq -1) then return
print_black_white=STRTRIM(STRMID(tmp,equal+1,STRLEN(STRTRIM(tmp))),2)

readf,unit,format=fmt,tmp
if (STRPOS(tmp,'9-') eq -1) then return
equal=STRPOS(tmp,'=')
if (equal eq -1) then return
print_color=STRTRIM(STRMID(tmp,equal+1,STRLEN(STRTRIM(tmp))),2)

;path_holder=strarr[10]
path_holder=[data_path,keo_gifpath,keo_asciipath]
file_holder=[ciamapfile,apexfile]

path_sizer=size(path_holder)
file_sizer=size(file_holder)

;--- 3-27-2001, TJI
;--- This new section allows one to provide environment variables in the fuview.cfg file
;--- Dialog_pickfile cannot seem to resolve env vars, so this is needed
;--- for ease of use.

;--- this is now UNIX only!!! Sorry!
;--- On other systems, either do not use environment vars for pathnames
;--- or add brains to this section.


for i=0,path_sizer(1)-1 do begin
  if strpos(path_holder(i),'$') ne -1 then begin
    ;spawn,'ls -d ' + path_holder(i) + '/.' ,new_name
    spawn,'ls -d ' + path_holder(i),new_name
;    print,path_holder(i),new_name
    path_holder(i)=new_name
  endif
endfor

for i=0,file_sizer(1)-1 do begin
  if strpos(file_holder(i),'$') ne -1 then begin

    spawn,'ls ' + file_holder(i) ,new_name
;    print,file_holder(i),new_name
    file_holder(i)=new_name
  endif
endfor


data_path=path_holder(0)
keo_gifpath=path_holder(1)
keo_asciipath=path_holder(2)
ciamapfile=file_holder(0)
apexfile=file_holder(1)

gifdir=keo_gifpath

;print,keo_gifpath,'keo_gifpath'
;print,data_path,'data_path'

;--- end new section, TJI

close,unit
free_lun,unit
;
; Initialize Parameters
;
  num_colors = 6
  ncols=256
  nsicols=128

  nrows=256
  nsirows=128
  nxpix = ncols
  nypix = nrows
  border = 10
  xwin = 640
  ywin = 460

; Set the emission height   --- THIS IS MUCH EARLIER NOW
;    emis_hgt = 130.0
    if keyword_set(emission_alt) gt 0 then begin
	 emis_hgt=emission_alt
	 print,'Changing emission altitude in fuv_init'
    endif else emis_hgt=130.

;  print, 'Changed it to this'
;    print,emis_hgt, ' using this ',emission_alt


;  maxday_rec=730						; maximum record per day
maxday_rec=1460
  selected_inst=intarr(3)				;Selected instrument for read/display
  avail_inst=intarr(3)					;Available Instruments
  active_inst=intarr(3)
  maxrec=intarr(3)						;Maximum number of record
  dstrsub = {tdata1,hrarr:0,minarr:0,secarr:0,epoch:0.0D}
  dstr=REPLICATE({tdata1},maxday_rec,3)
;
; create structure
;
; Structure changes : added airglow flags
; imagedata_2

  ImageInfo = {Imagedata_2, $
        Inst_Id:' ' ,$		;Instrument Id
        epoch:0.0D	,$		; Timestamp of image (beginning?, center?)
        time:lonarr(2), $          	; Time vector
        rows:256, $			;number of rows
        cols:256, $			;Number of columns
        image:fltarr(nrows,ncols), $	; Image
        spin:0l, $                 	; Spin Number
        radius:0.0,$			; Distance from coe at start of spin
        hv_phos:0.0,$			;HV Phospher Voltage
        hv_mcp:0.0,$			;HV MCP voltage
        fovscale:0,$			;FOV scale
        spin_phase:0.0D, $          ;Spin Phase Angle
        a_gci3:dblarr(3), $         ; Attitude vector, SV, Direction of true spin axies at snapshot time
        o_gci:dblarr(3) ,$          ; Orbit Position vector
        hfov:0.0D, $			;Horizontal FOV
        vfov:0.0D, $			;Vertical FOV
        inst_azimuth:0.0D , $		;Angular offset between the WIC center and S/C +X
        inst_co_elev:0.0D , $		;Tilt of instrument vertical from S/C +Z
        inst_roll:0.0D , $		;3rd Euler angle INstrument-Spacecraft
        sc_sv:dblarr(3) , $		;Coordinate of spin axis in S/C
        angl_res_r:0.0D, $		;Angular resolution in row
        angl_res_c:0.0D, $		;Angular resolution in Column
        ip:0.0, $                   ; Integration period
        hgt:0.0, $                  ; Height of spacecraft in Re
        src:'', $                   ; Data source (KP, L1, LZ, NRT)
        lat_ctr:0D, $               ; Latitude of center of field of view
        lon_ctr:0D, $               ; Longitude of center of field of view
        min:0.0, $                  ; Image display minimum value
        max:0.0, $                  ; Image display maximum value
        minval:0.0,$			; Image Minimum value
        maxval:0.0,$			; Image Maximum value
        mean:0.0,$			; Image Mean value
        std:0.0,$			; Image Standard Deviation
        l0:dblarr(3), $             ; Look direction of center of FOV
        ra:0D, $                    ; Right ascension of center of FOV
        dec:0D, $                   ; Declination of center of FOv
        emis_hgt:emis_hgt, $        ; Assumed emission height for coords.
        mlat:fltarr(nrows,ncols), $ ; Magnetic latitudes
        mlon:fltarr(nrows,ncols), $ ; Magnetic longitudes
        mlt:fltarr(nrows,ncols) , $ ; Magnetic local times
        mlt_img:fltarr(256,256),$	; Magnetic Image
        glat:fltarr(nrows,ncols),$  ; geographic Latitude
        glon:fltarr(nrows,ncols),$   ; geographic Longitude
	sza:fltarr(nrows,ncols),$    ; solar zenith angles
	dza:fltarr(nrows,ncols),$    ; spacecraft zenith angles
	airglow_scale:fltarr(3),$	; flag for airglow correction
	calibration_flag:0}	     ; flag for calibration
;
  ImageInfo=replicate(ImageInfo,3) ;One copy for each instrument (WIC, SI12, and SI13)
  ImageInfo.src=['HWIC','12LS','13LS']
  
;----NEW STRUCTURE : THOMAS IMMEL
;--- corrected size of mlt_map to 256x256, upgraded structure name to 
;--- SIdata_2   3-22-2001
;--- added airglow flags
;--- SIdata_3 4-30-2001


  SIInfo = {SIdata_3, $
        Inst_Id:' ' ,$		;Instrument Id
        epoch:0.0D	,$		; Timestamp of image (beginning?, center?)
        time:lonarr(2), $          	; Time vector
        rows:128, $			;number of rows
        cols:128, $			;Number of columns
        image:fltarr(nsirows,nsicols), $; Image
        spin:0l, $                 	; Spin Number
        radius:0.0,$			; Distance from coe at start of spin
        hv_phos:0.0,$			;HV Phospher Voltage
        hv_mcp:0.0,$			;HV MCP voltage
        fovscale:0,$			;FOV scale
        spin_phase:0.0D, $          ;Spin Phase Angle
        a_gci3:dblarr(3), $         ; Attitude vector, SV, Direction of true spin axies at snapshot time
        o_gci:dblarr(3) ,$          ; Orbit Position vector
        hfov:0.0D, $			;Horizontal FOV
        vfov:0.0D, $			;Vertical FOV
        inst_azimuth:0.0D , $		;Angular offset between the WIC center and S/C +X
        inst_co_elev:0.0D , $		;Tilt of instrument vertical from S/C +Z
        inst_roll:0.0D , $		;3rd Euler angle INstrument-Spacecraft
        sc_sv:dblarr(3) , $		;Coordinate of spin axis in S/C
        angl_res_r:0.0D, $		;Angular resolution in row
        angl_res_c:0.0D, $		;Angular resolution in Column
        ip:0.0, $                   ; Integration period
        hgt:0.0, $                  ; Height of spacecraft in Re
        src:'', $                   ; Data source (KP, L1, LZ, NRT)
        lat_ctr:0D, $               ; Latitude of center of field of view
        lon_ctr:0D, $               ; Longitude of center of field of view
        min:0.0, $                  ; Image display minimum value
        max:0.0, $                  ; Image display maximum value
        minval:0.0,$			; Image Minimum value
        maxval:0.0,$			; Image Maximum value
        mean:0.0,$			; Image Mean value
        std:0.0,$			; Image Standard Deviation
        l0:dblarr(3), $             ; Look direction of center of FOV
        ra:0D, $                    ; Right ascension of center of FOV
        dec:0D, $                   ; Declination of center of FOv
        emis_hgt:emis_hgt, $ 	    ; Assumed emission height for coords.
        mlat:fltarr(nsirows,nsicols), $ ; Magnetic latitudes
        mlon:fltarr(nsirows,nsicols), $ ; Magnetic longitudes
        mlt:fltarr(nsirows,nsicols) , $ ; Magnetic local times
        mlt_img:fltarr(256,256),$	; Magnetic Image
        glat:fltarr(nsirows,nsicols),$  ; geographic Latitude
        glon:fltarr(nsirows,nsicols),$   ; geographic Longitude
	sza:fltarr(nsirows,nsicols),$    ; solar zenith angles
	dza:fltarr(nsirows,nsicols),$    ; spacecraft zenith angles
	airglow_scale:fltarr(3),$	     ; flag for airglow correction
	calibration_flag:0}	     ; flag for calibration
;
  SIInfo=replicate(SIInfo,3) ;One copy for each instrument (WIC, SI12, and SI13)
			 ;You know that you will not be using this for WIC,
			 ;but you also know that ImageInfo won't be used for
			 ;SI.

  SIInfo.src=['HWIC','12LS','13LS']
;  Instruments indices are assigned as follow:
;   0 =  WIC
;   1 = SI12
;   2 = SI13
;
  imageinfo[0].inst_id='WIC '
  imageinfo[1].inst_id='SI12 '
  imageinfo[2].inst_id='SI13 '
  
  active_inst = 0					; Default WIC is active instrument.
  current = -1						; current record -1 means no record has been read
  prevrec = -1						; prevrec record -1 means no record has been read
  multi_inst=1						; Single Instrument is default
  drawcont=1
;Set Test Overlay, This condition for testing and will be remove later
  test_latlon=0
;
;Set defulat keogram parameters
;
  keo_delmlt=0.15
  keo_mlt=[0.,6.,12.,18.]
  keo_mlat=[50.,90.]
  keodraw_id=0L
  keo_cfg_chi1=0L
  keo_latres=0.5		;degrees delta
  keo_latmin=50.0		;minimum latitude
  keo_latmax=90.0		;maximum latitude
  keo_mltres=0.25		;MLT delta
  keo_mltmin=0.			;Minmum MLT
  keo_mltmax=24.0		;Maximum MLT
  keo_lonres=2.0		;degrees delta
  keo_lonmin=0.			;Minimum long.
  keo_lonmax=360.		;Maximum long.
  keo_mlt_flg=0		; is set display mlt keogram
  tmp_latres=0.5
  tmp_lonmlt=2.0
  tmp_latmin=50.0
  tmp_latmax=90.0
  tmp_lonmlt_min=0.
  tmp_lonmlt_max=360.0
  tmp_mlt_flg=0
  keo_errmsg=['Error--> Value out of range',$
    		  'Error--> Maximum Value less the Minimum Value',$
     		  'Error--> Invalid Resolution value',$
     		  'Warning--> This setting requires large amount of memory > ',$
     		  'Error--> Invalid Value'$
     		 ]
;  KEO_GIFPATH=DATA_PATH
;  KEO_ASCIIPATH=DATA_PATH

;scaling initialization
;
  scale_type=0				; 0-log scale,  1-Linear scale
  log_scl_min=1
  log_scl_max=300l
  lin_scl_min=0
  lin_scl_max=300l
  lin_scale=0
  slide_min=0
  slide_max=300
;
;mouse event
;
  image_align=7
  y_limit_low=127
  x_limit_low=7
;
;GCI Coordinate flag
  gci_flag=0
;ps and XDR flags
  xdr_flag=0
  ps_flag=0
; airglow correction flags
  airglow_flag=0
  airglow_scale=[0.0,0.0,0]	;[a,b,c] where if d= basic background then
				; airglow= a * (d^b) - c

  calibration_flag=0
  star_flag=1
  fast_flag=0
  if keyword_set(fast) then fast_answer=fast else fast_answer='full'
;
  psp={psparam,xsize:12.8,ysize:9.2,x_off:0.5,y_off:12.0}

;
   def_colr = 1
   retval = 1	;Assume success
   apxfile=''
;
;Set Plotting device
   set_plot, win_dev


    wID = !D.WINDOW

    idl_lib = ''

    ; Load the color table
    color_value_rgb

;    ; Set some colors

if keyword_set(mkblack) le 0 then begin
    !P.BACKGROUND = white_clr
    !P.COLOR = black
endif


    ; Set the emission height   --- DO THIS MUCH EARLIER NOW
;    emis_hgt = 120.0

    ; Set minimum latitude
      latmin = 50.
    ; set hemisphere
      sphere = 1	; north default, south would be -1

	; mark positions
position_long=0.
position_lati=0.

	;Check locations of support files
	result = findfile(CIAMAPFILE, COUNT=count)
	if count eq 0 then begin
		print, "Cannot find " + CIAMAPFILE
		retval = 0;
	endif else begin
	    ; Load the CIA map of latitude/longitude values
	    RESTORE,CIAMAPFILE
            cilat=clat
	    cilon=clon
	endelse

	result = findfile(APEXFILE, COUNT=count)
	if count eq 0 then begin
		printf,  "Cannot find " + APEXFILE
		retval = 0;
	endif else begin
    	apxfile = APEXFILE
    endelse

if keyword_set(emission_alt) gt 0 then begin
  print,'Emission altitude settings in fuv_init:'
  print,emis_hgt, imageinfo.emis_hgt
endif

yeara=2000
doya=197
houra=14
years=2000
doys=197
hours=15

End





