pro create_filename,sc_flag_,time__,xdrfile_name,noext=noext

;  program : create_filename
;  author  : Thomas Immel
;  date    : 3-22-2001
;  purpose : take the timestamp from imageinfo.time and return a text
;	   : string in the format xxxyyyydddhhmm.idl where xxx is 
;	     either wic, s12, or s13
;



time_=time__
sc_flag=sc_flag_
extension='.idl'
if keyword_set(noext) eq 1 then extension=''


case sc_flag of 
	0: filestart='wic'
	1: filestart='s12'
	2: filestart='s13'
	else:print,'Problem with sc_flag in create_filename'
endcase


  utseconds_=time_(1)/1000.
  year_=time_(0)/1000
  doy_=time_(0) mod 1000.
  decimal_hours=utseconds_/86400. * 24.
  hr_=0 & min_=0 & sec_=0 & msec_  = 0. 
  time_dec2clock,decimal_hours,hr_,min_,sec_,msec_    ;see ~immel/idl
  shr_=strcompress(hr_,/rem) & smin_=strcompress(min_,/rem)
  if hr_ lt 10 then shr_='0' + shr_ & if min_ lt 10 then smin_='0' + smin_
  xdrfile_name=filestart + strcompress(time_(0),/rem) + $
                                        shr_ + smin_ + extension

return
end