package provide dBTools 1.0
                                                                                
proc dBlistDelete { iL } {

   global UDFPaths
   
   set Len [llength $iL]
   for {set I 0} {$I < $Len} {incr I} {
      set LiNe [lindex $iL $I]
      set Virtual [string trim [lindex $LiNe 0]]
      set TyPe [string trim [lindex $LiNe 4]]
      set U [UDFinvKey [lindex $LiNe 3]]

      set T1  [lindex $LiNe 1]
      scan $T1 "%4d%3d%d" Yr Dy Tm
      set Hr [expr int($Tm / 3600000)]
      set Mn [expr int(($Tm % 3600000) / 60000 )]

      set T2  [lindex $LiNe 2]
      scan $T2 "%4d%3d%d" yR dY Tm
      set hR [expr int($Tm / 3600000)]
      set mN [expr int(($Tm % 3600000) / 60000 )]
 
      UDFdirPaths [lindex $U 0] [lindex $U 1] [lindex $U 2] [lindex $U 3]
      set dbF [file join $UDFPaths(1) [lindex $U 3].$TyPe]
      set fName [format "%s%d%03d%02d%02d" $Virtual $Yr $Dy $Hr $Mn] 

      if [string match I $TyPe] { 
         lappend fList [file join $UDFPaths(2) ${fName}I]
      } else {
         lappend fList [file join $UDFPaths(2) ${fName}D]
         lappend fList [file join $UDFPaths(2) ${fName}H]
      }
      
      set Pos [DBfileDup $dbF.DBF dB $fName]
      set pLen [llength $Pos]
      for { set J 0 } { $J < $pLen } { incr J } {
         set pInfo [lindex $Pos $J]
         lappend dList($dbF) [lindex $pInfo 0]
         lappend nList($dbF) [lindex $dB(KeyList) [lindex $pInfo 1 ]]
      }
   }

   set aDbF [array names dList]
   set nLen [llength $aDbF]
   for { set J 0 } { $J < $nLen } { incr J } {
      set dbF [lindex $aDbF $J]
      DBdbfDelete $dbF.DBF $dList($dbF)
      DBndxDelete $dbF.NDX $nList($dbF)
   }

   set fLen [llength $fList]
   for { set I 0 } { $I < $fLen } { incr I } {
      set fName [lindex $fList $I]
      if [file exists $fName] { file delete -force $fName }
   }
}
