# THIS procedure returns a useable set of times from the input times is
#   they exist and if not a set of default times.
                                                                                
package provide dBTools 1.0
                                                                                
proc dBaskTimes { } {
   global env askANS UDFPaths

# CHECK to see if there is any input time range.  The time field from which
#    comparisions are built come from these.  Use default times if there
#    are no input times.
  
    set bYr  100;  set bDy 1 ; set bHr 0 ; set bMn 0 ; set bSc 0; 
    set eYr 9000;  set eDy 1 ; set eHr 0 ; set eMn 0 ; set eSc 0; 

    if ![string match YEAR $askANS(yRb)] { set bYr $askANS(yRb) }
    if ![string match DAY $askANS(dYb)]  { set bDy $askANS(dYb) }
    if ![string match HR $askANS(hRb)]   { set bHr $askANS(hRb) }
    if ![string match MIN $askANS(mNb)]  { set bMn $askANS(mNb) }
    if ![string match SEC $askANS(sCb)]  { set bSc $askANS(sCb) }
    if ![string match YEAR $askANS(yRe)] { set eYr $askANS(yRe) }
    if ![string match DAY $askANS(dYe)]  { set eDy $askANS(dYe) }
    if ![string match HR $askANS(hRe)]   { set eHr $askANS(hRe) }
    if ![string match MIN $askANS(mNe)]  { set eMn $askANS(mNe) }
    if ![string match SEC $askANS(sCe)]  { set eSc $askANS(sCe) }

    set bMs [expr 3600000 * $bHr + 60000 * $bMn + 1000 * $bSc]
    set eMs [expr 3600000 * $eHr + 60000 * $eMn + 1000 * $eSc]

    return [list $bYr $bDy $bMs $bHr $bMn $bSc $eYr $eDy $eMs $eHr $eMn $eSc]
}
