# THIS procedure installs UDF data bundles. 
#
# NOTE: In this version of the bundle install all bundles must have a 
#    UDFXFER file to show what files are present and in the case of the
#    HD and V bundles, where the files are to be installed.
                                                                                
package provide dBTools 1.0
                                                                                
proc dBaskInstall { } {
   global env askANS SySCmDs UDFPaths

   set owd [pwd]

# THIS is where any data bundles better be

   set HoMe [file join $env(UDF_DATA) PKGS]

# LIST out the contents of the PKGS directory.  If there is nothing
#   there we are done.
                                                                                
   set dFiles [exec $SySCmDs(ls) $HoMe]
   set dLen [llength $dFiles]
   if { $dLen == 0 } { return }

# GET a listing of all possible UDF data bundles.  We will assume a file is
#   a data bundle if it has 5 . separated fields, ends in tgz, and if the
#   third field begins UDF.  Separate the bundle listings into bundles
#   holding PIDFs, VIDFs, and DATA

   set bF "" ; set bpF "" ; set bvF "" 
   for { set I 0 } { $I < $dLen } { incr I } {
      set fName [lindex $dFiles $I]
      set Fields [split $fName "."]
      if { [llength $Fields] == 5 } {
         if [string match [lindex $Fields 4] tgz ] {
            if [string match UDF* [lindex $Fields 2]] {
               set bType [string index [lindex $Fields 2] end]
               switch -exact -- $bType {
                  v  { lappend bvF $fName }
                  p  { lappend bpF $fName }
                  default  { lappend bF $fName }
               }
            }
         }
      }
   }

# MERGE information into one single list

   set bList [list $bpF $bvF $bF]

# INSTALL the data in the order PIDFS, VIDFS, then DATA.  Amazingly enough
#   this just happens to be the order of the list.

   cd $HoMe

   for { set K 0 } { $K < 3 } { incr K } {

# THIS is the bundles and the number of bundles of the data type being
#   processed

      set iB [lindex $bList $K]
      set iLen  [llength $iB]

# LOOP over the bundles

      for { set I 0 } { $I < $iLen } { incr I } {

# BUNDLE name as well as the project and mission of the bundled data

         set fName [lindex $iB $I]
         set Fields [split $fName "."]
         set Pr [lindex $Fields 0]
         set Mi [lindex $Fields 1]

# BASE bundle name (SANS .tgz)

         set PkgN [file rootname $fName]

# MOVE the bundle into the UDF_DATA directory, extract the contents and
#   remove the bundle

         exec $SySCmDs(gzip) -df $fName

	 set status 0
	 if {[catch {exec $SySCmDs(tar) -xmf $PkgN.tar} results]} {
	    if {[lindex $::errorCode 0] eq "CHILDSTATUS"} {
	       set status [lindex $::errorCode 2]
	       puts stderr "POSSIBLE HARD TAR ERROR: $results"
	    } 
         }

         file delete -force $PkgN.tar

# OPEN the transfer file.  This tells us that was in the bundle.  A PIDF
#   bundle does not need to have a UDFXFER bundle.  Do the initial read
#   in the file when opened to skip the XFER line

         if [catch {open UDFXFER r} fd] {
            puts stderr "Found no UDFXFER file in $fName"
            continue
         }
         gets $fd LiNe

# PROCESS according to data type.  Can separate the PIDF processing totally
#   from the V and HD processing. 

         if { $K == 0 } {
            UDFdirPaths $Pr $Mi "" ""
            while { [gets $fd LiNe] >= 0 } {
               scan $LiNe "%s %s" fN EI
               set MvTo [file join $UDFPaths(0) $fN] 
               if [file exists $MvTo] { file delete -force $MvTo }
               file rename -force $fN $MvTo
            }
            close $fd
         } else { 

# PARSE the UDFXFER separating files which have common PMEI homes.
#
#   REMEMBER: Ignore Header files in processing!

            if [info exists fList] { unset fList }
            while { [gets $fd LiNe] >= 0 } {
               scan $LiNe "%s %s" fN EI
               if { [string index $fN end] == "H" } { continue }
               set bName [DBfileBname $fN] 
               lappend fList($EI) $bName
            }
            close $fd

# SET up a few V or HD specific variables

            if { $K == 1 } {
               set pType I
               set eType I
               set A V ; set B I
            } else {
               set pType HD
               set eType D
               set A H ; set B D
            }

# INSTALL files in in groups of common PMEI 

            set iBlk [array names fList]
            set nB [llength $iBlk]
            for { set J 0 } { $J < $nB } { incr J } {
               set EI [lindex $iBlk $J]
               set nF [llength $fList($EI)]
               set Ex [lindex [split $EI / ] 0]
               set In [lindex [split $EI / ] 1]
               UDFdirPaths $Pr $Mi $Ex $In

               set dBe [file join $UDFPaths(1) dBe]

               DBremoveDups $pType $In $fList($EI)
               if { $K == 1 } {
                  for { set L 0 } { $L < $nF } { incr L } { 
                     set bName [lindex $fList($EI) $L]
                     DBvidfToBinary $bName
                     set MvTo [file join $env(UDF_DATA) $Pr $Mi VIDFS ${bName}V]
                     if [file exists $MvTo] { file delete -force $MvTo }
                     file rename -force ${bName}V $MvTo
                     set MvTo [file join $UDFPaths(2) ${bName}I]

                     if [file exists $MvTo] { file delete -force $MvTo }
                     file rename -force ${bName}I $MvTo
                  }
               } else {
                  for { set L 0 } { $L < $nF } { incr L } { 
                     set bName [lindex $fList($EI) $L]
                     set bLen [string length $bName]
                     set vName [string range $bName 0 [expr $bLen - 12]]
                     set vFiles [DBvidfFind $UDFPaths(2) $vName ]
                     if {[string length $vFiles] == 0 } {
                        puts stderr "NO VIDF file for $bName!!"
                        if [file exists ${bName}H] { 
                           file delete -force ${bName}H 
                        }
                        if [file exists ${bName}D] { 
                           file delete -force ${bName}D 
                        }
                        continue
                     }
                     set vF [file join $UDFPaths(2) [lindex $vFiles 0]]
                     set hF [file join $UDFPaths(2) ${bName}H]
                     set dF [file join $UDFPaths(2) ${bName}D]

                     if [file exists $hF] { file delete -force $hF }
                     file rename -force ${bName}H $hF
                     if [file exists $dF] { file delete -force $dF }
                     file rename -force ${bName}D $dF
                     DBautoSwap $vF $hF $dF
                  }
               }
               DBgenEntries $eType $UDFPaths(2) $UDFPaths(2) $dBe $fList($EI) 
               set dbD [file join $UDFPaths(1) $In.$pType.DBF] 
               set dbN [file join $UDFPaths(1) $In.$pType.NDX] 
               set ePos [DBdbfAppend $dbD $dBe]
               DBndxAppend $dbN $dBe $ePos
               if [file exists $dBe] { file delete -force $dBe }
            }
         }
      }
      if [file exists UDFXFER] { file delete -force UDFXFER }
   }
   cd $owd
}
