# THIS procedure deletes selected entries from a database
                                                                                
package provide dBTools 1.0
                                                                                
proc dBaskFixedDel { W } {
   global env askANS UDFPaths
                                           
# THIS is the selected files to delete
                                                                                
   set dFiles [split [$W curselection] ]
   set dFiles [lsort -integer -decreasing $dFiles]
   set dLen [llength $dFiles]
                                                                                
# LOOP over the selections

   set fList ""
   set pList ""
                                                                                
   for { set I 0 } { $I < $dLen } { incr I } {
                                                                                
# GET the information on the selected line
                                                                                
      set LiNe [$W get [lindex $dFiles $I]]

# BUILD the base file name for the file

      set Virtual [lindex $LiNe 0]
      set TyPe [lindex $LiNe 1]
      if [string match PIDF $TyPe] { 
         set U [UDFinvKey [lindex $LiNe 8]]
         UDFdirPaths [lindex $U 0] [lindex $U 1] [lindex $U 2] [lindex $U 3]
         lappend pList [file join $UDFPaths(0) ${Virtual}.pidf.v2]
      } else {
         if [string match VIDF $TyPe] { set TyPe I }
         set Year [lindex $LiNe 2]
         set Day [lindex $LiNe 3]
         set Tm [split [lindex $LiNe 4] ":"]
         set Hr [lindex $Tm 0]
         set Mn [lindex $Tm 1]

         set U [UDFinvKey [lindex $LiNe 8]]
         UDFdirPaths [lindex $U 0] [lindex $U 1] [lindex $U 2] [lindex $U 3]
         set dbF [file join $UDFPaths(1) [lindex $U 3].$TyPe]
         set fName $Virtual$Year$Day$Hr$Mn 

# BUILD up the list of the files we need to delete.

         if [string match I $TyPe] { 
            lappend fList [file join $UDFPaths(2) ${fName}I]
         } else {
            lappend fList [file join $UDFPaths(2) ${fName}D]
            lappend fList [file join $UDFPaths(2) ${fName}H]
         }
      
         set Pos [DBfileDup $dbF.DBF dB $fName]
         set Len [llength $Pos]
         for { set J 0 } { $J < $Len } { incr J } {
            set pInfo [lindex $Pos $J]
            lappend dList($dbF) [lindex $pInfo 0]
            lappend nList($dbF) [lindex $dB(KeyList) [lindex $pInfo 1 ]]
         }
      }
   }

# NOW delete the files

   set aDbF [array names dList]
   set nLen [llength $aDbF]
   for { set J 0 } { $J < $nLen } { incr J } {
      set dbF [lindex $aDbF $J]
      DBdbfDelete $dbF.DBF $dList($dbF)
      DBndxDelete $dbF.NDX $nList($dbF)
   }

# DELETE the lines in the file listing and remove the datafiles

   for { set I 0 } { $I < $dLen } { incr I } {
      $W delete [lindex $dFiles $I]
   }

   set fLen [llength $fList]
   for { set I 0 } { $I < $fLen } { incr I } {
      set fName [lindex $fList $I]
      if [file exists $fName] { file delete -force $fName }
   }

   set pLen [llength $pList]
   for { set I 0 } { $I < $pLen } { incr I } {
      set fName [lindex $pList $I]
      if [file exists $fName] { file delete -force $fName }
   }

   return $dLen
}
