# THIS procedure promotes a requested PODF file. It works only with 
#   archivers which promote data using the UDF protocol. 
#
#   NOTE: This procedure will overwrite existing data!
#
# INPUTS:
#   pList  - the promote list
#   iP     - the Server IP
#   Port   - the port the server listens on
#
# OUTPUTS:
#   pFiles - the file promoted
#   pComp  - the promoted file compression status

package provide Client 1.0

proc CLudfpPromote { pList iP Port sTmO } {
   global PromoteList env UDFPaths tcl_platform

   lappend pList $Port
   if { [CLudfReqSend $pList $iP $Port $sTmO] == 0 } { 
      set PiD [ProPopUps $pList $iP $Port "" "" DOWN]
      return -1
   }

   set bName [lindex $PromoteList 0]
   set fDir  [lindex $PromoteList 1]
   set cCode [lindex $PromoteList 2]

   set pName [file join $UDFPaths(0) ${bName}.pidf.v2 ]

# IF the data already exists on the local on the system delete it and its
#   database entry.  There is a database entry only if the I file exists.

   if [file exists $pName] { file delete -force $pName }

# SET the request names for the files.  If we are promoting compressed 
#   data nuke any stale compressed version which may be lying around

   set pFile ${bName}.pidf.v2 
   if { $cCode == 1 } { 
      append pFile ".gz" 
      if [file exist $pFile] { file delete -force $pFile }
   }

# PUT up the pop up which indicates that the promote is on

   if { [lindex $pList 12] >= 2 } { 
      set PiD [ProPopUps $pList $iP $Port $pFile "" PROWIN]
   }

# NOW request the data

   set Promote [list PIDF $fDir $pFile]
   CLreqUDF $Promote $iP $Port

# DID we get the data?  IF so log it.

   if [file exists $pFile] { 
     if { [file size $pFile] > 0 } { set rV $cCode } else { set rV -1 }
   } else { set rV -1 }

# GET rid of the promote popup

   if { [lindex $pList 12] >= 2 } { 
      if [string match window* $tcl_platform(platform)] {
         if { $PiD >= 0 } { catch { exec [auto_execok taskkill] /PID $PiD } }
      } else { catch {exec kill $PiD} }
   }

   return $rV
}
