# THIS procedure returns a list of servers which are serving the requested
#   data set

package provide Client 1.0

proc CLserverFind { PiD SiD SiP SporT SsrC ScoM } {
   global PromoteList env UDFPaths

   upvar $SiD iD
   upvar $SiP iP
   upvar $SporT porT
   upvar $SsrC srC
   upvar $ScoM scM

# Reform the PID if necessary.  It may contain the EXPERIMENT as part
#  of the ID.  PIDF and VIDF iD's end in t .P or .V respectively

   set lID [split $PiD "."]
   set P2 $PiD
   set P3 $PiD

# P2 holds the base ID - this is one of : [MISSION].[EXPERIMENT] 
#                                         [MISSION].[EXPERIMENT].V
#                                         [MISSION].[EXPERIMENT].P
#
# P3 holds the requested ID which might not be available and then
#   we need to make sure that we check archives with the base ID

   set iDLen [llength $lID]
   if { $iDLen == 3 } {
      set EnD [lindex $lID 2]
      if { ![string match P $EnD] && ![string match V $EnD] } {
           set P2 [lindex $lID 0].[lindex $lID 1] 
      }
   } else { set P2 [lindex $lID 0].[lindex $lID 1].[lindex $lID 3] }

# NOW parse the ClientInfo file to see if we know of any Servers who
#   are providing the data assiciated with iD.
#
# OPEN the ClientInfo file.  If we can't then simply say that there are
#   no servers dealing in this data set.

   set cFile [file join $env(UDF_HOME) Archives ClientInfo]
   if [catch {open $cFile r} fd] { return 0 }
     
# READ the two header lines in the file

   gets $fd LiNe
   gets $fd LiNe

# SET the server count to 0 

   set sN 0

# NOW parse the file entries

   while { [gets $fd LiNe] >= 0 } {
      set nE [llength $LiNe]
      set fC [string index $LiNe 0] 
      if [string match # $fC] { continue }
      switch -exact -- $nE {
         3  {
            scan $LiNe "%s%s%s" iD($sN) iP($sN) porT($sN)
            set srC($sN) UDF
	    set scM($sN) ---
         }
         4  {
            scan $LiNe "%s%s%s%s" iD($sN) iP($sN) porT($sN) srC($sN)
	    set scM($sN) ---
         }
         5  {
            scan $LiNe "%s%s%s%s%s" iD($sN) iP($sN) porT($sN) srC($sN) scM($sN)
         }
      }
      if { [string match $P2 $iD($sN)] || [string match $P3 $iD($sN)] } {
         incr sN 
      }
   }
   close $fd

   return $sN
}
