# THIS procedure sends a request to the Server asking for a UDF H/D file.
#
# Inputs to this routine are:
#
#    Promote : The promote request which depends on what is being asked for
#    sIP     : The Server IP address  
#    sPort   : The Server port number

package provide Client 1.0

proc CLreqUDF { Promote siP sPort} {
   global DataRecv DonE 

# GET the socket and set the buffering

   set s [socket $siP $sPort ]
   fconfigure $s -buffering line

# SEND the promote request

   puts $s $Promote

# OPEN up the file to be transferred

   set fName [lindex $Promote 2]
   if [catch {open $fName w} fd ] {
      puts stderr "CLreqUDF:  CANNOT OPEN FILE $fName"
      return NOFILE
   }

# CONFIGURE both the socket and file to binary 
                                                                                
   fconfigure $fd -translation binary
   fconfigure $s -translation binary

# COPY the file and then clean up

   fcopy $s $fd -command [list CLreqClean $s $fd ]

# IDLE until request has been filled 

   vwait DonE 

# PROBABLY should only unset DonE if it exists.  It should but just in
#   case ...

   if [info exists DonE ] { unset DonE }

   return 1
}
