# THIS procedure promotes the requested PIDF file.  The PIDF is promoted
#   regardless if there is a current file on the system or not.

package provide Client 1.0

proc CLpPromote { pList { sTmO 15000 } } {
   global SySCmDs PromoteList env UDFPaths

# FORM the request iD

   set PROJECT [lindex $pList 1] 
   set MISSION [lindex $pList 2] 
   set EXPERIMENT [lindex $pList 3] 
   set iD $PROJECT.$MISSION.$EXPERIMENT.P

# NOW parse the ClientInfo directory to see if we know of any Servers who
#   are providing this data.

   set cN [CLserverFind $iD cID sIP sPort sSrc sCom]

# SAVE the orginal request list.  

   set oList $pList

# THIS is the popup window control flag

   set DoWin  [lindex $pList 12]

# OBTAIN all of the necessary local UDF paths for this data set.  The
#    paths are returned in the global array variable UDFPaths.  The
#    definitions are:
#          UDFPaths(0) : the PIDF directory
#          UDFPaths(1) : the Database directory
#          UDFPaths(2) : the HD Data directory

   UDFdirPaths [lindex $pList 1] [lindex $pList 2] \
               [lindex $pList 3] [lindex $pList 4]

#  NOW loop over the possible servers and try them 1 by 1 quitting when 
#     the data gets promoted.  The swtich allows for different data sources

   set NoData 1
   set I 0
   while { $NoData && ($I < $cN) } {
      switch -exact -- $sSrc($I) {
         UDF { set Status [CLudfpPromote $pList $sIP($I) $sPort($I) $sTmO]}
         IDFS { set Status [CLidfspPromote $pList $sIP($I) $sPort($I)] }
      }

# GET the file where its supposed to be - unziping it first if necessary

      if { $Status >= 0 } { 
         set OK 1
         set pHere  [lindex $pList 5].pidf.v2
         set pThere [file join $UDFPaths(0) $pHere]
         if { $Status == 1 } { 
            if [catch { exec $SySCmDs(gzip) -df ${pHere}.gz } OuT ] { 
               file delete -force $pHere.gz 
               set OK 0
            } 
         }
	 if $OK {
            CLmakeDTree "" "" "" "" UDFPaths
            file rename -force $pHere $pThere
            set NoData 0
         }
      } else {
         if { $DoWin == 3 } { 
            ProPopUps $oList $sIP($I) $sPort($I) "" "" NOPROWIN
         }
      }
      set pList $oList
      incr I
   }
     
   return 1
}
