# THIS procedure promotes a requested header/data file pair. It works only
#   with archivers which promote data using the IDFS protocol.  There is a
#   check made which prevents data already on the system from being promoted,
#   that is you can not overwrite existing data!
#
# INPUTS:
#   pList  - the promote list
#   UrL    - the server URL with all extensions
#   Port   - the port the server listens on
#
# OUTPUTS:
#   pFiles - the files promoted
#   pComp  - the promoted files compression status
                                                                                
package provide Client 1.0

proc CLidfshdPromote { pList UrL Port pFiles pComp } {
   global PromoteList env UDFPaths tcl_platform

   upvar $pFiles dBGen
   upvar $pComp  fComp

   lappend pList $Port
   set dBGen ""
   if { [CLidfsReqSend $pList $UrL $Port] == 0 } { return }

# LOOP over the promote list.  This is the list of promotable files returned 
#   from the server.  The IDFS promote list is essentially a line from the
#   server database.  We need to break that apart to do our checks and then
#   to get the useful parts to form the data requests.  The list element is
#   a |  separated set of fields.

   set rList $PromoteList
   set PromoteList ""
   set rLen [llength $rList]
   set fComp ""

   for { set I 0 } { $I < $rLen } { incr I } {

# SPLIT apart the fields

      set rE [split [lindex  $rList $I] "|"]
      if { [llength $rE] != 15 } { continue }

# DON'T want vidf data

      if { [lindex $rE 0] == "I" } { continue }

# FORM the base file name

      set Tm [lindex $rE 5]
      set Hr [expr int( $Tm / 3600000)]
      set Mn [expr int(($Tm % 3600000) / 60000 )]
      set bName [format "%s%4d%03d%02d%02d" [lindex $rE 2] \
                            [lindex $rE 3] [lindex $rE 4] $Hr $Mn]

# THIS is the compression code

      set cCode [lindex $rE 11]

# DO NOT promote if the data files exist on the local system.  This has
#   caused problems.  Sometimes the file is there but its not in the data
#   base.  If you ignore the file and always promote sometimes when the
#   local and remote databases to not have the same endtimes to a file and 
#   end up repromoting data you already have (not bad  but a waste of time). 
#   So now if the data exists make sure its listed in the database.  If it
#   is then no promote!
                                                                                
      set hF [file exists [file join $UDFPaths(2) ${bName}H ]]
      set dF [file exists [file join $UDFPaths(2) ${bName}D ]]
      if { $hF && $dF } { 
         set dBF [file join $UDFPaths(1) [lindex $pList 4].HD.DBF]
         set PoS [DBfileDup $dBF dB $bName] 
         if { [llength $PoS] > 0 } { lappend dBGen GOTIT ; continue } 
      }
 
# SET the request names for the files.  If we are promoting compressed 
#   data nuke any stale compressed version which may be lying around

      set dFile ${bName}D 
      set hFile ${bName}H 
      if { $cCode > 0 } { 
         append dFile ".gz" 
         append hFile ".gz" 
         if [file exist $dFile] { file delete -force $dFile }
         if [file exist $hFile] { file delete -force $hFile }
      }

# PUT up the pop up which indicates that the promote is on

      if { [lindex $pList 12] >= 2 } { 
         set PiD [ProPopUps $pList $UrL $Port $hFile $dFile PROWIN]
      }

# NOW request the data

      set Ops "" 
      for { set J 1 } { $J <= 5 } { incr J } { append Ops [lindex $pList $J]+ }
      append Ops [lindex $rE 3]+[lindex $rE 4]+[lindex $rE 5]+
      append Ops 0+${cCode}+xxx
 
      set Promote [list D+$Ops $dFile] 
      CLreqIDFS $Promote $UrL $Port)
      set Promote [list H+$Ops $hFile] 
      if { [CLreqIDFS $Promote $UrL $Port] == 1 } {

# DID we get the data?  IF so log it.

         if { [file exists $dFile]  && [file exists $hFile] } { 
            set hSize [file size $hFile]
            set dSize [file size $dFile]
            if { $hSize > 0 && $dSize > 0 } {
               if { $cCode > 0 } { set cCode 1 }
               lappend fComp $cCode
               lappend dBGen $bName
            } else {
	       if [file exists $dFile] { file delete -force $dFile }
               if [file exists $hFile] { file delete -force $hFile }
            }
         }
      }

# GET rid of the promote popup

      if { [lindex $pList 12] >= 2 } {
         if [string match window* $tcl_platform(platform)] {
	   if { $PiD >= 0 } { catch { exec [auto_execok taskkill] /PID $PiD } }
         } else { catch {exec kill $PiD} OuT }
      } 
   }
}
