# THIS procedure sends the initial request for the IDFS data.  This is the
#   request asking the server to see if there is any data within the 
#   specified time interval for the virtual instrument
#
# THE IDFS server expects to see PMEIV bYr:Dy:Hr:Mm:Ss eYr:Dy:Hr:Mm:Ss  

package provide Client 1.0

proc CLidfsReqSend { pList UrL Port } {
   global DataRecv PromoteList 

   set Status 0

   set urL http://
   append urL $UrL
   append urL /EntriesGet.cgi

   set Ops ""
   for { set I 1 } { $I <= 5 } { incr I } { append Ops [lindex $pList $I]+ }
   set Ms [lindex $pList 8]
   append Ops  [lindex $pList 6]:[lindex $pList 7]
   set Tm  [lindex $pList 8]
   set Hr  [expr int($Tm / 3600000)]
   set Mn  [expr int(($Tm % 3600000) / 60000 )]
   set Ss  [expr int((($Tm % 3600000) % 60000 ) /1000 )]
   append Ops :$Hr:$Mn:$Ss+
   append Ops  [lindex $pList 9]:[lindex $pList 10]
   set Tm  [lindex $pList 11]
   set Hr  [expr int($Tm / 3600000)]
   set Mn  [expr int(($Tm % 3600000) / 60000 )]
   set Ss  [expr int((($Tm % 3600000) % 60000 ) /1000 )]
   append Ops :$Hr:$Mn:$Ss

   if { [catch { upvar #0 [http::geturl ${urL}?$Ops] rV }] == 1 } { 
   puts stderr ERROR
      set rV(status) error
   }

# PUT the returned promotable files into a list

   switch -exact -- $rV(status) {
      ok { 
         set Status 1 
         set PromoteList [split $rV(body) "\n"]
      }
      error { set Status 0 }
      reset { set Status 0 }
      timeout { set Status 0 }
   }

   unset rV

   return $Status
}
