# THIS procedure promotes the requested UDF data.  Data is only promoted
#   if it is not currently on the system.

package provide Client 1.0

proc CLhdPromote { pList { sTmO 15000 } } {
   global SySCmDs PromoteList env UDFPaths

# FORM the request iD

   set PROJECT [lindex $pList 1] 
   set MISSION [lindex $pList 2] 
   set EXPERIMENT [lindex $pList 3] 
   set iD $PROJECT.$MISSION.$EXPERIMENT

# NOW parse the ClientInfo directory to see if we know of any Servers who
#   are providing this data.

   set cN [CLserverFind $iD cID sIP sPort sSrc sCom]

# SAVE the orginal request list.  

   set oList $pList

# THIS is the popup window control flag

   set DoWin  [lindex $pList 12]

# OBTAIN all of the necessary local UDF paths for this data set.  The
#    paths are returned in the global array variable UDFPaths.  The
#    definitions are:
#          UDFPaths(0) : the PIDF directory
#          UDFPaths(1) : the Database directory
#          UDFPaths(2) : the HD Data directory

   UDFdirPaths [lindex $pList 1] [lindex $pList 2] \
               [lindex $pList 3] [lindex $pList 4]

#  NOW loop over the possible servers and try them 1 by 1 quitting when 
#     the data gets promoted.  The switch allows for different data sources

   set NoData 1
   set I 0
   while { $NoData && ($I < $cN) } {
      switch -exact -- $sSrc($I) {
         UDF { CLudfhdPromote $pList $sIP($I) $sPort($I) dBGen fComp $sTmO }
         IDFS { CLidfshdPromote $pList $sIP($I) $sPort($I) dBGen fComp }
      }

# CHECK to see if we got no data because it's already in local database.
#   Remove those cases and reform dBGen

      set Len [llength $dBGen] 

      set tdBGen $dBGen
      set dBGen ""
      set GotIt 0
      for {set J 0} { $J < $Len } { incr J } {
         set bN [lindex $tdBGen $J]
	 if [string match GOTIT $bN] { set GotIt 1 } else { lappend dBGen $bN }
      }

# GET the promoted data to where its supposed to be

      set Len [llength $dBGen] 
      set tdBGen ""
      if { $Len > 0 } { CLmakeDTree "" "" "" "" UDFPaths } 
      for {set J 0} { $J < $Len } { incr J } {
         set bN [lindex $dBGen $J]
         set dName [file join $UDFPaths(2) ${bN}D]
         set hName [file join $UDFPaths(2) ${bN}H]
         if { [lindex $fComp $J] == 1 } {
            set Dhere [file exists ${bN}D.gz] 
            set Hhere [file exists ${bN}H.gz] 
            if { $Dhere && $Hhere } {
               if [catch { exec $SySCmDs(gzip) -df ${bN}D.gz } OuT ] {
                  file delete -force ${bN}D.gz
               } 
               if [catch { exec $SySCmDs(gzip) -df ${bN}H.gz } OuT ] {
                  file delete -force ${bN}H.gz
               } 
            }
         }
         set Dhere [file exists ${bN}D] 
         set Hhere [file exists ${bN}H] 
         if { $Dhere && $Hhere } {
            file rename -force ${bN}D $dName
            file rename -force ${bN}H $hName
            lappend tdBGen $bN
         }
      }

# NOW generate the database entries for the promoted data and stick them
#   into the database

      set dBGen $tdBGen
      set Len [llength $dBGen] 
      if { $Len > 0 } { 
         set NoData 0
         set dbE [file join $UDFPaths(1) D.asc]
         set dBdbf [file join $UDFPaths(1) [lindex $pList 4].HD.DBF]
         set dBndx [file join $UDFPaths(1) [lindex $pList 4].HD.NDX]
         DBgenEntries D $UDFPaths(2) $UDFPaths(2) $dbE $dBGen
         set ePos [DBdbfAppend $dBdbf $dbE]
         DBndxAppend $dBndx $dbE $ePos
         file delete -force $dbE
      } else {
         if { $DoWin == 3 } { 
	    if $GotIt { 
               ProPopUps $oList $sIP($I) $sPort($I) "" "" DATAHERE
	    } else {
               ProPopUps $oList $sIP($I) $sPort($I) "" "" NOPROWIN
            }
         }
      }
      set pList $oList
      incr I
   }
     
   return 1
}
