# THIS procedure makes a bunch of checks to see if the all of the incormation
#    necessary to make an archive has been set and if it looks reasonable.

package provide ArTool 1.0

proc ATvarCheck { Menu Var } {
   global env logW

   upvar $Var V

   set rV 1
   switch -exact -- $Menu {
      ARCHIVE {
         if { [string length $V(type)] == 0 } { 
            $logW insert end "Archive Type not specified\n" rTexT
            set rV 0
         }
 
         if { [string length $V(aDir)] == 0 } { 
            $logW insert end "Archive Directory not specified\n" rTexT
            set rV 0
         }

# CHECK IP to see if it exists and that  it has the correct number of fields.  
#    Check for both Ip4 and then Ip6.

         if { [string length $V(ip)] == 0 } { 
            $logW insert end "Archive IP Address not specified\n" rTexT
            set rV 0
         } else {
            set iPLen [llength [split $V(ip) "."]]
            if { $iPLen != 4 } {
               set iPLen [llength [split $V(ip) ":"]]
               if { $iPLen != 5 } {
                 $logW insert end "Wrong number IP Address fields\n" rTexT
                 set rV 0
               }
            } else {
               set iP [split $V(ip) "."]
               for { set I 0 } { $I < $iPLen } { incr I } {
                  if { [string length [lindex $iP $I]] == 0 } {
                     $logW insert end "Zero length IP Address field\n" rTexT
                     set rV 0
                     break
                  }
               }
            }
         }
  
         if { [string length $V(port)] == 0 } { 
            $logW insert end "Archive Port Number not specified\n" rTexT
            set rV 0
         }
  
         if { [string length $V(aCode)] == 0 } { 
            $logW insert end "Archive Code not specified\n" rTexT
            set rV 0
         } elseif { [string length $V(aCode)] != 3 } {
            $logW insert end "Archive Code must be 3 chararacters\n" rTexT
            set rV 0
         }
  
         if { [string length $V(sDir)] == 0 } { 
            $logW insert end "Archive Data Directory not specified\n" rTexT
            set rV 0
         } 
      }
      ARCHIVE {
         if { [string length $V(aCode)] == 0 } { 
            $logW insert end "Archive Code not specified\n" rTexT
            set rV 0
         } elseif { [string length $V(aCode)] != 3 } {
            $logW insert end "Archive Code must be 3 chararacters\n" rTexT
            set rV 0
         }
  
         if { [string length $V(sDir)] == 0 } { 
            $logW insert end "Archive Data Directory not specified\n" rTexT
            set rV 0
         }
      }
   }
   return $rV
}
