# Get at list of the transactions

package provide ArTool 1.0

proc ATparseLog {  } {
   global asANS

# ONLY parse this logfile if it hasn't aleady been parsed

   if $asANS(Parsed) { return } 

# OPEN the log file

   if [catch {open $asANS(logFile) r} asANS(fd)] {
      puts stderr "UNABLE TO OPEN FILE: $asANS(logFile)"
      return
   } 

# INITIALIZE some of the basic variables

   set asANS(TotTrans) 0
   set asANS(TotBytes) 0
   set asANS(TotHacks) 0
   set asANS(TotPkgs)  0
   set asANS(TotErrs)  0
   set asANS(IP) ""
   set asANS(PkGs) ""

# PARSE the log file.  There are only a few types of messages put in
#   here and they can be distinguished by their first character.
#
# LINES beginning with ( are either Accept query or Send data lines.
#   The second word in the line will be wither Accepted or Sending. 
# LINES beginning with S are error lines indicating that the server is
#   unable to open the file it needs to send.  Line begins SVudfSend
# LINES beginning with H are Hack attempt lines.  First word in line is
#   HACK
# ALL other lines are request lines.  If the fourth word in the line is either
#   a blank or not a valid request then this is probably a hack and will be
#   labeled as such.  
#   Line Format: IP# port PORT# REQUEST 

# EACH transaction has a list associated with it which provides in order:
#    the IP address
#    the transaction time
#    request type (Valid + HACK)
#    the packages sent to it if any
#    the number of bytes sent to it if any

   set asANS(PkgBase) ""
   set asANS(First) 1

   while { !$asANS(Parsed) } {
      set Trans [ATreadTrans]
      if { [llength $Trans] > 0 } { set Tm [ATlogTrans $Trans] }
   }

   set asANS(TotBytes) [format "%9d" $asANS(TotBytes)]
   set asANS(TotHacks) [format "%9d" $asANS(TotHacks)]
   set asANS(TotPkgs)  [format "%9d" $asANS(TotPkgs)]
   set asANS(TotErrs)  [format "%9d" $asANS(TotErrs)]
   set asANS(TotTrans) [format "%9d" $asANS(TotTrans)]
   set asANS(EndT) $Tm
   set asANS(Time) "$asANS(TimeA) TO $asANS(TimeB)"

   ATassemStats
}
