package provide ArTool 1.0

proc AThdvpView { ViD } {
   global arANS sDefs

   ATvarInit VIEWER

   set arANS(0,P) [lindex [split $arANS(cSid) "."] 0]
   set arANS(0,M) [lindex [split $arANS(cSid) "."] 1]
   set arANS(0,E) ""

   switch -exact -- $ViD {
      HD { 
         set NeedSrc 1 
         set NeedTm  1 
         set xL 91
         set Sz  [list 20 18 18 6 10 5 0]  
         set LaB [list "FILE NAME" "BEGINNING TIME" "ENDING TIME" \
                        ACODE DATABASE DBP "ENTRY DATE"]
         set sBy  [list ascii ascii ascii ascii ascii integer integer]  
         set aT DATA
      }
      V  { 
         set NeedSrc 0 
         set NeedTm  1 
         set xL 81
         set Sz  [list 20 18 18 6 5 0]  
         set LaB [list "FILE NAME" "BEGINNING TIME" "ENDING TIME" \
                        ACODE DBP "ENTRY DATE"]
         set sBy  [list ascii ascii ascii ascii integer integer]  
         set aT VIDF
      } 
      P  { 
         set NeedSrc 0 
         set NeedTm  0 
         set xL 50
         set Sz  [list 20 6 0]  
         set LaB [list "FILE NAME" ACODE "ENTRY DATE"]
         set sBy [list ascii ascii integer]  
         set aT PIDF
      } 
   }

   set W   .hdView
   if { [winfo exists $W] == 0 } {
      toplevel $W
      wm title . "$aT ARCHIVE CONTENTS"

      set Wa   $W.top
      set Wb   $W.act
      set Wc   $W.src
      set WcL  $W.src.lab
      set WcR  $W.src.opts
      set Wd   $W.time
      set We   $W.list

      GUIFrame $Wa  -1 pack|top||both|true
      GUIFrame $Wb  -1 pack|top||both|true
      if $NeedSrc {
         GUIFrame $Wc  -1 pack|top||both|true
         GUIFrame $WcL -1 pack|left|w
         GUIFrame $WcR -1 pack|left|w
      }
      if $NeedTm { GUIFrame $Wd  -1 pack|top|w }
      GUIFrame $We  -1 pack|top||both|true

      GUILabel $Wa.lab "$aT ARCHIVE CONTENTS" c \
         pack|left|center|x|true 6 30 "" [list times 16 bold]
      GUIbuttonPush $Wa.quit QUIT pack|right "destroy $W"  6

      GUILabel $Wb.lab "ACTIONS" w pack|left 0 9
      GUIbuttonPush $Wb.query QUERY\nDATABASE pack|left \
           "AThdvpQuery $We.list $ViD" 0 11
      $Wb.query configure -font [list fixed 10]
      GUIbuttonPush $Wb.del DELETE\nENTRY pack|left \
           "AThdvpDelete $We.list $ViD" 0 11
      $Wb.del configure -font [list fixed 10]
      GUIbuttonPush $Wb.clr CLEAR pack|right "$We.list delete 0 end" 0 7
      $Wb.clr configure -font [list fixed 10]

      if $NeedSrc {
         GUILabel $WcL.lab "SOURCE" w grid|0|0 0 9 ""
         set oP(0) N ; set oP(1) H ; set oP(2) 3 ; set oP(5) NO ; set oP(6) YES
         GUudfPMEIV $WcR arANS oP
      }

      if $NeedTm {
         GUILabel $Wd.t1 "BEG TIME" w grid|0|0 0 9
         GUILabel $Wd.t2 "END TIME" w grid|1|0 0 9
                                                                                
         set CoL 1
         set tE [list -- yR dY hR mN sC]
         set arANS(yRb) YEAR ; set arANS(dYb) DAY
         set arANS(hRb) HR ; set arANS(mNb) MIN ; set arANS(sCb) SEC
         set arANS(yRe) YEAR ; set arANS(dYe) DAY
         set arANS(hRe) HR ; set arANS(mNe) MIN ; set arANS(sCe) SEC
         for { set CoL 1 } { $CoL < 6 } { incr CoL } {
            set iD [lindex $tE $CoL]
            set bG ${iD}b ; set eD ${iD}e
            GUIboxEntry $Wd.$bG grid|0|$CoL 6 arANS($bG)
            GUIboxEntry $Wd.$eD grid|1|$CoL 6 arANS($eD)
            $Wd.$bG configure -fg #0000FF
            $Wd.$eD configure -fg #0000FF
                                                                                
            bind $Wd.$bG <Any-Key> {
               if [string match #0000FF [%W cget -fg]] {
                  %W delete 0 end
                  %W configure -fg #000000
               }
            }
            bind $Wd.$eD <Any-Key> {
               if [string match #0000FF [%W cget -fg]] {
                  %W delete 0 end
                  %W configure -fg #000000
               }
            }
         }
         GUIbuttonPush $Wd.reset RESET grid|0|$CoL|news|2 "ATtimeReset $Wd" 6
      }
                                                                                
      GUILabel $We.l1 "$arANS(0,P) / $arANS(0,M)" c grid|0|0|||7 0 0
      set nLab [llength $Sz]
      for { set J 0 } { $J < $nLab } { incr J } {
         set lW $We.l2,$J
         set srt [lindex $sBy $J]
         GUIbuttonPush $lW [lindex $LaB $J] grid|1|$J \
             "ATcolumnSort $We.list $ViD $J increasing $srt" 0 [lindex $Sz $J]
         $lW configure -font [list fixed 10]
      }
      GUIboxList $We.list  $xL 20 grid|2|0|||8 "" multiple 0 1
      $We.list configure -font [list fixed 10]
   }
}
