package provide ArTool 1.0

proc ATconfigGUI { W } {
   global acfgANS sDefs logW

# SEE if there was a selection made
                                                                                
   if { [llength [$W curselection]] == 0 } { return }
                           
# So far so good.  This is the line number in the file.  The actual entries 
#   start at line 2.  The first two lines are comments and cannot be selected.
#   if one of these lines was selected act as if nothing was selected
                                                                                
   set lPos [$W curselection]
   if { $lPos < 2 } { return }

# NOW read the selected line

   scan [$W get $lPos] "%s%s%s" iD Port acfgANS(aDir)

# INITIALIZE the Configure options.  These get used in the case that there
#   is no configure file present

   ATvarInit CONFIG 

# OPEN the configure file and read the contents

   set aCFile [file join $acfgANS(aDir) ArchiveConfig]
   if [catch {open $aCFile r } fd] {
      $logW insert end "NO ArchiveConfig File $aCFile\n"
      set acfgANS(aID) $iD
   } else {
      while { [gets $fd LiNe] > 0 } {
         set Flds [split $LiNe "|"]
         set acfgANS([lindex $Flds 0]) [lindex $Flds 1]
         set acfgANS(_[lindex $Flds 0]) [lindex $Flds 1]
      }
      close $fd
   } 

# SET up the time interval

  if { $acfgANS(bTime) == 0 } {
     set acfgANS(uTime) 0
     set acfgANS(tBase) 3600000
     set Plab Hours
  } else {
     set acfgANS(uTime) [expr $acfgANS(bTime) / 3600000.0]
     if { $acfgANS(uTime) > 1.0 } {
        set acfgANS(tBase) 3600000
        set Plab Hours
     } else {
        set acfgANS(uTime) [expr ($acfgANS(bTime) % 3600000) / 60000.0]
        if { $acfgANS(uTime) > 1.0 } {
           set acfgANS(tBase) 60000
           set Plab Minutes
        } else {
           set acfgANS(uTime) [expr ($acfgANS(bTime) % 60000) / 1000.0]
           set acfgANS(tBase) 1000
           set Plab Seconds
        }
     }
  }
  set acfgANS(uTime) [format "%.2f" $acfgANS(uTime)] 
   
# OPEN the GUI
 
   set W .aConfig
   if { [winfo exists $W] == 0 } {
      toplevel $W
      wm title . "ARCHIVE CONFIGURATION MENU"

      set Wa  $W.top
      set WaR $Wa.right
      set WaL $Wa.left
      set Wb  $W.mid
      set Wc  $W.bot

      GUIFrame $Wa -1 pack|top||x|true
      GUIFrame $Wb -1 pack|top||x|true
      GUIFrame $Wc -1 pack|top||x|true 
      GUIFrame $WaL 0 pack|left|w|x|true -1 10
      GUIFrame $WaR 0 pack|right|e|x -1 10

      GUILabel $WaL.lab "ARCHIVE CONFIGURATION\n$iD" c pack|left|center|x|true \
         6 30 "" [list times 16 bold]
      GUIbuttonPush $WaR.quit QUIT pack|right|e "destroy $W" 6 0 groove

      set cOP [list ON|1 OFF|0]
      set tbOP [list Hours|3600000 Minutes|60000 Seconds|1000]

      set R 0
      GUILabel $Wb.lsf "STATUS FILE" w grid|$R|0|w 6 -1 Black
      GUIboxEntry $Wb.sf grid|$R|1|w||8 40 acfgANS(fStatus)
      incr R
      GUILabel $Wb.ltime "UPDATE INTERVAL" w grid|$R|0|w 6 -1 Black
      GUIboxEntry $Wb.tm grid|$R|1|w 7 acfgANS(uTime)
      GUIbuttonMenu $Wb.tb "" grid|$R|2|w||7 $tbOP  \
             "GUIoptsProcess .aConfig.mid.tb acftANS(tBase) ALT " 6
      incr R
      GUILabel $Wb.lacode "ARCHIVE CODE" w grid|$R|0|w 6 -1 Black
      GUIboxEntry $Wb.acode grid|$R|1|w||7 7 acfgANS(aCode)
      incr R
      GUILabel $Wb.lccode "COMPRESSION" w grid|$R|0|w 6 -1 Black
      GUIbuttonToggle $Wb.ccode "" grid|$R|1|w||7 $cOP  \
           "GUIoptsToggle .aConfig.mid.ccode acfgANS(cCode) ALT " 6
      incr R
      GUIblankRow $Wb $R 1
      incr R
      GUIbuttonPush $Wc.doit "UPDATE" pack|left ATconfigChg  6 0 groove
      GUIbuttonPush $Wc.reset "RESET" pack|right "ATmenuReset ACONFIG" \
         6 0 groove

      set newText [lindex [GUinverseOpts $Wb.ccode $acfgANS(cCode)] 0]
      $Wb.ccode configure -text $newText
      set newText [lindex [GUinverseOpts $Wb.tb $acfgANS(tBase)] 0]
      $Wb.tb configure -text $newText
   } else { GUIwindowCtrl $W }
}
