# PUTS up the hack statistics. 

package provide ArTool 1.0

proc ATassemPlot { Plot Grid gInfo } {
   global asANS

   upvar $Grid  G
   upvar $gInfo gI

   scan $asANS(EndT) "%4d%3d%5d" eY eD eS
   scan $asANS(BegT) "%4d%3d%5d" bY bD bS
   set DayO [ATplotGrid $bY $bD $eY $eD gI]

   set gI(10) NEW
   TUdataGrid 1 1 X X 1 Y Y V G gN gI 
   set gI(10) ADD

   set Y(0) 0.0
   set ipLen [llength $asANS(IP)] 
   switch -exact -- $Plot {
      CONNECTS { 
         for { set I 0 } { $I < $ipLen } { incr I } {
            set ipInfo [lindex $asANS(IP) $I]
            scan [lindex $ipInfo 1] "%4d%3d%5d" Yr Dy Sc
            set AddD [lindex $DayO [expr $Yr - $bY]]
            set X(0) [expr $AddD + $Dy - $bD + 0.5]
            set V(0) 1.0
            TUdataGrid 1 1 X X 1 Y Y V G gN gI 
         }
      }
      REQUESTS  { 
         for { set I 0 } { $I < $ipLen } { incr I } {
            set ipInfo [lindex $asANS(IP) $I]
            scan [lindex $ipInfo 1] "%4d%3d%5d" Yr Dy Sc
            set AddD [lindex $DayO [expr $Yr - $bY]]
            set X(0) [expr $AddD + $Dy - $bD + 0.5]
            set V(0) [lindex $ipInfo 2]
	    if ![string match HACK $V(0)] {
	       set V(0) 1.0
               TUdataGrid 1 1 X X 1 Y Y V G gN gI 
            }
         }
      }
      HACKS    { 
         for { set I 0 } { $I < $ipLen } { incr I } {
            set ipInfo [lindex $asANS(IP) $I]
            scan [lindex $ipInfo 1] "%4d%3d%5d" Yr Dy Sc
            set AddD [lindex $DayO [expr $Yr - $bY]]
            set X(0) [expr $AddD + $Dy - $bD + 0.5]
            set V(0) [lindex $ipInfo 2]
	    if [string match HACK $V(0)] {
	       set V(0) 1.0
               TUdataGrid 1 1 X X 1 Y Y V G gN gI 
            }
         }
      }
      PACKAGES  {  
         for { set I 0 } { $I < $ipLen } { incr I } {
            set ipInfo [lindex $asANS(IP) $I]
            scan [lindex $ipInfo 1] "%4d%3d%5d" Yr Dy Sc
            set AddD [lindex $DayO [expr $Yr - $bY]]
            set X(0) [expr $AddD + $Dy - $bD + 0.5]
            set V(0) [lindex $ipInfo 3]
	    if { [string length $V(0)] > 0 } {
	       set V(0) 1.0
               TUdataGrid 1 1 X X 1 Y Y V G gN gI 
            }
         }
      }
      BYTES    { 
         for { set I 0 } { $I < $ipLen } { incr I } {
            set ipInfo [lindex $asANS(IP) $I]
            scan [lindex $ipInfo 1] "%4d%3d%5d" Yr Dy Sc
            set AddD [lindex $DayO [expr $Yr - $bY]]
            set X(0) [expr $AddD + $Dy - $bD + 0.5]
            set V(0) [lindex $ipInfo 4]
            TUdataGrid 1 1 X X 1 Y Y V G gN gI 
         }
      }
   }
}
