package provide ArTool 1.0

proc ATarchiveView { W } {
   global arANS 

# SEE if there was a selection made.  If not nothing to do
                                                                                
   if { [llength [$W curselection]] == 0 } { return }
                           
# YES there was.  This is the line number in the list box.  The actual 
#    entries start at line 2.  The first two lines are comments and cannot 
#    be selected.  If one of these lines was selected act as if nothing 
#    was selected
                                                                                
   set lPos [$W curselection]
   if { $lPos < 2 } { return }

# NOW read the selected line

   scan [$W get $lPos] "%s%s%s" arANS(cSid) arANS(cSport) arANS(cSdir)
   set ComPs [split $arANS(cSid) "."]
   if { [llength $ComPs] == 2 } { 
      set ViD HD
   } else { set ViD [lindex $ComPs 2] }

# THE content display is different based on the archive type

   switch -exact -- $arANS(cSid) {
       software { ATsoftwareView }
       default  { AThdvpView $ViD }
   }
}
