package provide ArTool 1.0

proc ATarchiveAdd { } {
   global arANS env logW

# CHECK that all the information is there

   if ![ATvarCheck ARCHIVE arANS] return

# FORM the archive iD

   set iD $arANS(0,P)
   if { [string length $arANS(0,M)] > 0 } { append iD .$arANS(0,M) }
   if { [string length $arANS(iD3)] > 0 } { append iD .$arANS(iD3) }

# UPDATE the ServerInfo file if we are supposed to.  This may entail creating
#    both it and the directory in which it resides.

   if [string match YES $arANS(sInfo)] { 

# INITIALIZE NoFile flag to indicate that the file we are after is not on the
#   the system

      set NoFile 1

# SEE what exists and create what doesn't

      if [info exists env(UDF_HOME)] {
         set aDir [file join $env(UDF_HOME) Archives]
         set Fname [file join $aDir ServerInfo]
         if [file exists $Fname] { set NoFile 0 }
      } else {
         lappend Msg "ENVIRONMENT variable UDF_HOME does not exist"
         lappend Msg "MUST be set prior to updating the ServerInfo file"
         GUImsgPopUp .ewin -1 -1 $Msg
         return -1
      } 

# IF we didn't find a file present then create the skeleton file.  This may
#   require creating the directory its in also.

      if $NoFile {
         if ![file isdirectory $env(UDF_HOME)]  {
            $logW insert end "CREATING directory $env(UDF_HOME)\n"
            file mkdir $env(UDF_HOME)
         }
         if ![file isdirectory $aDir]  {
            $logW insert end "CREATING directory $aDir\n"
            file mkdir $aDir
         }

         if [catch {open $Fname w} fd] {
            $logW insert end "UNABLE TO CREATE $Fname\n"
            $logW insert end "   You might need run as root.\n"
            return
         }

         $logW insert end "CREATING skeleton ServerInfo File\n"
         set LFmt "%-25s %-8s %s"
         puts $fd [format $LFmt "Archive ID" " Port " "Archive Directory"]
         puts $fd [format $LFmt "----------" "------" "-----------------"]
         close $fd
      }

      if [catch {open $Fname a} fd] {
         $logW insert end "UNABLE TO CREATE $Fname\n"
         $logW insert end "   You might need run as root.\n"
         return
      }

      $logW insert end "UPDATING ServerInfo File\n"
      set Len [expr [string length $arANS(aDir)] + 2]
      set LFmt "%-25s %6s %${Len}s"
      puts $fd [format $LFmt $iD $arANS(port) $arANS(aDir)]
      close $fd
      if [winfo exists .aWin] {
        .aWin.mid.log insert end [format $LFmt $iD $arANS(port) $arANS(aDir)]
      }
   }

# UPDATE the ArchiveInfo file if we are supposed to.  This may entail creating
#    both it and the directory in which it resides.  The operations are 
#    identical to updating the ServerInfo File

   if [string match YES $arANS(aInfo)] { 
      set NoFile 1
      set LFmt "%-14s %s"

      if [info exists env(UDF_HOME)] {
         set aDir [file join $env(UDF_HOME) Archives]
         set Fname [file join $aDir ArchiveInfo]
         if [file exists $Fname] { set NoFile 0 }
      } else {
         lappend Msg "ENVIRONMENT variable UDF_HOME does not exist"
         lappend Msg "MUST be set prior to updating the ArchiveInfo file"
         GUImsgPopUp .ewin -1 -1 $Msg
         return -1
      } 

      if $NoFile {
         if ![file isdirectory $env(UDF_HOME)]  {
            $logW insert end "CREATING directory $env(UDF_HOME)\n"
            file mkdir $env(UDF_HOME)
         }
         if ![file isdirectory $aDir]  {
            $logW insert end "CREATING directory $aDir\n"
            file mkdir $aDir
         }

         if [catch {open $Fname w} fd] {
            $logW insert end "UNABLE TO CREATE $Fname\n"
            $logW insert end "   You might need run as root.\n"
            return
         }

         $logW insert end "CREATING skeleton ArchiveInfo File\n"
         puts $fd [format $LFmt "Archive Code" "Data Location"]
         puts $fd [format $LFmt "------------" "-------------"]
         close $fd
      }

      if [catch {open $Fname a} fd] {
         $logW insert end "UNABLE TO CREATE $Fname\n"
         $logW insert end "   You might need run as root.\n"
         return
      }

      $logW insert end "UPDATING ArchiveInfo File\n"
      puts $fd [format $LFmt $arANS(aCode) $arANS(sDir)]
      close $fd
      if [winfo exists .sWin] {
        .sWin.mid.log insert end [format $LFmt $arANS(aCode) $arANS(sDir)]
      }
   }

# UPDATE the ClientEntry file if we are supposed to.  

   if [string match YES $arANS(client)] { 
      if [info exists env(UDF_HOME)] {
         set aDir [file join $env(UDF_HOME) Archives]
         set Fname [file join $aDir ClientEntry]
      } else {
         lappend Msg "ENVIRONMENT variable UDF_HOME does not exist"
         lappend Msg "MUST be set prior to updating the ClientEntry file"
         GUImsgPopUp .ewin -1 -1 $Msg
         return -1
      } 

      if ![file isdirectory $env(UDF_HOME)]  {
         $logW insert end "CREATING directory $env(UDF_HOME)\n"
         file mkdir $env(UDF_HOME)
      }

      if [file exists $Fname] { set Label 0 } else { set Label 1 }

      if [catch {open $Fname a+} fd] {
         $logW insert end "UNABLE TO CREATE $Fname\n"
         $logW insert end "   You might need run as root.\n"
         return
      }

      if { $Label } {
         $logW insert end "INITIALIZING ClientEntry File\n"
         set LFmt "%-25s %-32s %5s %9s"
         puts $fd [format $LFmt "Server ID" "IP Address" " Port" "Server"]
         puts $fd [format $LFmt "---------" "----------" "-----" "------"]
      }

      $logW insert end "UPDATING ClientEntry File\n"
      set LFmt "%-25s %-32s %5s %9s"
      puts $fd [format $LFmt $iD $arANS(ip) $arANS(port) $arANS(sType)]
      close $fd
   }

# AND finally create the archive directories.  This consists of creating
#    the archive directory and required sub-directories as well as the
#    archive data directory.

   if ![file isdirectory $arANS(aDir)]  {
      $logW insert end "Archive directory $arANS(aDir) Created\n"
      file mkdir $arANS(aDir)
   } else { $logW insert end "Archive directory $arANS(aDir) Exists\n" }

   set aCFile [file join $arANS(aDir) ArchiveConfig] 
   if [catch {open $aCFile w} fd] {
      $logW insert end "UNABLE TO CREATE $aCFile\n"
   } else {
      puts $fd "fStatus|"
      puts $fd "aID|$iD"
      puts $fd "aCode|$arANS(aCode)" 
      puts $fd "bTime|0"
      puts $fd "cCode|$arANS(cCode)"
      close $fd
   }

   set nDir [file join $arANS(aDir) Incoming]
   if ![file isdirectory $nDir]  {
      $logW insert end "Archive incoming directory $nDir Created\n"
      file mkdir $nDir
   } else { $logW insert end "Archive bundle directory $nDir Exists\n" }

   if { $arANS(aOp) != 2 } {
      set nDir [file join $arANS(aDir) Database]
      if ![file isdirectory $nDir]  {
         $logW insert end "Archive database directory $nDir Created\n"
         file mkdir $nDir
      } else { $logW insert end "Archive database directory $nDir Exists\n" }
   }

   if { $arANS(aOp) == 0 } {
      set nDir [file join $arANS(aDir) VIDFS]
      if ![file isdirectory $nDir]  {
         $logW insert end "Archive VIDF directory $nDir Created\n"
         file mkdir $nDir
      } else { $logW insert end "Archive database directory $nDir Exists\n" }
   }

   if ![file isdirectory $arANS(sDir)]  {
      $logW insert end "Archive directory $arANS(sDir) Created\n"
      file mkdir $arANS(sDir)
   } else { $logW insert end "Archive directory $arANS(sDir) Exists\n" }
}
