#  THIS procedure checks to make sure that the directory in which the
#    requested file is to be retrieved is indeed one of the recognized
#    archive directories.  To do this it matches the directory in which
#    the data is to be retrieved against those found in the ArchiveInfo 
#    file.  No match - no data.

package provide Server 1.0

proc SVudfVerify { LiNe } {
   global env ADirs aCodeDir

#  FIRST list element in LiNe is the directory which we split into its 
#    components.  The second element is the file name.  This must be a
#    pure fileaname with no directories attached to it.  It is split
#    to verify this and should file split find a hidden directory then
#    no data.

   set InDir [lindex $LiNe 1]
   set fName [file split [lindex $LiNe 2]]
   set nDir [llength [split $fName]]

   if {$nDir > 1 } { return 0 }

# NOW check the directory in which this file resides against the known
#   archive data directories.

   set Stat 0
   set aDir [array get aCodeDir]
   set aLen [llength $aDir]
   for {set I 1 } { $I < $aLen } { incr I 2 } {
      if [string match $InDir [lindex $aDir $I]] { 
         set Stat 1
         break
      }
   }

   return $Stat
}
