# THIS procedure returns a specific database entry from a software database.
#   The entry is one which matches the input PKG and REV fields.

package provide Server 1.0

proc SVswdbSearch { dB PkG ReV Fields Entry } {
   global env aCodeDir

   upvar $Entry  dBE
   upvar $Fields dBF

   set Status 0

# READ the database.  If rV is not 1 then either the database could not be
#   found or there are no entries in it. 
 
   set rV [SVswdbRead $dB dBF dBE]
   if { $rV != 1 } { return [list $rV 0] }

# SEE if there is an entry for this package in the database.

#  set Pos [lsearch -all $dBE(PKG) $PkG] 

   set pLen [llength $dBE(PKG)]
   set Pos ""
   for { set I 0 } { $I < $pLen } { incr I } {
      if [string match $PkG [lindex $dBE(PKG) $I]] { lappend Pos $I }   
   }

# NOW see if there is a package which has the correct Revision.  A revision
#   of LATEST will return the package with the latest revision number.

   set pLen [llength $Pos]
   if [string match LATEST $ReV] { 
      set bReV 0.0r0 
      for { set J 0 } { $J < $pLen } { incr J } {
         set P [lindex $Pos $J]
         set dR [lindex $dBE(REV) $P]
         if { [SVrevCmp $dR $bReV] >= 0 } { 
            set Status 1
            set pP $P
            set bReV $dR
         }
      }
   } else {
      for { set J 0 } { $J < $pLen } { incr J } {
         set P [lindex $Pos $J]
         set dR [lindex $dBE(REV) $P]
         if { [string compare $dR $ReV] == 0 } { 
            set Status 1
            set pP $P
            break 
         }
      }
   }

   if { $Status == 0 } { set pP 0 } 
   return [list $Status $pP]
}
