# THIS procedure closes out a UDF data file transfer.  It closes the file
#    being sent and records any errors which may have occurred into the LOG
#    file.  It also records the number of bytes transmitted.

package provide Server 1.0

proc SVsendClose {In bytes {error {}}} {
   global DonE sCFG

# IF there was any error - log it.

   if {[string length $error] != 0} {
     if [string match YES $sCFG(log)] {
         puts $sCFG(lfd) "error occurred during send"
         flush $sCFG(lfd)
      }
   }

# CLOSE the file being sent and then set DonE.  Setting DonE frees the
#   Server to process the next request.

   close $In 
   set DonE $bytes

# LOG the number of bytes transmitted

   if [string match YES $sCFG(log)] {
      puts $sCFG(lfd) "($bytes bytes)"
      flush $sCFG(lfd)
   }
}
