#  THIS procedure processes bundles of VIDF files or individual VIDF files.  
#    If the Archive is a header/data archive the VIDF files are converted
#    to binary files and the ASCII files are removed.  If the Archive is 
#    a VIDF archive then the files are just moved to the Archive data
#    directory and compressed if necessary. 
#   
# INPUTS:
#    aDir   - the archive directory
#    arInfo - the archive configuration data
#    pF     - list of files and bundles to process

package provide Server 1.0

proc SVprocVIDFS { aDir arInfo pF } {
   global env aCodeDir SySCmDs

   upvar $arInfo aI

# SAVE the current directory path

   set owd [pwd]

# SEE if there is anything to process.  Find the number of VIDF bundles
#   and individual Files in the directory.

   set nB [llength [lindex $pF 1]]
   set nF [llength [lindex $pF 3]]

   if { ($nB == 0) && ($nF == 0) } { return }

# THIS is the incoming directory for the archive

   set iDir [file join $aDir Incoming]

# THIS is the archive type

   if { [llength [split $aI(aID) "."]] == 3 } {
      set aType V
   } else { set aType D }

# THIS the directory into which the VIDF files are to be put

   if [string match V $aType] {
      set vDir $iDir
   } else { set vDir [file join $aDir VIDFS] }
   if ![file isdirectory $vDir] [file mkdir $vDir]

# GO through all of the VIDF bundles and get the data into the appropariate
#   directory.  All bundles are uncompressed in the Incoming directory but
#   for a HD archive are moved to the VIDF home directory for the untarring.
#   For a VIDF archive they are untarred in the Incoming directory

   cd $iDir
   for { set I 0 } { $I < $nB } { incr I } {
      set bName [lindex [lindex $pF 1] $I]
      exec $SySCmDs(gzip) -df [file join $iDir $bName]
      set fC [split $bName "."]
      set fLen [expr [llength $fC] - 1]
      set tF [lindex $fC 0] 
      for { set J 1 } { $J < $fLen } { incr J } { append tF .[lindex $fC $J] }
      append tF ".tar"

      set MvTo [file join $vDir $tF]
      if ![string match V $aType] {
         set MvFrom [file join $iDir $tF]
         file rename -force $MvFrom $MvTo 
      }

      if { [catch { exec $SySCmDs(tar) -xf $MvTo } eRR ] } {
         if { [string first "lone zero block" $eRR] < 0 } {
             puts stderr "UNRECOVERABLE ERROR!!  $eRR"
	     return 0
	 }
      }

      if [file exists $MvTo] { file delete -force $MvTo }

      set vList [file join $vDir VIDFLIST.A]
      if [file exists $vList] { file delete -force $vList }
   }

   cd $owd

# NOW move all of the single files into the home directory.  This is done
#   only if this is a HD archive.  At this time all the data there so all
#   we have to do is make the binary files

   if ![string match V $aType] {
      for { set I 0 } { $I < $nF } { incr I } {
         set fName [lindex [lindex $pF 3] $I]
         set MvFrom [file join $iDir $fName]
         set MvTo [file join $vDir $fName]
         file rename -force $MvFrom $MvTo 
      }
      set vFiles [exec $SySCmDs(ls) $vDir]
      set vLen [llength $vFiles]
      for { set J 0 } { $J < $vLen } { incr J } {
         set vN [lindex $vFiles $J]
         if { [string index $vN end] == "V" } {
            set EnD [expr [string length $vN] - 2]
            set vN [file join $vDir [string range $vN 0 $EnD]]
            DBvidfToBinary $vN
            file delete -force ${vN}V
         }
      }
   } else {
      set vFiles [exec $SySCmDs(ls) $vDir]
      set vLen [llength $vFiles]

# FORM a Manifest with the EXP field set to VIDF for all entries.  All of
#    the VIDF files are kept in the single database file VIDF.I.DBF

      set ManiFest ""
      for { set J 0 } { $J < $vLen } { incr J } {
         set vN [lindex $vFiles $J]
         if { [string index $vN end] == "V" } {
            set bName [string range $vN 0 [expr [string length $vN] - 2]]
            lappend ManiFest [list $bName VIDF]
         }
      }

# CHECK for and remove duplicate files then update the database

      SVdupsCheck $aDir $ManiFest I
      SVdbAddV $aDir aI $ManiFest
 
# PUT the files where they belong, compressing if necessary

      set vLen [llength $ManiFest]
      set vDir $aCodeDir($aI(aCode))
      for { set J 0 } { $J < $vLen } { incr J } {
         set vN [lindex [lindex $ManiFest $J] 0]V
         if { $aI(cCode) == 1 } { 
             exec $SySCmDs(gzip) -f [file join $iDir $vN] 
             append vN .gz
         }
         set MvFrom [file join $iDir $vN]
         set MvTo [file join $vDir $vN]
         file rename -force $MvFrom $MvTo 
      }
   } 
}
